/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.json;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.marshal.BulkInputStreamWrapper;
import com.unboundid.scim.marshal.json.JsonParser;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.BulkException;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.Status;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonBulkParser
extends JsonParser {
    private final BulkInputStreamWrapper bulkInputStream;
    private final BulkConfig bulkConfig;
    private final BulkContentHandler handler;
    private int operationIndex = 0;
    private JSONTokener tokener;
    private boolean skipOperations;

    public JsonBulkParser(InputStream inputStream, BulkConfig bulkConfig, BulkContentHandler handler) {
        this.bulkInputStream = new BulkInputStreamWrapper(inputStream);
        this.bulkConfig = bulkConfig;
        this.handler = handler;
        this.operationIndex = 0;
    }

    public void setSkipOperations(boolean skipOperations) {
        this.skipOperations = skipOperations;
    }

    public void unmarshal() throws SCIMException {
        try {
            this.tokener = new JSONTokener((InputStream)this.bulkInputStream);
            if (this.tokener.nextClean() != '{') {
                throw this.tokener.syntaxError("A JSONObject text must begin with '{'");
            }
            block11: while (true) {
                char c = this.tokener.nextClean();
                switch (c) {
                    case '\u0000': {
                        throw this.tokener.syntaxError("A JSONObject text must end with '}'");
                    }
                    case '}': {
                        return;
                    }
                }
                this.tokener.back();
                String key = this.tokener.nextValue().toString();
                c = this.tokener.nextClean();
                if (c == '=') {
                    if (this.tokener.next() != '>') {
                        this.tokener.back();
                    }
                } else if (c != ':') {
                    throw this.tokener.syntaxError("Expected a ':' after a key");
                }
                if (key.equals("failOnErrors")) {
                    this.handler.handleFailOnErrors((Integer)this.tokener.nextValue());
                } else if (key.equals("Operations")) {
                    this.parseOperations();
                } else {
                    this.tokener.nextValue();
                }
                switch (this.tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (this.tokener.nextClean() == '}') {
                            return;
                        }
                        this.tokener.back();
                        continue block11;
                    }
                    case '}': {
                        return;
                    }
                }
                break;
            }
            throw this.tokener.syntaxError("Expected a ',' or '}'");
        }
        catch (SCIMException e) {
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new InvalidResourceException("Error while reading JSON Bulk content: " + e.getMessage(), e);
        }
    }

    private void parseOperations() throws JSONException, SCIMException {
        if (this.tokener.nextClean() != '[') {
            throw this.tokener.syntaxError("A JSONArray text must start with '['");
        }
        if (this.tokener.nextClean() != ']') {
            this.tokener.back();
            block6: while (true) {
                if (this.tokener.nextClean() != ',') {
                    this.tokener.back();
                    if ((long)this.operationIndex >= this.bulkConfig.getMaxOperations()) {
                        throw SCIMException.createException(413, "The number of operations in the bulk operation exceeds maxOperations (" + this.bulkConfig.getMaxOperations() + ")");
                    }
                    if (this.bulkInputStream.getBytesRead() > this.bulkConfig.getMaxPayloadSize()) {
                        throw SCIMException.createException(413, "The size of the bulk operation exceeds the maxPayloadSize (" + this.bulkConfig.getMaxPayloadSize() + ")");
                    }
                    if (this.skipOperations) {
                        this.tokener.nextValue();
                    } else {
                        JSONObject o = JsonBulkParser.makeCaseInsensitive((JSONObject)this.tokener.nextValue());
                        try {
                            this.handler.handleOperation(this.operationIndex, this.parseBulkOperation(o));
                        }
                        catch (BulkException e) {
                            this.handler.handleException(this.operationIndex, e);
                        }
                    }
                    ++this.operationIndex;
                }
                switch (this.tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (this.tokener.nextClean() == ']') {
                            return;
                        }
                        this.tokener.back();
                        continue block6;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw this.tokener.syntaxError("Expected a ',' or ']'");
        }
    }

    private BulkOperation parseBulkOperation(JSONObject o) throws BulkException {
        String method = o.optString("method");
        String bulkId = o.optString("bulkid", null);
        String version = o.optString("version", null);
        String path = o.optString("path", null);
        String location = o.optString("location", null);
        BulkOperation.Method httpMethod = null;
        try {
            Status status;
            try {
                httpMethod = BulkOperation.Method.valueOf(method.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            JSONObject data = JsonBulkParser.makeCaseInsensitive(o.optJSONObject("data"));
            JSONObject statusObj = JsonBulkParser.makeCaseInsensitive(o.optJSONObject("status"));
            if (statusObj != null) {
                String code = statusObj.getString("code");
                String description = statusObj.optString("description", null);
                status = new Status(code, description);
            } else {
                status = null;
            }
            BaseResource resource = null;
            if (data != null) {
                String endpoint;
                ResourceDescriptor descriptor;
                int endPos;
                if (path == null) {
                    throw new BulkException(new InvalidResourceException("Bulk operation " + this.operationIndex + " has data but no path"), httpMethod, bulkId, path);
                }
                int startPos = 0;
                if (path.charAt(startPos) == '/') {
                    ++startPos;
                }
                if ((endPos = path.indexOf(47, startPos)) == -1) {
                    endPos = path.length();
                }
                if ((descriptor = this.handler.getResourceDescriptor(endpoint = path.substring(startPos, endPos))) == null) {
                    throw new BulkException(new InvalidResourceException("Bulk operation " + this.operationIndex + " specifies an unknown " + "resource endpoint '" + endpoint + "'"), httpMethod, bulkId, path);
                }
                try {
                    resource = this.unmarshal(data, descriptor, BaseResource.BASE_RESOURCE_FACTORY, null);
                }
                catch (InvalidResourceException e) {
                    throw new BulkException(e, httpMethod, bulkId, path);
                }
            }
            return new BulkOperation(httpMethod, bulkId, version, path, location, resource, status);
        }
        catch (JSONException e) {
            throw new BulkException(new InvalidResourceException("Bulk operation " + this.operationIndex + " is malformed: " + e.getMessage()), httpMethod, bulkId, path);
        }
    }

    protected SCIMAttribute createSimpleAttribute(Object jsonAttribute, AttributeDescriptor attributeDescriptor) {
        String v = this.handler.transformValue(this.operationIndex, jsonAttribute.toString());
        return SCIMAttribute.create(attributeDescriptor, SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), v));
    }
}

