/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.json.JsonMarshaller;
import com.unboundid.scim.marshal.json.JsonUnmarshaller;
import com.unboundid.scim.marshal.xml.XmlMarshaller;
import com.unboundid.scim.marshal.xml.XmlUnmarshaller;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.BulkContentResponseHandler;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.BulkResponse;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMEndpoint;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkEndpoint {
    private final SCIMService service;
    private final RestClient client;
    private final MediaType contentType;
    private final MediaType acceptType;
    private final Unmarshaller unmarshaller;
    private final Marshaller marshaller;

    BulkEndpoint(SCIMService service, RestClient client) {
        this.service = service;
        this.client = client;
        this.contentType = service.getContentType();
        this.acceptType = service.getAcceptType();
        this.marshaller = this.contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonMarshaller() : new XmlMarshaller();
        this.unmarshaller = this.acceptType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonUnmarshaller() : new XmlUnmarshaller();
    }

    public BulkResponse processRequest(List<BulkOperation> operations, int failOnErrors) throws SCIMException {
        BulkContentResponseHandler handler = new BulkContentResponseHandler();
        this.processRequest(handler, operations, failOnErrors);
        return new BulkResponse(handler.getOperations());
    }

    private void processRequest(BulkContentHandler handler, final List<BulkOperation> operations, final int failOnErrors) throws SCIMException {
        block12: {
            URI uri = UriBuilder.fromUri((URI)this.service.getBaseURL()).path("Bulk").build(new Object[0]);
            Resource clientResource = this.client.resource(uri);
            clientResource.accept(new MediaType[]{this.acceptType});
            clientResource.contentType(this.contentType);
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                    try {
                        BulkEndpoint.this.marshaller.bulkMarshal(outputStream, failOnErrors, operations);
                    }
                    catch (Exception e) {
                        throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
                    }
                }
            };
            ClientResponse response = null;
            InputStream entity = null;
            try {
                response = clientResource.post((Object)output);
                entity = (InputStream)response.getEntity(InputStream.class);
                if (response.getStatusType() == Response.Status.OK) {
                    BulkConfig bulkConfig = new BulkConfig(true, operations.size(), Long.MAX_VALUE);
                    this.unmarshaller.bulkUnmarshal(entity, bulkConfig, handler);
                    break block12;
                }
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), SCIMEndpoint.getExceptionMessage(e), e);
            }
            finally {
                try {
                    if (entity != null) {
                        entity.close();
                    }
                }
                catch (IOException e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    private SCIMException createErrorResponseException(ClientResponse response, InputStream entity) {
        SCIMException scimException = null;
        if (entity != null) {
            try {
                scimException = this.unmarshaller.unmarshalError(entity);
            }
            catch (InvalidResourceException e) {
                Debug.debugException(e);
            }
        }
        if (scimException == null) {
            scimException = SCIMException.createException(response.getStatusCode(), response.getMessage());
        }
        return scimException;
    }
}

