/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.sdk.ConnectException;
import com.unboundid.scim.sdk.ForbiddenException;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.RequestEntityTooLargeException;
import com.unboundid.scim.sdk.ResourceConflictException;
import com.unboundid.scim.sdk.ResourceNotFoundException;
import com.unboundid.scim.sdk.SCIMResponse;
import com.unboundid.scim.sdk.ServerErrorException;
import com.unboundid.scim.sdk.UnauthorizedException;
import com.unboundid.scim.sdk.UnsupportedOperationException;
import java.io.OutputStream;

public class SCIMException
extends Exception
implements SCIMResponse {
    private static final long serialVersionUID = -7530770599624725752L;
    private final int statusCode;

    protected SCIMException(int statusCode, String errorMessage) {
        super(errorMessage);
        this.statusCode = statusCode;
    }

    protected SCIMException(int statusCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public final void marshal(Marshaller marshaller, OutputStream outputStream) throws Exception {
        marshaller.marshal(this, outputStream);
    }

    public static SCIMException createException(int statusCode, String errorMessage) {
        return SCIMException.createException(statusCode, errorMessage, null);
    }

    public static SCIMException createException(int statusCode, String errorMessage, Exception cause) {
        switch (statusCode) {
            case -1: {
                return new ConnectException(errorMessage);
            }
            case 400: {
                return new InvalidResourceException(errorMessage);
            }
            case 401: {
                return new UnauthorizedException(errorMessage);
            }
            case 403: {
                return new ForbiddenException(errorMessage);
            }
            case 404: {
                return new ResourceNotFoundException(errorMessage);
            }
            case 409: {
                return new ResourceConflictException(errorMessage);
            }
            case 413: {
                return new RequestEntityTooLargeException(errorMessage);
            }
            case 500: {
                return new ServerErrorException(errorMessage);
            }
            case 501: {
                return new UnsupportedOperationException(errorMessage);
            }
        }
        return new SCIMException(statusCode, errorMessage, cause);
    }
}

