/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.logging;

import com.onlinepayments.logging.SensitiveValueObfuscator;
import com.onlinepayments.logging.ValueObfuscator;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

abstract class Obfuscator {
    private final Map<String, ValueObfuscator> obfuscators;

    Obfuscator(Map<String, ValueObfuscator> obfuscators, boolean caseInsensitive) {
        this.obfuscators = this.copy(obfuscators, caseInsensitive);
    }

    private Map<String, ValueObfuscator> copy(Map<String, ValueObfuscator> obfuscators, boolean caseInsensitive) {
        AbstractMap copy;
        if (caseInsensitive) {
            copy = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            copy.putAll(obfuscators);
        } else {
            copy = new LinkedHashMap<String, ValueObfuscator>(obfuscators);
        }
        return Collections.unmodifiableMap(copy);
    }

    String obfuscateValue(String key, String value) {
        ValueObfuscator obfuscator = this.obfuscators.get(key);
        return obfuscator != null ? obfuscator.obfuscateValue(value) : value;
    }

    static abstract class Builder {
        private final Map<String, ValueObfuscator> obfuscators = new LinkedHashMap<String, ValueObfuscator>();

        Builder() {
        }

        Builder withField(String key) {
            this.obfuscators.put(key, ValueObfuscator.INSTANCE);
            return this;
        }

        Builder withSensitiveField(String key) {
            this.obfuscators.put(key, SensitiveValueObfuscator.INSTANCE);
            return this;
        }

        Map<String, ValueObfuscator> getObfuscators() {
            return this.obfuscators;
        }

        abstract Obfuscator build();
    }
}

