/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.Feature;
import de.flapdoodle.embed.mongo.packageresolver.FeatureSet;
import de.flapdoodle.embed.mongo.packageresolver.FeatureSetResolver;
import de.flapdoodle.embed.mongo.packageresolver.FeatureSetRule;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.distribution.Version;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultFeatureSetResolver
implements FeatureSetResolver {
    private final List<FeatureSetRule> rules = DefaultFeatureSetResolver.featureSetRules();
    private static final String MAX_VERSION = "100.0.0";
    public static DefaultFeatureSetResolver INSTANCE = new DefaultFeatureSetResolver();

    @Override
    public FeatureSet featuresOf(Version distribution) {
        Set<Feature> features = this.rules.stream().filter(rule -> rule.versionRange().match(distribution)).flatMap(rule -> rule.features().stream()).collect(Collectors.toSet());
        return FeatureSet.of(features);
    }

    private static List<FeatureSetRule> featureSetRules() {
        return Collections.unmodifiableList(Arrays.asList(DefaultFeatureSetResolver.enable(Feature.SYNC_DELAY, VersionRange.of("2.4.0", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.TEXT_SEARCH, VersionRange.of("2.4.0", "2.5.4")), DefaultFeatureSetResolver.enable(Feature.STORAGE_ENGINE, VersionRange.of("3.0.0", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.ONLY_64BIT, VersionRange.of("3.4.3", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.NO_CHUNKSIZE_ARG, VersionRange.of("3.4.3", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.MONGOS_CONFIGDB_SET_STYLE, VersionRange.of("3.4.3", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.NO_SOLARIS_SUPPORT, VersionRange.of("3.4.15", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.NO_HTTP_INTERFACE_ARG, VersionRange.of("3.6.0", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.NO_BIND_IP_TO_LOCALHOST, VersionRange.of("3.6.0", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.DISABLE_USE_PREALLOC, VersionRange.of("4.2.13", MAX_VERSION)), DefaultFeatureSetResolver.enable(Feature.DISABLE_USE_SMALL_FILES, VersionRange.of("4.2.13", MAX_VERSION))));
    }

    private static FeatureSetRule enable(Feature feature, VersionRange range) {
        return FeatureSetRule.builder().versionRange(range).addFeatures(feature).build();
    }
}

