/*
 * Decompiled with CFR 0.152.
 */
package de.fumix.holidays.config.properties;

import de.fumix.holidays.config.Holiday;
import de.fumix.holidays.config.Region;
import de.fumix.holidays.config.properties.PropNode;
import de.fumix.holidays.config.properties.TreeProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionProperties {
    private static final Logger LOG = LoggerFactory.getLogger(RegionProperties.class);
    static final Pattern fullPattern = Pattern.compile("(\\d*)-(\\d*)");
    static final Pattern yearPattern = Pattern.compile("(\\d+)");

    public static void from(LinkedHashMap<String, String> regionProperties, Map<String, Holiday> holidays, Consumer<Region> regionConsumer) {
        String logPrefix = "[from()]";
        LOG.debug("{} Adding regions from properties map {}", (Object)"[from()]");
        HashMap<String, Region> cachedRegions = new HashMap<String, Region>();
        TreeProperties regionProps = TreeProperties.from(regionProperties);
        Collection regionNodes = regionProps.root.get("region").map(PropNode::getChildren).orElse(Collections.emptyList());
        for (PropNode regionNode : regionNodes) {
            String regionKey = regionNode.getKey();
            Optional<Region> parent = regionNode.get("parent").flatMap(PropNode::getValue).map(parentKey -> {
                Region parentRegion = (Region)cachedRegions.get(parentKey);
                if (parentRegion == null) {
                    throw new IllegalArgumentException("region-properties: Region " + regionKey + " refers to parent region '" + parentKey + "', which is not defined yet (parent regions have to be defined before).");
                }
                return parentRegion;
            });
            Region region = new Region(parent, regionKey);
            LOG.debug("{} Setting up region {}", (Object)"[from()]", (Object)region);
            Collection regionHolidayNodes = regionNode.get("holiday").map(PropNode::getChildren).orElse(Collections.emptyList());
            for (PropNode rhn : regionHolidayNodes) {
                Holiday holiday = holidays.get(rhn.getKey());
                if (holiday == null) {
                    throw new IllegalArgumentException("Holiday '" + rhn.getKey() + "' referred to for region '" + regionKey + "' is not defined.");
                }
                Optional<String> value = rhn.getValue();
                if (value.isPresent() && !value.get().trim().isEmpty()) {
                    String[] rangeExpressions;
                    for (String rangeExpr : rangeExpressions = value.get().split(",")) {
                        Matcher fullMatcher = fullPattern.matcher(rangeExpr);
                        if (fullMatcher.matches()) {
                            Optional<Integer> yearStart = fullMatcher.group(1).trim().isEmpty() ? Optional.empty() : Optional.of(Integer.parseInt(fullMatcher.group(1)));
                            Optional<Integer> yearEnd = fullMatcher.group(2).trim().isEmpty() ? Optional.empty() : Optional.of(Integer.parseInt(fullMatcher.group(2)));
                            region.withHoliday(holiday, yearStart, yearEnd);
                            continue;
                        }
                        Matcher yearMatcher = yearPattern.matcher(rangeExpr);
                        if (yearMatcher.matches()) {
                            Optional<Integer> yearStart;
                            Optional<Integer> yearEnd = yearStart = Optional.of(Integer.parseInt(yearMatcher.group(1)));
                            region.withHoliday(holiday, yearStart, yearEnd);
                            continue;
                        }
                        throw new IllegalArgumentException("Validity expression '" + rangeExpr + "' for holiday assignment for region '" + region.getRegionId() + "' and holiday '" + holiday.getHolidayId() + "' is invalid.");
                    }
                    continue;
                }
                region.withHoliday(holiday);
            }
            cachedRegions.put(region.regionId, region);
            regionConsumer.accept(region);
        }
    }
}

