/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp;

import com.nimbusds.jose.JWSAlgorithm;
import eu.europa.ec.eudi.openid4vp.SupportedRequestUriMethods;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Leu/europa/ec/eudi/openid4vp/JarConfiguration;", "", "supportedAlgorithms", "", "Lcom/nimbusds/jose/JWSAlgorithm;", "supportedRequestUriMethods", "Leu/europa/ec/eudi/openid4vp/SupportedRequestUriMethods;", "<init>", "(Ljava/util/List;Leu/europa/ec/eudi/openid4vp/SupportedRequestUriMethods;)V", "getSupportedAlgorithms", "()Ljava/util/List;", "getSupportedRequestUriMethods", "()Leu/europa/ec/eudi/openid4vp/SupportedRequestUriMethods;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vp/JarConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,431:1\n1#2:432\n*E\n"})
public final class JarConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<JWSAlgorithm> supportedAlgorithms;
    @NotNull
    private final SupportedRequestUriMethods supportedRequestUriMethods;
    @NotNull
    private static final JarConfiguration Default;

    public JarConfiguration(@NotNull List<JWSAlgorithm> supportedAlgorithms, @NotNull SupportedRequestUriMethods supportedRequestUriMethods) {
        Intrinsics.checkNotNullParameter(supportedAlgorithms, (String)"supportedAlgorithms");
        Intrinsics.checkNotNullParameter((Object)supportedRequestUriMethods, (String)"supportedRequestUriMethods");
        this.supportedAlgorithms = supportedAlgorithms;
        this.supportedRequestUriMethods = supportedRequestUriMethods;
        if (!(!((Collection)this.supportedAlgorithms).isEmpty())) {
            boolean bl = false;
            String string = "JAR signing algorithms cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ JarConfiguration(List list, SupportedRequestUriMethods supportedRequestUriMethods, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            supportedRequestUriMethods = SupportedRequestUriMethods.Companion.getDefault();
        }
        this(list, supportedRequestUriMethods);
    }

    @NotNull
    public final List<JWSAlgorithm> getSupportedAlgorithms() {
        return this.supportedAlgorithms;
    }

    @NotNull
    public final SupportedRequestUriMethods getSupportedRequestUriMethods() {
        return this.supportedRequestUriMethods;
    }

    @NotNull
    public final List<JWSAlgorithm> component1() {
        return this.supportedAlgorithms;
    }

    @NotNull
    public final SupportedRequestUriMethods component2() {
        return this.supportedRequestUriMethods;
    }

    @NotNull
    public final JarConfiguration copy(@NotNull List<JWSAlgorithm> supportedAlgorithms, @NotNull SupportedRequestUriMethods supportedRequestUriMethods) {
        Intrinsics.checkNotNullParameter(supportedAlgorithms, (String)"supportedAlgorithms");
        Intrinsics.checkNotNullParameter((Object)supportedRequestUriMethods, (String)"supportedRequestUriMethods");
        return new JarConfiguration(supportedAlgorithms, supportedRequestUriMethods);
    }

    public static /* synthetic */ JarConfiguration copy$default(JarConfiguration jarConfiguration, List list, SupportedRequestUriMethods supportedRequestUriMethods, int n, Object object) {
        if ((n & 1) != 0) {
            list = jarConfiguration.supportedAlgorithms;
        }
        if ((n & 2) != 0) {
            supportedRequestUriMethods = jarConfiguration.supportedRequestUriMethods;
        }
        return jarConfiguration.copy(list, supportedRequestUriMethods);
    }

    @NotNull
    public String toString() {
        return "JarConfiguration(supportedAlgorithms=" + this.supportedAlgorithms + ", supportedRequestUriMethods=" + this.supportedRequestUriMethods + ")";
    }

    public int hashCode() {
        int result = ((Object)this.supportedAlgorithms).hashCode();
        result = result * 31 + this.supportedRequestUriMethods.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JarConfiguration)) {
            return false;
        }
        JarConfiguration jarConfiguration = (JarConfiguration)other;
        if (!Intrinsics.areEqual(this.supportedAlgorithms, jarConfiguration.supportedAlgorithms)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.supportedRequestUriMethods, (Object)jarConfiguration.supportedRequestUriMethods);
    }

    static {
        Object[] objectArray = new JWSAlgorithm[]{JWSAlgorithm.ES256, JWSAlgorithm.ES384, JWSAlgorithm.ES512};
        Default = new JarConfiguration(CollectionsKt.listOf((Object[])objectArray), SupportedRequestUriMethods.Companion.getDefault());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Leu/europa/ec/eudi/openid4vp/JarConfiguration$Companion;", "", "<init>", "()V", "Default", "Leu/europa/ec/eudi/openid4vp/JarConfiguration;", "getDefault", "()Leu/europa/ec/eudi/openid4vp/JarConfiguration;", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JarConfiguration getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

