/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import eu.europa.ec.eudi.openid4vp.AuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.RequestValidationError;
import eu.europa.ec.eudi.openid4vp.internal.request.DefaultAuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.internal.request.RequestUriMethod;
import eu.europa.ec.eudi.openid4vp.internal.request.TransactionDataTO;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequestObject;
import eu.europa.ec.eudi.openid4vp.internal.request.UriSupportKt;
import eu.europa.ec.eudi.openid4vp.internal.request.VerifierInfoTO;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u0000 \u00042\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest;", "", "Plain", "JwtSecured", "Companion", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$JwtSecured;", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$Plain;", "eudi-lib-jvm-siop-openid4vp-kt"})
public interface UnvalidatedRequest {
    @NotNull
    public static final Companion Companion = eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequest$Companion.$$INSTANCE;

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$Companion;", "", "<init>", "()V", "make", "Lkotlin/Result;", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest;", "uriStr", "", "make-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "notSecured", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$Plain;", "requestParams", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    @SourceDebugExtension(value={"SMAP\nDefaultAuthorizationRequestResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAuthorizationRequestResolver.kt\neu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$Companion\n+ 2 Util.kt\neu/europa/ec/eudi/openid4vp/UtilKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ResultOps.kt\neu/europa/ec/eudi/openid4vp/internal/ResultOpsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,371:1\n21#2,2:372\n23#2,4:384\n465#3:374\n415#3:375\n1252#4,4:376\n32#5,2:380\n32#5,2:382\n1#6:388\n*S KotlinDebug\n*F\n+ 1 DefaultAuthorizationRequestResolver.kt\neu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$Companion\n*L\n129#1:372,2\n129#1:384,4\n131#1:374\n131#1:375\n131#1:376,4\n150#1:380,2\n153#1:382,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final Object make-IoAF18A(@NotNull String uriStr) {
            Intrinsics.checkNotNullParameter((Object)uriStr, (String)"uriStr");
            boolean $i$f$runCatchingCancellable = false;
            try {
                UnvalidatedRequest unvalidatedRequest;
                RequestUriMethod requestUriMethod;
                void $this$mapValuesTo$iv$iv;
                boolean bl = false;
                URI $this$make_IoAF18A_u24lambda_u245_u24lambda_u241 = URI.create(uriStr);
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)$this$make_IoAF18A_u24lambda_u245_u24lambda_u241);
                Object $this$mapValues$iv = StringValuesKt.toMap((StringValues)((StringValues)DefaultAuthorizationRequestResolverKt.access$toKtorUrl($this$make_IoAF18A_u24lambda_u245_u24lambda_u241).getParameters()));
                boolean $i$f$mapValues = false;
                Map map = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl3 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map3 = map2;
                    boolean bl4 = false;
                    String string = (String)CollectionsKt.first((List)((List)it.getValue()));
                    map3.put(k, string);
                }
                Map requestParams = destination$iv$iv;
                String requestValue = (String)requestParams.get("request");
                String requestUriValue = (String)requestParams.get("request_uri");
                String string = (String)requestParams.get("request_uri_method");
                if (string != null) {
                    String value = string;
                    boolean bl5 = false;
                    String string2 = value;
                    if (Intrinsics.areEqual((Object)string2, (Object)"get")) {
                        requestUriMethod = RequestUriMethod.GET;
                    } else {
                        if (!Intrinsics.areEqual((Object)string2, (Object)"post")) throw AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidRequestUriMethod.INSTANCE);
                        requestUriMethod = RequestUriMethod.POST;
                    }
                } else {
                    requestUriMethod = null;
                }
                RequestUriMethod requestUriMethod2 = requestUriMethod;
                $this$mapValues$iv = requestValue;
                if (!($this$mapValues$iv == null || $this$mapValues$iv.length() == 0)) {
                    boolean value$iv = requestUriValue == null;
                    boolean $i$f$ensure = false;
                    if (!value$iv) {
                        boolean bl6 = false;
                        throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidUseOfBothRequestAndRequestUri.INSTANCE);
                    }
                    value$iv = requestUriMethod2 == null;
                    $i$f$ensure = false;
                    if (!value$iv) {
                        boolean bl7 = false;
                        throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidRequestUriMethod.INSTANCE);
                    }
                    unvalidatedRequest = new JwtSecured.PassByValue(eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequest$Companion.make_IoAF18A$lambda$5$clientId(requestParams), requestValue);
                    return Result.constructor-impl((Object)unvalidatedRequest);
                } else {
                    CharSequence value$iv = requestUriValue;
                    if (!(value$iv == null || value$iv.length() == 0)) {
                        Object object = UriSupportKt.asURL$default(requestUriValue, null, 1, null);
                        ResultKt.throwOnFailure((Object)object);
                        URL requestUri = (URL)object;
                        unvalidatedRequest = new JwtSecured.PassByReference(eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequest$Companion.make_IoAF18A$lambda$5$clientId(requestParams), requestUri, requestUriMethod2);
                        return Result.constructor-impl((Object)unvalidatedRequest);
                    } else {
                        unvalidatedRequest = $$INSTANCE.notSecured(requestParams);
                    }
                }
                return Result.constructor-impl((Object)unvalidatedRequest);
            }
            catch (CancellationException ce$iv) {
                throw ce$iv;
            }
            catch (Exception e$iv) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
            }
        }

        private final Plain notSecured(Map<String, String> requestParams) {
            JsonArray jsonArray;
            JsonArray jsonArray2;
            String string = requestParams.get("response_type");
            JsonObject jsonObject = eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequest$Companion.notSecured$jsonObject(requestParams, "dcql_query");
            String string2 = requestParams.get("scope");
            String string3 = requestParams.get("nonce");
            String string4 = requestParams.get("response_mode");
            JsonObject jsonObject2 = eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequest$Companion.notSecured$jsonObject(requestParams, "client_metadata");
            String string5 = requestParams.get("client_id");
            String string6 = requestParams.get("response_uri");
            String string7 = requestParams.get("redirect_uri");
            String string8 = requestParams.get("state");
            JsonArray jsonArray3 = eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequest$Companion.notSecured$jsonArray(requestParams, "transaction_data");
            if (jsonArray3 != null) {
                JsonArray it = jsonArray3;
                boolean bl = false;
                jsonArray2 = TransactionDataTO.constructor-impl(it);
            } else {
                jsonArray2 = null;
            }
            JsonArray jsonArray4 = jsonArray2;
            JsonArray jsonArray5 = eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequest$Companion.notSecured$jsonArray(requestParams, "verifier_info");
            if (jsonArray5 != null) {
                JsonArray it = jsonArray5;
                boolean bl = false;
                jsonArray = VerifierInfoTO.constructor-impl(it);
            } else {
                jsonArray = null;
            }
            JsonArray jsonArray6 = jsonArray;
            UnvalidatedRequestObject unvalidatedRequestObject = new UnvalidatedRequestObject(jsonObject2, string3, string5, string, string4, string6, jsonObject, string7, string2, string8, null, jsonArray4, jsonArray6, 1024, null);
            return new Plain(unvalidatedRequestObject);
        }

        private static final String make_IoAF18A$lambda$5$clientId(Map<String, String> requestParams) {
            String string = requestParams.get("client_id");
            if (string == null) {
                throw AuthorizationRequestResolverKt.asException(RequestValidationError.MissingClientId.INSTANCE);
            }
            return string;
        }

        private static final JsonObject notSecured$jsonObject(Map<String, String> $requestParams, String p) {
            JsonObject jsonObject;
            String string = $requestParams.get(p);
            if (string != null) {
                String it = string;
                boolean bl = false;
                jsonObject = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(it));
            } else {
                jsonObject = null;
            }
            return jsonObject;
        }

        private static final JsonArray notSecured$jsonArray(Map<String, String> $requestParams, String p) {
            JsonArray jsonArray;
            String string = $requestParams.get(p);
            if (string != null) {
                String it = string;
                boolean bl = false;
                jsonArray = JsonElementKt.getJsonArray((JsonElement)Json.Default.parseToJsonElement(it));
            } else {
                jsonArray = null;
            }
            return jsonArray;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$JwtSecured;", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest;", "clientId", "", "getClientId", "()Ljava/lang/String;", "PassByValue", "PassByReference", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$JwtSecured$PassByReference;", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$JwtSecured$PassByValue;", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static interface JwtSecured
    extends UnvalidatedRequest {
        @NotNull
        public String getClientId();

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$JwtSecured$PassByReference;", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$JwtSecured;", "clientId", "", "jwtURI", "Ljava/net/URL;", "requestURIMethod", "Leu/europa/ec/eudi/openid4vp/internal/request/RequestUriMethod;", "<init>", "(Ljava/lang/String;Ljava/net/URL;Leu/europa/ec/eudi/openid4vp/internal/request/RequestUriMethod;)V", "getClientId", "()Ljava/lang/String;", "getJwtURI", "()Ljava/net/URL;", "getRequestURIMethod", "()Leu/europa/ec/eudi/openid4vp/internal/request/RequestUriMethod;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
        public static final class PassByReference
        implements JwtSecured {
            @NotNull
            private final String clientId;
            @NotNull
            private final URL jwtURI;
            @Nullable
            private final RequestUriMethod requestURIMethod;

            public PassByReference(@NotNull String clientId, @NotNull URL jwtURI, @Nullable RequestUriMethod requestURIMethod) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)jwtURI, (String)"jwtURI");
                this.clientId = clientId;
                this.jwtURI = jwtURI;
                this.requestURIMethod = requestURIMethod;
            }

            @Override
            @NotNull
            public String getClientId() {
                return this.clientId;
            }

            @NotNull
            public final URL getJwtURI() {
                return this.jwtURI;
            }

            @Nullable
            public final RequestUriMethod getRequestURIMethod() {
                return this.requestURIMethod;
            }

            @NotNull
            public final String component1() {
                return this.clientId;
            }

            @NotNull
            public final URL component2() {
                return this.jwtURI;
            }

            @Nullable
            public final RequestUriMethod component3() {
                return this.requestURIMethod;
            }

            @NotNull
            public final PassByReference copy(@NotNull String clientId, @NotNull URL jwtURI, @Nullable RequestUriMethod requestURIMethod) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)jwtURI, (String)"jwtURI");
                return new PassByReference(clientId, jwtURI, requestURIMethod);
            }

            public static /* synthetic */ PassByReference copy$default(PassByReference passByReference, String string, URL uRL, RequestUriMethod requestUriMethod, int n, Object object) {
                if ((n & 1) != 0) {
                    string = passByReference.clientId;
                }
                if ((n & 2) != 0) {
                    uRL = passByReference.jwtURI;
                }
                if ((n & 4) != 0) {
                    requestUriMethod = passByReference.requestURIMethod;
                }
                return passByReference.copy(string, uRL, requestUriMethod);
            }

            @NotNull
            public String toString() {
                return "PassByReference(clientId=" + this.clientId + ", jwtURI=" + this.jwtURI + ", requestURIMethod=" + this.requestURIMethod + ")";
            }

            public int hashCode() {
                int result = this.clientId.hashCode();
                result = result * 31 + this.jwtURI.hashCode();
                result = result * 31 + (this.requestURIMethod == null ? 0 : this.requestURIMethod.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PassByReference)) {
                    return false;
                }
                PassByReference passByReference = (PassByReference)other;
                if (!Intrinsics.areEqual((Object)this.clientId, (Object)passByReference.clientId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.jwtURI, (Object)passByReference.jwtURI)) {
                    return false;
                }
                return this.requestURIMethod == passByReference.requestURIMethod;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0003j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\f\u001a\u00060\u0003j\u0002`\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0003j\u0002`\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u00060\u0003j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$JwtSecured$PassByValue;", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$JwtSecured;", "clientId", "", "jwt", "Leu/europa/ec/eudi/openid4vp/Jwt;", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "getJwt", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
        public static final class PassByValue
        implements JwtSecured {
            @NotNull
            private final String clientId;
            @NotNull
            private final String jwt;

            public PassByValue(@NotNull String clientId, @NotNull String jwt) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
                this.clientId = clientId;
                this.jwt = jwt;
            }

            @Override
            @NotNull
            public String getClientId() {
                return this.clientId;
            }

            @NotNull
            public final String getJwt() {
                return this.jwt;
            }

            @NotNull
            public final String component1() {
                return this.clientId;
            }

            @NotNull
            public final String component2() {
                return this.jwt;
            }

            @NotNull
            public final PassByValue copy(@NotNull String clientId, @NotNull String jwt) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
                return new PassByValue(clientId, jwt);
            }

            public static /* synthetic */ PassByValue copy$default(PassByValue passByValue, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = passByValue.clientId;
                }
                if ((n & 2) != 0) {
                    string2 = passByValue.jwt;
                }
                return passByValue.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "PassByValue(clientId=" + this.clientId + ", jwt=" + this.jwt + ")";
            }

            public int hashCode() {
                int result = this.clientId.hashCode();
                result = result * 31 + this.jwt.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PassByValue)) {
                    return false;
                }
                PassByValue passByValue = (PassByValue)other;
                if (!Intrinsics.areEqual((Object)this.clientId, (Object)passByValue.clientId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.jwt, (Object)passByValue.jwt);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest$Plain;", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequest;", "requestObject", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;", "<init>", "(Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;)V", "getRequestObject", "()Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class Plain
    implements UnvalidatedRequest {
        @NotNull
        private final UnvalidatedRequestObject requestObject;

        public Plain(@NotNull UnvalidatedRequestObject requestObject) {
            Intrinsics.checkNotNullParameter((Object)requestObject, (String)"requestObject");
            this.requestObject = requestObject;
        }

        @NotNull
        public final UnvalidatedRequestObject getRequestObject() {
            return this.requestObject;
        }

        @NotNull
        public final UnvalidatedRequestObject component1() {
            return this.requestObject;
        }

        @NotNull
        public final Plain copy(@NotNull UnvalidatedRequestObject requestObject) {
            Intrinsics.checkNotNullParameter((Object)requestObject, (String)"requestObject");
            return new Plain(requestObject);
        }

        public static /* synthetic */ Plain copy$default(Plain plain, UnvalidatedRequestObject unvalidatedRequestObject, int n, Object object) {
            if ((n & 1) != 0) {
                unvalidatedRequestObject = plain.requestObject;
            }
            return plain.copy(unvalidatedRequestObject);
        }

        @NotNull
        public String toString() {
            return "Plain(requestObject=" + this.requestObject + ")";
        }

        public int hashCode() {
            return this.requestObject.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Plain)) {
                return false;
            }
            Plain plain = (Plain)other;
            return Intrinsics.areEqual((Object)this.requestObject, (Object)plain.requestObject);
        }
    }
}

