/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import eu.europa.ec.eudi.openid4vp.EncryptionRequirement;
import eu.europa.ec.eudi.openid4vp.SiopOpenId4VPConfig;
import eu.europa.ec.eudi.openid4vp.SupportedClientIdPrefix;
import eu.europa.ec.eudi.openid4vp.SupportedRequestUriMethods;
import eu.europa.ec.eudi.openid4vp.VpFormatsSupported;
import eu.europa.ec.eudi.openid4vp.internal.JsonKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED", "", "JWKS", "AUTHORIZATION_ENCRYPTION_ALG_VALUES_SUPPORTED", "AUTHORIZATION_ENCRYPTION_ENC_VALUES_SUPPORTED", "RESPONSE_TYPES_SUPPOERTED", "RESPONSE_MODES_SUPPORTED", "walletMetaData", "Lkotlinx/serialization/json/JsonObject;", "cfg", "Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;", "keys", "", "Lcom/nimbusds/jose/jwk/JWK;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nWalletMetaData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WalletMetaData.kt\neu/europa/ec/eudi/openid4vp/internal/request/WalletMetaDataKt\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n29#2,2:85\n31#2:88\n324#3:87\n1869#4,2:89\n1869#4,2:91\n1869#4,2:93\n1869#4,2:95\n*S KotlinDebug\n*F\n+ 1 WalletMetaData.kt\neu/europa/ec/eudi/openid4vp/internal/request/WalletMetaDataKt\n*L\n36#1:85,2\n36#1:88\n65#1:87\n45#1:89,2\n54#1:91,2\n57#1:93,2\n67#1:95,2\n*E\n"})
public final class WalletMetaDataKt {
    @NotNull
    private static final String REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED = "request_object_signing_alg_values_supported";
    @NotNull
    private static final String JWKS = "jwks";
    @NotNull
    private static final String AUTHORIZATION_ENCRYPTION_ALG_VALUES_SUPPORTED = "authorization_encryption_alg_values_supported";
    @NotNull
    private static final String AUTHORIZATION_ENCRYPTION_ENC_VALUES_SUPPORTED = "authorization_encryption_enc_values_supported";
    @NotNull
    private static final String RESPONSE_TYPES_SUPPOERTED = "response_types_supported";
    @NotNull
    private static final String RESPONSE_MODES_SUPPORTED = "response_modes_supported";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonObject walletMetaData(@NotNull SiopOpenId4VPConfig cfg, @NotNull List<? extends JWK> keys) {
        void $this$encodeToJsonElement$iv;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$walletMetaData_u24lambda_u2411 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$walletMetaData_u24lambda_u2411, (String)REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED, arg_0 -> WalletMetaDataKt.walletMetaData$lambda$11$lambda$1(cfg, arg_0));
        SupportedRequestUriMethods.Post post = cfg.getJarConfiguration().getSupportedRequestUriMethods().isPostSupported();
        if (post != null) {
            SupportedRequestUriMethods.Post requestUriMethodPost = post;
            boolean bl2 = false;
            EncryptionRequirement jarEncryption = requestUriMethodPost.getJarEncryption();
            if (jarEncryption instanceof EncryptionRequirement.Required && !((Collection)keys).isEmpty()) {
                Map map = new JWKSet(keys).toJSONObject(true);
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"toJSONObject(...)");
                $this$walletMetaData_u24lambda_u2411.put(JWKS, (JsonElement)JsonKt.toJsonObject(map));
                JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$walletMetaData_u24lambda_u2411, (String)AUTHORIZATION_ENCRYPTION_ALG_VALUES_SUPPORTED, arg_0 -> WalletMetaDataKt.walletMetaData$lambda$11$lambda$6$lambda$3(jarEncryption, arg_0));
                JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$walletMetaData_u24lambda_u2411, (String)AUTHORIZATION_ENCRYPTION_ENC_VALUES_SUPPORTED, arg_0 -> WalletMetaDataKt.walletMetaData$lambda$11$lambda$6$lambda$5(jarEncryption, arg_0));
            }
        }
        Json json = JsonKt.getJsonSupport();
        VpFormatsSupported value$iv = cfg.getVpConfiguration().getVpFormatsSupported();
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        $this$walletMetaData_u24lambda_u2411.put("vp_formats_supported", $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)VpFormatsSupported.Companion.serializer(), (Object)value$iv));
        JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$walletMetaData_u24lambda_u2411, (String)"client_id_prefixes_supported", arg_0 -> WalletMetaDataKt.walletMetaData$lambda$11$lambda$8(cfg, arg_0));
        JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$walletMetaData_u24lambda_u2411, (String)RESPONSE_TYPES_SUPPOERTED, WalletMetaDataKt::walletMetaData$lambda$11$lambda$9);
        JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$walletMetaData_u24lambda_u2411, (String)RESPONSE_MODES_SUPPORTED, WalletMetaDataKt::walletMetaData$lambda$11$lambda$10);
        return builder$iv.build();
    }

    private static final Unit walletMetaData$lambda$11$lambda$1(SiopOpenId4VPConfig $cfg, JsonArrayBuilder $this$putJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
        Iterable $this$forEach$iv = $cfg.getJarConfiguration().getSupportedAlgorithms();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JWSAlgorithm alg = (JWSAlgorithm)element$iv;
            boolean bl = false;
            JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)alg.getName());
        }
        return Unit.INSTANCE;
    }

    private static final Unit walletMetaData$lambda$11$lambda$6$lambda$3(EncryptionRequirement $jarEncryption, JsonArrayBuilder $this$putJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
        Iterable $this$forEach$iv = ((EncryptionRequirement.Required)$jarEncryption).getSupportedEncryptionAlgorithms();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JWEAlgorithm alg = (JWEAlgorithm)element$iv;
            boolean bl = false;
            JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)alg.getName());
        }
        return Unit.INSTANCE;
    }

    private static final Unit walletMetaData$lambda$11$lambda$6$lambda$5(EncryptionRequirement $jarEncryption, JsonArrayBuilder $this$putJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
        Iterable $this$forEach$iv = ((EncryptionRequirement.Required)$jarEncryption).getSupportedEncryptionMethods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EncryptionMethod method = (EncryptionMethod)element$iv;
            boolean bl = false;
            JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)method.getName());
        }
        return Unit.INSTANCE;
    }

    private static final Unit walletMetaData$lambda$11$lambda$8(SiopOpenId4VPConfig $cfg, JsonArrayBuilder $this$putJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
        Iterable $this$forEach$iv = $cfg.getSupportedClientIdPrefixes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SupportedClientIdPrefix supportedClientIdPrefix = (SupportedClientIdPrefix)element$iv;
            boolean bl = false;
            JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)supportedClientIdPrefix.prefix().value());
        }
        return Unit.INSTANCE;
    }

    private static final Unit walletMetaData$lambda$11$lambda$9(JsonArrayBuilder $this$putJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
        JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)"vp_token");
        JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)"id_token");
        JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)"vp_token id_token");
        return Unit.INSTANCE;
    }

    private static final Unit walletMetaData$lambda$11$lambda$10(JsonArrayBuilder $this$putJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
        JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)"direct_post");
        JsonElementBuildersKt.add((JsonArrayBuilder)$this$putJsonArray, (String)"direct_post.jwt");
        return Unit.INSTANCE;
    }
}

