/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.response;

import eu.europa.ec.eudi.openid4vp.AuthorizationRequestError;
import eu.europa.ec.eudi.openid4vp.HttpError;
import eu.europa.ec.eudi.openid4vp.RequestValidationError;
import eu.europa.ec.eudi.openid4vp.ResolutionError;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0080\u0081\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0019"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationRequestErrorCode;", "", "code", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "INVALID_SCOPE", "INVALID_REQUEST", "ACCESS_DENIED", "INVALID_CLIENT", "VP_FORMATS_NOT_SUPPORTED", "INVALID_REQUEST_URI_METHOD", "INVALID_TRANSACTION_DATA", "USER_CANCELLED", "REGISTRATION_VALUE_NOT_SUPPORTED", "SUBJECT_SYNTAX_TYPES_NOT_SUPPORTED", "INVALID_REGISTRATION_URI", "INVALID_REGISTRATION_OBJECT", "INVALID_REQUEST_URI", "INVALID_REQUEST_OBJECT", "REQUEST_URI_NOT_SUPPORTED", "PROCESSING_FAILURE", "Companion", "eudi-lib-jvm-siop-openid4vp-kt"})
public final class AuthorizationRequestErrorCode
extends Enum<AuthorizationRequestErrorCode> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String code;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_SCOPE;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_REQUEST;
    public static final /* enum */ AuthorizationRequestErrorCode ACCESS_DENIED;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_CLIENT;
    public static final /* enum */ AuthorizationRequestErrorCode VP_FORMATS_NOT_SUPPORTED;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_REQUEST_URI_METHOD;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_TRANSACTION_DATA;
    public static final /* enum */ AuthorizationRequestErrorCode USER_CANCELLED;
    public static final /* enum */ AuthorizationRequestErrorCode REGISTRATION_VALUE_NOT_SUPPORTED;
    public static final /* enum */ AuthorizationRequestErrorCode SUBJECT_SYNTAX_TYPES_NOT_SUPPORTED;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_REGISTRATION_URI;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_REGISTRATION_OBJECT;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_REQUEST_URI;
    public static final /* enum */ AuthorizationRequestErrorCode INVALID_REQUEST_OBJECT;
    public static final /* enum */ AuthorizationRequestErrorCode REQUEST_URI_NOT_SUPPORTED;
    public static final /* enum */ AuthorizationRequestErrorCode PROCESSING_FAILURE;
    private static final /* synthetic */ AuthorizationRequestErrorCode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private AuthorizationRequestErrorCode(String code) {
        this.code = code;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    public static AuthorizationRequestErrorCode[] values() {
        return (AuthorizationRequestErrorCode[])$VALUES.clone();
    }

    public static AuthorizationRequestErrorCode valueOf(String value) {
        return Enum.valueOf(AuthorizationRequestErrorCode.class, value);
    }

    @NotNull
    public static EnumEntries<AuthorizationRequestErrorCode> getEntries() {
        return $ENTRIES;
    }

    static {
        INVALID_SCOPE = new AuthorizationRequestErrorCode("invalid_scope");
        INVALID_REQUEST = new AuthorizationRequestErrorCode("invalid_request");
        ACCESS_DENIED = new AuthorizationRequestErrorCode("access_denied");
        INVALID_CLIENT = new AuthorizationRequestErrorCode("invalid_client");
        VP_FORMATS_NOT_SUPPORTED = new AuthorizationRequestErrorCode("vp_formats_not_supported");
        INVALID_REQUEST_URI_METHOD = new AuthorizationRequestErrorCode("invalid_request_uri_method");
        INVALID_TRANSACTION_DATA = new AuthorizationRequestErrorCode("invalid_transaction_data");
        USER_CANCELLED = new AuthorizationRequestErrorCode("user_cancelled");
        REGISTRATION_VALUE_NOT_SUPPORTED = new AuthorizationRequestErrorCode("registration_value_not_supported");
        SUBJECT_SYNTAX_TYPES_NOT_SUPPORTED = new AuthorizationRequestErrorCode("subject_syntax_types_not_supported");
        INVALID_REGISTRATION_URI = new AuthorizationRequestErrorCode("invalid_registration_uri");
        INVALID_REGISTRATION_OBJECT = new AuthorizationRequestErrorCode("invalid_registration_object");
        INVALID_REQUEST_URI = new AuthorizationRequestErrorCode("invalid_request_uri");
        INVALID_REQUEST_OBJECT = new AuthorizationRequestErrorCode("invalid_request_object");
        REQUEST_URI_NOT_SUPPORTED = new AuthorizationRequestErrorCode("request_uri_not_supported");
        PROCESSING_FAILURE = new AuthorizationRequestErrorCode("processing_error");
        $VALUES = authorizationRequestErrorCodeArray = new AuthorizationRequestErrorCode[]{AuthorizationRequestErrorCode.INVALID_SCOPE, AuthorizationRequestErrorCode.INVALID_REQUEST, AuthorizationRequestErrorCode.ACCESS_DENIED, AuthorizationRequestErrorCode.INVALID_CLIENT, AuthorizationRequestErrorCode.VP_FORMATS_NOT_SUPPORTED, AuthorizationRequestErrorCode.INVALID_REQUEST_URI_METHOD, AuthorizationRequestErrorCode.INVALID_TRANSACTION_DATA, AuthorizationRequestErrorCode.USER_CANCELLED, AuthorizationRequestErrorCode.REGISTRATION_VALUE_NOT_SUPPORTED, AuthorizationRequestErrorCode.SUBJECT_SYNTAX_TYPES_NOT_SUPPORTED, AuthorizationRequestErrorCode.INVALID_REGISTRATION_URI, AuthorizationRequestErrorCode.INVALID_REGISTRATION_OBJECT, AuthorizationRequestErrorCode.INVALID_REQUEST_URI, AuthorizationRequestErrorCode.INVALID_REQUEST_OBJECT, AuthorizationRequestErrorCode.REQUEST_URI_NOT_SUPPORTED, AuthorizationRequestErrorCode.PROCESSING_FAILURE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationRequestErrorCode$Companion;", "", "<init>", "()V", "fromError", "Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationRequestErrorCode;", "error", "Leu/europa/ec/eudi/openid4vp/AuthorizationRequestError;", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AuthorizationRequestErrorCode fromError(@NotNull AuthorizationRequestError error) {
            AuthorizationRequestErrorCode authorizationRequestErrorCode;
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            AuthorizationRequestError authorizationRequestError = error;
            if (authorizationRequestError instanceof ResolutionError.UnknownScope) {
                authorizationRequestErrorCode = INVALID_SCOPE;
            } else if (authorizationRequestError instanceof RequestValidationError.InvalidClientIdPrefix || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.InvalidRedirectUri.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.InvalidResponseUri.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MissingClientId.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MissingNonce.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MissingQuerySource.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MultipleQuerySources.INSTANCE) || authorizationRequestError instanceof RequestValidationError.InvalidDigitalCredentialsQuery || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.UnsupportedQueryFormats.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MissingRedirectUri.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MissingResponseType.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MissingResponseUri.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MissingScope.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.RedirectUriMustNotBeProvided.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.ResponseUriMustNotBeProvided.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.IdTokenSigningAlgMissing.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.IdTokenEncryptionAlgMissing.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.IdTokenEncryptionMethodMissing.INSTANCE) || authorizationRequestError instanceof RequestValidationError.InvalidClientMetaData || authorizationRequestError instanceof RequestValidationError.UnsupportedResponseMode || authorizationRequestError instanceof RequestValidationError.UnsupportedResponseType || authorizationRequestError instanceof RequestValidationError.UnsupportedClientMetaData || authorizationRequestError instanceof RequestValidationError.InvalidIdTokenType || authorizationRequestError instanceof HttpError || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.InvalidUseOfBothRequestAndRequestUri.INSTANCE) || authorizationRequestError instanceof RequestValidationError.UnsupportedRequestUriMethod || authorizationRequestError instanceof RequestValidationError.InvalidVerifierInfo) {
                authorizationRequestErrorCode = INVALID_REQUEST;
            } else if (Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.InvalidClientId.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.UnsupportedClientIdPrefix.INSTANCE)) {
                authorizationRequestErrorCode = INVALID_CLIENT;
            } else if (authorizationRequestError instanceof RequestValidationError.InvalidRequestUriMethod) {
                authorizationRequestErrorCode = INVALID_REQUEST_URI_METHOD;
            } else if (Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.MissingClientMetadataJwks.INSTANCE) || authorizationRequestError instanceof ResolutionError.ClientMetadataJwksUnparsable) {
                authorizationRequestErrorCode = INVALID_REGISTRATION_OBJECT;
            } else if (Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.SubjectSyntaxTypesNoMatch.INSTANCE) || Intrinsics.areEqual((Object)authorizationRequestError, (Object)RequestValidationError.SubjectSyntaxTypesWrongSyntax.INSTANCE)) {
                authorizationRequestErrorCode = SUBJECT_SYNTAX_TYPES_NOT_SUPPORTED;
            } else if (authorizationRequestError instanceof ResolutionError.UnableToFetchRequestObject) {
                authorizationRequestErrorCode = INVALID_REQUEST_URI;
            } else if (authorizationRequestError instanceof RequestValidationError.InvalidJarJwt) {
                authorizationRequestErrorCode = INVALID_REQUEST_OBJECT;
            } else if (authorizationRequestError instanceof RequestValidationError.DIDResolutionFailed) {
                authorizationRequestErrorCode = PROCESSING_FAILURE;
            } else if (authorizationRequestError instanceof ResolutionError.InvalidTransactionData) {
                authorizationRequestErrorCode = INVALID_TRANSACTION_DATA;
            } else if (Intrinsics.areEqual((Object)authorizationRequestError, (Object)ResolutionError.ClientVpFormatsNotSupportedFromWallet.INSTANCE)) {
                authorizationRequestErrorCode = VP_FORMATS_NOT_SUPPORTED;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return authorizationRequestErrorCode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

