/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.response;

import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEProvider;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/response/EncrypterFactory;", "", "<init>", "()V", "createEncrypter", "Lcom/nimbusds/jose/JWEEncrypter;", "algorithm", "Lcom/nimbusds/jose/JWEAlgorithm;", "recipientKey", "Lcom/nimbusds/jose/jwk/JWK;", "createEncrypterOrNull", "canBeUsed", "", "candidateRecipientKey", "SupportedFamilies", "", "Lcom/nimbusds/jose/JWEAlgorithm$Family;", "kotlin.jvm.PlatformType", "familyOf", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nResponseEncryption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseEncryption.kt\neu/europa/ec/eudi/openid4vp/internal/response/EncrypterFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n295#2,2:167\n*S KotlinDebug\n*F\n+ 1 ResponseEncryption.kt\neu/europa/ec/eudi/openid4vp/internal/response/EncrypterFactory\n*L\n164#1:167,2\n*E\n"})
public final class EncrypterFactory {
    @NotNull
    public static final EncrypterFactory INSTANCE = new EncrypterFactory();
    @NotNull
    private static final List<JWEAlgorithm.Family> SupportedFamilies;

    private EncrypterFactory() {
    }

    @NotNull
    public final JWEEncrypter createEncrypter(@NotNull JWEAlgorithm algorithm, @NotNull JWK recipientKey) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
        JWEEncrypter jWEEncrypter = this.createEncrypterOrNull(algorithm, recipientKey);
        if (jWEEncrypter == null) {
            throw new IllegalStateException(("Cannot find appropriate encryption key for " + algorithm.getName()).toString());
        }
        return jWEEncrypter;
    }

    @Nullable
    public final JWEEncrypter createEncrypterOrNull(@NotNull JWEAlgorithm algorithm, @NotNull JWK recipientKey) {
        JWEEncrypter jWEEncrypter;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
        JWEAlgorithm.Family family = this.familyOf(algorithm);
        if (family != null) {
            JWEAlgorithm.Family family2 = family;
            boolean bl = false;
            jWEEncrypter = (JWEEncrypter)(Intrinsics.areEqual((Object)family2, (Object)JWEAlgorithm.Family.ECDH_ES) && recipientKey instanceof ECKey ? (JWEProvider)new ECDHEncrypter((ECKey)recipientKey) : (Intrinsics.areEqual((Object)family2, (Object)JWEAlgorithm.Family.RSA) && recipientKey instanceof RSAKey ? (JWEProvider)new RSAEncrypter((RSAKey)recipientKey) : null));
        } else {
            jWEEncrypter = null;
        }
        return jWEEncrypter;
    }

    public final boolean canBeUsed(@NotNull JWEAlgorithm algorithm, @NotNull JWK candidateRecipientKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)candidateRecipientKey, (String)"candidateRecipientKey");
        JWEAlgorithm.Family family = this.familyOf(algorithm);
        if (family != null) {
            JWEAlgorithm.Family family2 = family;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)family2, (Object)JWEAlgorithm.Family.ECDH_ES) && candidateRecipientKey instanceof ECKey ? true : Intrinsics.areEqual((Object)family2, (Object)JWEAlgorithm.Family.RSA) && candidateRecipientKey instanceof RSAKey;
        } else {
            bl = false;
        }
        return bl;
    }

    private final JWEAlgorithm.Family familyOf(JWEAlgorithm algorithm) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = SupportedFamilies;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JWEAlgorithm.Family family = (JWEAlgorithm.Family)element$iv;
                boolean bl = false;
                if (!family.contains((Object)algorithm)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static {
        Object[] objectArray = new JWEAlgorithm.Family[]{JWEAlgorithm.Family.ECDH_ES, JWEAlgorithm.Family.RSA};
        SupportedFamilies = CollectionsKt.listOf((Object[])objectArray);
    }
}

