/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl.x509.impl;

import eu.europa.esig.dss.crl.AbstractCRLUtils;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.crl.ICRLUtils;
import eu.europa.esig.dss.crl.x509.impl.X509CRLValidity;
import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLUtilsX509CRLImpl
extends AbstractCRLUtils
implements ICRLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CRLUtilsX509CRLImpl.class);

    public CRLValidity buildCRLValidity(CRLBinary crlBinary, CertificateToken issuerToken) throws IOException {
        X509CRLValidity crlValidity = new X509CRLValidity(crlBinary);
        try (InputStream bais = crlValidity.toCRLInputStream();){
            X509CRL x509CRL = this.loadCRL(bais);
            crlValidity.setX509CRL(x509CRL);
            String sigAlgOID = x509CRL.getSigAlgOID();
            byte[] sigAlgParams = x509CRL.getSigAlgParams();
            crlValidity.setSignatureAlgorithm(SignatureAlgorithm.forOidAndParams((String)sigAlgOID, (byte[])sigAlgParams));
            crlValidity.setThisUpdate(x509CRL.getThisUpdate());
            crlValidity.setNextUpdate(x509CRL.getNextUpdate());
            X500Principal x509CRLIssuerX500Principal = x509CRL.getIssuerX500Principal();
            X500Principal issuerTokenSubjectX500Principal = issuerToken.getSubject().getPrincipal();
            if (x509CRLIssuerX500Principal.equals(issuerTokenSubjectX500Principal)) {
                crlValidity.setIssuerX509PrincipalMatches(true);
            }
            crlValidity.setCriticalExtensionsOid(x509CRL.getCriticalExtensionOIDs());
            this.extractIssuingDistributionPointBinary(crlValidity, x509CRL.getExtensionValue(Extension.issuingDistributionPoint.getId()));
            this.extractExpiredCertsOnCRL(crlValidity, x509CRL.getExtensionValue(Extension.expiredCertsOnCRL.getId()));
            this.checkSignatureValue(x509CRL, issuerToken, crlValidity);
            if (crlValidity.isSignatureIntact()) {
                crlValidity.setCrlSignKeyUsage(issuerToken.checkKeyUsage(KeyUsageBit.CRL_SIGN));
            }
        }
        return crlValidity;
    }

    private void checkSignatureValue(X509CRL x509CRL, CertificateToken issuerToken, CRLValidity crlValidity) {
        try {
            x509CRL.verify(issuerToken.getPublicKey());
            crlValidity.setSignatureIntact(true);
            crlValidity.setIssuerToken(issuerToken);
        }
        catch (GeneralSecurityException e) {
            String msg = String.format("CRL Signature cannot be validated : %s", e.getMessage());
            if (LOG.isTraceEnabled()) {
                LOG.trace(msg, (Throwable)e);
            } else {
                LOG.warn(msg);
            }
            crlValidity.setSignatureInvalidityReason(msg);
        }
    }

    public X509CRLEntry getRevocationInfo(CRLValidity crlValidity, BigInteger serialNumber) {
        X509CRL crl = null;
        if (crlValidity instanceof X509CRLValidity) {
            crl = ((X509CRLValidity)crlValidity).getX509CRL();
        }
        if (crl == null) {
            try (InputStream is = crlValidity.toCRLInputStream();){
                crl = this.loadCRL(is);
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to get revocation info. Reason : %s", e.getMessage()), (Throwable)e);
            }
        }
        return crl.getRevokedCertificate(serialNumber);
    }

    private X509CRL loadCRL(InputStream inputStream) {
        try {
            X509CRL crl = (X509CRL)this.getCertificateFactory().generateCRL(inputStream);
            if (crl == null) {
                throw new DSSException("Unable to parse the CRL");
            }
            return crl;
        }
        catch (CRLException e) {
            throw new DSSException(String.format("Unable to parse the CRL : %s", e.getMessage()), (Throwable)e);
        }
    }

    private CertificateFactory getCertificateFactory() {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            LOG.debug("CertificateFactory instantiated with BouncyCastle");
            return cf;
        }
        catch (NoSuchProviderException | CertificateException e) {
            LOG.debug("Unable to instantiate with BouncyCastle (not registered ?), trying with default CertificateFactory");
            try {
                return CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e1) {
                throw new DSSException("Unable to create CertificateFactory", (Throwable)e1);
            }
        }
    }
}

