/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.server.signing.common;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.token.AbstractKeyStoreTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteCertificateConverter;
import eu.europa.esig.dss.ws.dto.DigestDTO;
import eu.europa.esig.dss.ws.dto.RemoteCertificate;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.server.signing.common.RemoteSignatureTokenConnection;
import eu.europa.esig.dss.ws.server.signing.dto.RemoteKeyEntry;
import java.util.ArrayList;
import java.util.List;

public class RemoteSignatureTokenConnectionImpl
implements RemoteSignatureTokenConnection {
    private AbstractKeyStoreTokenConnection token;

    public void setToken(AbstractKeyStoreTokenConnection token) {
        this.token = token;
    }

    @Override
    public List<RemoteKeyEntry> getKeys() throws DSSException {
        ArrayList<RemoteKeyEntry> result = new ArrayList<RemoteKeyEntry>();
        List keys = this.token.getKeys();
        for (DSSPrivateKeyEntry keyEntry : keys) {
            result.add(this.convert((KSPrivateKeyEntry)keyEntry));
        }
        return result;
    }

    @Override
    public RemoteKeyEntry getKey(String alias) throws DSSException {
        KSPrivateKeyEntry key = (KSPrivateKeyEntry)this.token.getKey(alias);
        return this.convert(key);
    }

    @Override
    public SignatureValueDTO sign(ToBeSignedDTO toBeSigned, DigestAlgorithm digestAlgorithm, String alias) throws DSSException {
        return this.sign(toBeSigned, digestAlgorithm, null, alias);
    }

    @Override
    public SignatureValueDTO sign(ToBeSignedDTO toBeSigned, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf, String alias) throws DSSException {
        DSSPrivateKeyEntry key = this.token.getKey(alias);
        SignatureValue signatureValue = this.token.sign(DTOConverter.toToBeSigned((ToBeSignedDTO)toBeSigned), digestAlgorithm, mgf, key);
        return DTOConverter.toSignatureValueDTO((SignatureValue)signatureValue);
    }

    @Override
    public SignatureValueDTO sign(ToBeSignedDTO toBeSigned, SignatureAlgorithm signatureAlgorithm, String alias) throws DSSException {
        DSSPrivateKeyEntry key = this.token.getKey(alias);
        SignatureValue signatureValue = this.token.sign(DTOConverter.toToBeSigned((ToBeSignedDTO)toBeSigned), signatureAlgorithm, key);
        return DTOConverter.toSignatureValueDTO((SignatureValue)signatureValue);
    }

    @Override
    public SignatureValueDTO signDigest(DigestDTO digest, String alias) throws DSSException {
        return this.signDigest(digest, (MaskGenerationFunction)null, alias);
    }

    @Override
    public SignatureValueDTO signDigest(DigestDTO digest, MaskGenerationFunction mgf, String alias) throws DSSException {
        DSSPrivateKeyEntry key = this.token.getKey(alias);
        SignatureValue signatureValue = this.token.signDigest(DTOConverter.toDigest((DigestDTO)digest), mgf, key);
        return DTOConverter.toSignatureValueDTO((SignatureValue)signatureValue);
    }

    @Override
    public SignatureValueDTO signDigest(DigestDTO digest, SignatureAlgorithm signatureAlgorithm, String alias) throws DSSException {
        DSSPrivateKeyEntry key = this.token.getKey(alias);
        SignatureValue signatureValue = this.token.signDigest(DTOConverter.toDigest((DigestDTO)digest), signatureAlgorithm, key);
        return DTOConverter.toSignatureValueDTO((SignatureValue)signatureValue);
    }

    private RemoteKeyEntry convert(KSPrivateKeyEntry key) {
        if (key == null) {
            return null;
        }
        RemoteKeyEntry dto = new RemoteKeyEntry();
        dto.setAlias(key.getAlias());
        dto.setEncryptionAlgo(key.getEncryptionAlgorithm());
        dto.setCertificate(RemoteCertificateConverter.toRemoteCertificate((CertificateToken)key.getCertificate()));
        CertificateToken[] certificateChain = key.getCertificateChain();
        if (certificateChain != null) {
            RemoteCertificate[] dtos = new RemoteCertificate[certificateChain.length];
            int i = 0;
            for (CertificateToken certificateToken : certificateChain) {
                dtos[i] = RemoteCertificateConverter.toRemoteCertificate((CertificateToken)certificateToken);
                ++i;
            }
            dto.setCertificateChain(dtos);
        }
        return dto;
    }
}

