/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XAdESLevelC
extends XAdESLevelBaselineT {
    public XAdESLevelC(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        boolean cLevelRequired = false;
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.cLevelExtensionRequired()) continue;
            this.xadesSignature.resetCertificateSource();
            this.xadesSignature.resetRevocationSources();
            this.xadesSignature.resetTimestampSource();
            cLevelRequired = true;
        }
        if (!cLevelRequired) {
            return;
        }
        ValidationDataContainer validationDataContainer = this.documentValidator.getValidationData(signatures);
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.cLevelExtensionRequired()) continue;
            this.assertExtendSignatureToCPossible();
            String indent = this.removeOldCertificateRefs();
            this.removeOldRevocationRefs();
            ValidationData validationDataForInclusion = this.getValidationDataForCLevelInclusion(validationDataContainer, signature);
            Element levelTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            this.incorporateCertificateRefs(this.unsignedSignaturePropertiesDom, validationDataForInclusion.getCertificateTokens(), indent);
            if (Utils.isCollectionNotEmpty((Collection)validationDataForInclusion.getCrlTokens()) || Utils.isCollectionNotEmpty((Collection)validationDataForInclusion.getOcspTokens())) {
                Element completeRevocationRefsDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCompleteRevocationRefs());
                this.incorporateCRLRefs(completeRevocationRefsDom, validationDataForInclusion.getCrlTokens());
                this.incorporateOCSPRefs(completeRevocationRefsDom, validationDataForInclusion.getOcspTokens());
            }
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelTUnsignedProperties);
        }
    }

    private boolean cLevelExtensionRequired() {
        return SignatureLevel.XAdES_C.equals((Object)this.params.getSignatureLevel()) || SignatureLevel.XAdES_XL.equals((Object)this.params.getSignatureLevel()) || !this.xadesSignature.hasCProfile();
    }

    private String removeOldCertificateRefs() {
        String text = null;
        Element toRemove = this.xadesSignature.getCompleteCertificateRefs();
        if (toRemove != null) {
            text = this.removeNode(toRemove);
            this.xadesSignature.resetCertificateSource();
        }
        return text;
    }

    private void removeOldRevocationRefs() {
        Element toRemove = this.xadesSignature.getCompleteRevocationRefs();
        if (toRemove != null) {
            this.removeNode(toRemove);
            this.xadesSignature.resetRevocationSources();
        }
    }

    private void incorporateCertificateRefs(Element parentDom, Collection<CertificateToken> certificatesToBeAdded, String indent) {
        if (Utils.isCollectionNotEmpty(certificatesToBeAdded)) {
            Element completeCertificateRefsDom = this.createCompleteCertificateRefsDom(parentDom);
            Element certRefsDom = this.createCertRefsDom(completeCertificateRefsDom);
            DigestAlgorithm tokenReferencesDigestAlgorithm = this.params.getTokenReferencesDigestAlgorithm();
            for (CertificateToken certificateToken : certificatesToBeAdded) {
                this.incorporateCert(certRefsDom, certificateToken, tokenReferencesDigestAlgorithm);
            }
        }
    }

    private Element createCompleteCertificateRefsDom(Element parentDom) {
        if (this.params.isEn319132()) {
            return DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2);
        }
        return DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCompleteCertificateRefs());
    }

    private Element createCertRefsDom(Element parentDom) {
        if (this.params.isEn319132()) {
            return DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.CERT_REFS);
        }
        return DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCertRefs());
    }

    private ValidationData getValidationDataForCLevelInclusion(ValidationDataContainer validationDataContainer, AdvancedSignature signature) {
        ValidationData validationData = validationDataContainer.getAllValidationDataForSignature(signature);
        validationData.excludeCertificateTokens(this.getCertificateTokensForExclusion());
        return validationData;
    }

    private Collection<CertificateToken> getCertificateTokensForExclusion() {
        CertificateToken signingCertificateToken = this.xadesSignature.getSigningCertificateToken();
        if (signingCertificateToken != null) {
            return Collections.singletonList(signingCertificateToken);
        }
        return Collections.emptyList();
    }

    private void incorporateCRLRefs(Element completeRevocationRefsDom, Collection<CRLToken> crlTokens) {
        if (crlTokens.isEmpty()) {
            return;
        }
        Element crlRefsDom = DomUtils.addElement((Document)this.documentDom, (Element)completeRevocationRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCRLRefs());
        for (CRLToken crlToken : crlTokens) {
            Element crlRefDom = DomUtils.addElement((Document)this.documentDom, (Element)crlRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCRLRef());
            DigestAlgorithm digestAlgorithm = this.params.getTokenReferencesDigestAlgorithm();
            Element digestAlgAndValueDom = DomUtils.addElement((Document)this.documentDom, (Element)crlRefDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDigestAlgAndValue());
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, (Token)crlToken);
            Element crlIdentifierDom = DomUtils.addElement((Document)this.documentDom, (Element)crlRefDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCRLIdentifier());
            String issuerX500PrincipalName = crlToken.getIssuerX500Principal().getName();
            DomUtils.addTextElement((Document)this.documentDom, (Element)crlIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIssuer(), (String)issuerX500PrincipalName);
            Date thisUpdate = crlToken.getThisUpdate();
            XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar((Date)thisUpdate);
            String thisUpdateAsXmlFormat = xmlGregorianCalendar.toXMLFormat();
            DomUtils.addTextElement((Document)this.documentDom, (Element)crlIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIssueTime(), (String)thisUpdateAsXmlFormat);
        }
    }

    private void incorporateOCSPRefs(Element completeRevocationRefsDom, Collection<OCSPToken> ocspTokens) {
        if (ocspTokens.isEmpty()) {
            return;
        }
        Element ocspRefsDom = DomUtils.addElement((Document)this.documentDom, (Element)completeRevocationRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOCSPRefs());
        for (OCSPToken ocspToken : ocspTokens) {
            BasicOCSPResp basicOcspResp = ocspToken.getBasicOCSPResp();
            if (basicOcspResp == null) continue;
            Element ocspRefDom = DomUtils.addElement((Document)this.documentDom, (Element)ocspRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOCSPRef());
            Element ocspIdentifierDom = DomUtils.addElement((Document)this.documentDom, (Element)ocspRefDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOCSPIdentifier());
            Element responderIDDom = DomUtils.addElement((Document)this.documentDom, (Element)ocspIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementResponderID());
            RespID respID = basicOcspResp.getResponderId();
            ResponderId responderId = DSSRevocationUtils.getDSSResponderId((RespID)respID);
            if (responderId.getX500Principal() != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)responderIDDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementByName(), (String)responderId.getX500Principal().toString());
            } else {
                String base64EncodedKeyHashOctetStringBytes = Utils.toBase64((byte[])responderId.getSki());
                DomUtils.addTextElement((Document)this.documentDom, (Element)responderIDDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementByKey(), (String)base64EncodedKeyHashOctetStringBytes);
            }
            Date producedAt = basicOcspResp.getProducedAt();
            XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar((Date)producedAt);
            String producedAtXmlEncoded = xmlGregorianCalendar.toXMLFormat();
            DomUtils.addTextElement((Document)this.documentDom, (Element)ocspIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementProducedAt(), (String)producedAtXmlEncoded);
            DigestAlgorithm digestAlgorithm = this.params.getTokenReferencesDigestAlgorithm();
            Element digestAlgAndValueDom = DomUtils.addElement((Document)this.documentDom, (Element)ocspRefDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDigestAlgAndValue());
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, (Token)ocspToken);
        }
    }

    private void assertExtendSignatureToCPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_C.equals((Object)signatureLevel) && (this.xadesSignature.hasXProfile() || this.xadesSignature.hasAProfile() || this.xadesSignature.hasXLProfile() && !this.xadesSignature.areAllSelfSignedCertificates()) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel) && this.xadesSignature.hasAProfile()) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with higher level.", signatureLevel));
        }
        if (this.xadesSignature.areAllSelfSignedCertificates()) {
            throw new IllegalInputException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }
}

