/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.scope;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.scope.EncapsulatedTimestampScopeFinder;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.xml.security.signature.Reference;

public class XAdESTimestampScopeFinder
extends EncapsulatedTimestampScopeFinder {
    protected List<SignatureScope> filterCoveredSignatureScopes(TimestampToken timestampToken) {
        List timestampIncludes = timestampToken.getTimestampIncludes();
        if (Utils.isCollectionNotEmpty((Collection)timestampIncludes)) {
            ArrayList<SignatureScope> individualSignatureScopes = new ArrayList<SignatureScope>();
            XAdESSignature xadesSignature = (XAdESSignature)this.signature;
            for (Reference reference : xadesSignature.getReferences()) {
                List signatureScopes;
                if (!this.isContentTimestampedReference(reference, timestampIncludes) || !Utils.isCollectionNotEmpty((Collection)(signatureScopes = this.signature.getSignatureScopes()))) continue;
                for (SignatureScope signatureScope : signatureScopes) {
                    if (!Utils.endsWithIgnoreCase((String)reference.getURI(), (String)signatureScope.getName())) continue;
                    individualSignatureScopes.add(signatureScope);
                }
            }
            return individualSignatureScopes;
        }
        return super.filterCoveredSignatureScopes(timestampToken);
    }

    private boolean isContentTimestampedReference(Reference reference, List<TimestampInclude> includes) {
        for (TimestampInclude timestampInclude : includes) {
            if (!reference.getId().equals(timestampInclude.getURI())) continue;
            return true;
        }
        return false;
    }
}

