package fr.enedis.chutney.jira.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JiraConfigurationDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJiraConfigurationDto.builder()}.
 */
@Generated(from = "JiraConfigurationDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJiraConfigurationDto implements JiraConfigurationDto {
  private final String url;
  private final String username;
  private final String password;
  private final @Nullable String urlProxy;
  private final @Nullable String userProxy;
  private final @Nullable String passwordProxy;

  private ImmutableJiraConfigurationDto(
      String url,
      String username,
      String password,
      @Nullable String urlProxy,
      @Nullable String userProxy,
      @Nullable String passwordProxy) {
    this.url = url;
    this.username = username;
    this.password = password;
    this.urlProxy = urlProxy;
    this.userProxy = userProxy;
    this.passwordProxy = passwordProxy;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty(value = "url", required = true)
  @Override
  public String url() {
    return url;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty(value = "username", required = true)
  @Override
  public String username() {
    return username;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @JsonProperty(value = "password", required = true)
  @Override
  public String password() {
    return password;
  }

  /**
   * @return The value of the {@code urlProxy} attribute
   */
  @JsonProperty(value = "urlProxy")
  @Override
  public Optional<String> urlProxy() {
    return Optional.ofNullable(urlProxy);
  }

  /**
   * @return The value of the {@code userProxy} attribute
   */
  @JsonProperty(value = "userProxy")
  @Override
  public Optional<String> userProxy() {
    return Optional.ofNullable(userProxy);
  }

  /**
   * @return The value of the {@code passwordProxy} attribute
   */
  @JsonProperty(value = "passwordProxy")
  @Override
  public Optional<String> passwordProxy() {
    return Optional.ofNullable(passwordProxy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraConfigurationDto#url() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableJiraConfigurationDto withUrl(String value) {
    String newValue = Objects.requireNonNull(value, "url");
    if (this.url.equals(newValue)) return this;
    return new ImmutableJiraConfigurationDto(newValue, this.username, this.password, this.urlProxy, this.userProxy, this.passwordProxy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraConfigurationDto#username() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for username
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableJiraConfigurationDto withUsername(String value) {
    String newValue = Objects.requireNonNull(value, "username");
    if (this.username.equals(newValue)) return this;
    return new ImmutableJiraConfigurationDto(this.url, newValue, this.password, this.urlProxy, this.userProxy, this.passwordProxy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraConfigurationDto#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableJiraConfigurationDto withPassword(String value) {
    String newValue = Objects.requireNonNull(value, "password");
    if (this.password.equals(newValue)) return this;
    return new ImmutableJiraConfigurationDto(this.url, this.username, newValue, this.urlProxy, this.userProxy, this.passwordProxy);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link JiraConfigurationDto#urlProxy() urlProxy} attribute.
   * @param value The value for urlProxy
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableJiraConfigurationDto withUrlProxy(String value) {
    String newValue = Objects.requireNonNull(value, "urlProxy");
    if (Objects.equals(this.urlProxy, newValue)) return this;
    return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, newValue, this.userProxy, this.passwordProxy);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JiraConfigurationDto#urlProxy() urlProxy} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for urlProxy
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableJiraConfigurationDto withUrlProxy(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.urlProxy, value)) return this;
    return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, value, this.userProxy, this.passwordProxy);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link JiraConfigurationDto#userProxy() userProxy} attribute.
   * @param value The value for userProxy
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableJiraConfigurationDto withUserProxy(String value) {
    String newValue = Objects.requireNonNull(value, "userProxy");
    if (Objects.equals(this.userProxy, newValue)) return this;
    return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, newValue, this.passwordProxy);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JiraConfigurationDto#userProxy() userProxy} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for userProxy
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableJiraConfigurationDto withUserProxy(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.userProxy, value)) return this;
    return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, value, this.passwordProxy);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link JiraConfigurationDto#passwordProxy() passwordProxy} attribute.
   * @param value The value for passwordProxy
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableJiraConfigurationDto withPasswordProxy(String value) {
    String newValue = Objects.requireNonNull(value, "passwordProxy");
    if (Objects.equals(this.passwordProxy, newValue)) return this;
    return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, this.userProxy, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JiraConfigurationDto#passwordProxy() passwordProxy} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for passwordProxy
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableJiraConfigurationDto withPasswordProxy(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.passwordProxy, value)) return this;
    return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, this.userProxy, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJiraConfigurationDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJiraConfigurationDto
        && equalsByValue((ImmutableJiraConfigurationDto) another);
  }

  private boolean equalsByValue(ImmutableJiraConfigurationDto another) {
    return url.equals(another.url)
        && username.equals(another.username)
        && password.equals(another.password)
        && Objects.equals(urlProxy, another.urlProxy)
        && Objects.equals(userProxy, another.userProxy)
        && Objects.equals(passwordProxy, another.passwordProxy);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code username}, {@code password}, {@code urlProxy}, {@code userProxy}, {@code passwordProxy}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + url.hashCode();
    h += (h << 5) + username.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + Objects.hashCode(urlProxy);
    h += (h << 5) + Objects.hashCode(userProxy);
    h += (h << 5) + Objects.hashCode(passwordProxy);
    return h;
  }

  /**
   * Prints the immutable value {@code JiraConfigurationDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("JiraConfigurationDto{");
    builder.append("url=").append(url);
    builder.append(", ");
    builder.append("username=").append(username);
    builder.append(", ");
    builder.append("password=").append(password);
    if (urlProxy != null) {
      builder.append(", ");
      builder.append("urlProxy=").append(urlProxy);
    }
    if (userProxy != null) {
      builder.append(", ");
      builder.append("userProxy=").append(userProxy);
    }
    if (passwordProxy != null) {
      builder.append(", ");
      builder.append("passwordProxy=").append(passwordProxy);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JiraConfigurationDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json implements JiraConfigurationDto {
    @JsonIgnore @Nullable String _url;
    @JsonIgnore @Nullable String _username;
    @JsonIgnore @Nullable String _password;
    @JsonIgnore @Nullable Optional<String> _urlProxy = Optional.empty();
    @JsonIgnore @Nullable Optional<String> _userProxy = Optional.empty();
    @JsonIgnore @Nullable Optional<String> _passwordProxy = Optional.empty();

    @JsonProperty(value = "url", required = true)
    public void setUrl(String url) {
      this._url = url;
    }

    @JsonProperty(value = "username", required = true)
    public void setUsername(String username) {
      this._username = username;
    }

    @JsonProperty(value = "password", required = true)
    public void setPassword(String password) {
      this._password = password;
    }

    @JsonProperty(value = "urlProxy")
    public void setUrlProxy(Optional<String> urlProxy) {
      this._urlProxy = urlProxy;
    }

    @JsonProperty(value = "userProxy")
    public void setUserProxy(Optional<String> userProxy) {
      this._userProxy = userProxy;
    }

    @JsonProperty(value = "passwordProxy")
    public void setPasswordProxy(Optional<String> passwordProxy) {
      this._passwordProxy = passwordProxy;
    }

    @Override
    public String url() { throw new UnsupportedOperationException(); }

    @Override
    public String username() { throw new UnsupportedOperationException(); }

    @Override
    public String password() { throw new UnsupportedOperationException(); }

    @Override
    public Optional<String> urlProxy() { throw new UnsupportedOperationException(); }

    @Override
    public Optional<String> userProxy() { throw new UnsupportedOperationException(); }

    @Override
    public Optional<String> passwordProxy() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJiraConfigurationDto fromJson(Json json) {
    ImmutableJiraConfigurationDto.Builder builder = ImmutableJiraConfigurationDto.builder();
    if (json._url != null) {
      builder.url(json._url);
    }
    if (json._username != null) {
      builder.username(json._username);
    }
    if (json._password != null) {
      builder.password(json._password);
    }
    if (json._urlProxy != null) {
      builder.urlProxy(json._urlProxy);
    }
    if (json._userProxy != null) {
      builder.userProxy(json._userProxy);
    }
    if (json._passwordProxy != null) {
      builder.passwordProxy(json._passwordProxy);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JiraConfigurationDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JiraConfigurationDto instance
   */
  public static ImmutableJiraConfigurationDto copyOf(JiraConfigurationDto instance) {
    if (instance instanceof ImmutableJiraConfigurationDto) {
      return (ImmutableJiraConfigurationDto) instance;
    }
    return ImmutableJiraConfigurationDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJiraConfigurationDto ImmutableJiraConfigurationDto}.
   * <pre>
   * ImmutableJiraConfigurationDto.builder()
   *    .url(String) // required {@link JiraConfigurationDto#url() url}
   *    .username(String) // required {@link JiraConfigurationDto#username() username}
   *    .password(String) // required {@link JiraConfigurationDto#password() password}
   *    .urlProxy(Optional&lt;String&gt;) // optional {@link JiraConfigurationDto#urlProxy() urlProxy}
   *    .userProxy(Optional&lt;String&gt;) // optional {@link JiraConfigurationDto#userProxy() userProxy}
   *    .passwordProxy(Optional&lt;String&gt;) // optional {@link JiraConfigurationDto#passwordProxy() passwordProxy}
   *    .build();
   * </pre>
   * @return A new ImmutableJiraConfigurationDto builder
   */
  public static ImmutableJiraConfigurationDto.Builder builder() {
    return new ImmutableJiraConfigurationDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJiraConfigurationDto ImmutableJiraConfigurationDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JiraConfigurationDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_URL = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private static final long INIT_BIT_PASSWORD = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String url;
    private @Nullable String username;
    private @Nullable String password;
    private @Nullable String urlProxy;
    private @Nullable String userProxy;
    private @Nullable String passwordProxy;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JiraConfigurationDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JiraConfigurationDto instance) {
      Objects.requireNonNull(instance, "instance");
      this.url(instance.url());
      this.username(instance.username());
      this.password(instance.password());
      Optional<String> urlProxyOptional = instance.urlProxy();
      if (urlProxyOptional.isPresent()) {
        urlProxy(urlProxyOptional);
      }
      Optional<String> userProxyOptional = instance.userProxy();
      if (userProxyOptional.isPresent()) {
        userProxy(userProxyOptional);
      }
      Optional<String> passwordProxyOptional = instance.passwordProxy();
      if (passwordProxyOptional.isPresent()) {
        passwordProxy(passwordProxyOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JiraConfigurationDto#url() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "url", required = true)
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link JiraConfigurationDto#username() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "username", required = true)
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link JiraConfigurationDto#password() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "password", required = true)
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the optional value {@link JiraConfigurationDto#urlProxy() urlProxy} to urlProxy.
     * @param urlProxy The value for urlProxy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder urlProxy(String urlProxy) {
      this.urlProxy = Objects.requireNonNull(urlProxy, "urlProxy");
      return this;
    }

    /**
     * Initializes the optional value {@link JiraConfigurationDto#urlProxy() urlProxy} to urlProxy.
     * @param urlProxy The value for urlProxy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "urlProxy")
    public final Builder urlProxy(Optional<String> urlProxy) {
      this.urlProxy = urlProxy.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link JiraConfigurationDto#userProxy() userProxy} to userProxy.
     * @param userProxy The value for userProxy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder userProxy(String userProxy) {
      this.userProxy = Objects.requireNonNull(userProxy, "userProxy");
      return this;
    }

    /**
     * Initializes the optional value {@link JiraConfigurationDto#userProxy() userProxy} to userProxy.
     * @param userProxy The value for userProxy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "userProxy")
    public final Builder userProxy(Optional<String> userProxy) {
      this.userProxy = userProxy.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link JiraConfigurationDto#passwordProxy() passwordProxy} to passwordProxy.
     * @param passwordProxy The value for passwordProxy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder passwordProxy(String passwordProxy) {
      this.passwordProxy = Objects.requireNonNull(passwordProxy, "passwordProxy");
      return this;
    }

    /**
     * Initializes the optional value {@link JiraConfigurationDto#passwordProxy() passwordProxy} to passwordProxy.
     * @param passwordProxy The value for passwordProxy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "passwordProxy")
    public final Builder passwordProxy(Optional<String> passwordProxy) {
      this.passwordProxy = passwordProxy.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableJiraConfigurationDto ImmutableJiraConfigurationDto}.
     * @return An immutable instance of JiraConfigurationDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJiraConfigurationDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJiraConfigurationDto(url, username, password, urlProxy, userProxy, passwordProxy);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      return "Cannot build JiraConfigurationDto, some of required attributes are not set " + attributes;
    }
  }
}
