/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools;

import fr.pilato.elasticsearch.tools.updaters.ElasticsearchAliasUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchComponentTemplateUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchIndexLifecycleUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchIndexTemplateUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchIndexUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchPipelineUpdater;
import fr.pilato.elasticsearch.tools.updaters.ElasticsearchTemplateUpdater;
import fr.pilato.elasticsearch.tools.util.ResourceList;
import fr.pilato.elasticsearch.tools.util.SettingsFinder;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchBeyonder {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchBeyonder.class);

    public static void start(RestClient client) throws Exception {
        ElasticsearchBeyonder.start(client, SettingsFinder.Defaults.ConfigDir);
    }

    public static void start(RestClient client, String root) throws Exception {
        ElasticsearchBeyonder.start(client, root, SettingsFinder.Defaults.MergeMappings, SettingsFinder.Defaults.ForceCreation);
    }

    @Deprecated
    public static void start(RestClient client, String root, boolean merge, boolean force) throws Exception {
        ElasticsearchBeyonder.start(client, root, force);
    }

    /*
     * WARNING - void declaration
     */
    public static void start(RestClient client, String root, boolean force) throws Exception {
        void var7_15;
        List<String> list;
        logger.info("starting automatic settings/mappings discovery");
        List<String> templateNames = ResourceList.getResourceNames(root, SettingsFinder.Defaults.TemplatesDir);
        if (templateNames.isEmpty() && !(templateNames = ResourceList.getResourceNames(root, SettingsFinder.Defaults.TemplateDir)).isEmpty()) {
            logger.warn("{} dir has been deprecated. Please use {} dir instead.", (Object)SettingsFinder.Defaults.TemplateDir, (Object)SettingsFinder.Defaults.TemplatesDir);
        }
        for (String string : templateNames) {
            logger.warn("Legacy Templates are deprecated in Elasticsearch. Switch to Index Templates instead by using {}/{}{}", new Object[]{SettingsFinder.Defaults.IndexTemplatesDir, string, SettingsFinder.Defaults.JsonFileExtension});
            ElasticsearchTemplateUpdater.createTemplate(client, root, string);
        }
        List<String> indexLifecycles = ResourceList.getResourceNames(root, SettingsFinder.Defaults.IndexLifecyclesDir);
        for (String string : indexLifecycles) {
            ElasticsearchIndexLifecycleUpdater.createIndexLifecycle(client, root, string);
        }
        List<String> list2 = ResourceList.getResourceNames(root, SettingsFinder.Defaults.ComponentTemplatesDir);
        for (String string : list2) {
            ElasticsearchComponentTemplateUpdater.createComponentTemplate(client, root, string);
        }
        List<String> list3 = ResourceList.getResourceNames(root, SettingsFinder.Defaults.IndexTemplatesDir);
        for (String string : list3) {
            ElasticsearchIndexTemplateUpdater.createIndexTemplate(client, root, string);
        }
        List<String> list4 = ResourceList.getResourceNames(root, SettingsFinder.Defaults.PipelinesDir);
        if (list4.isEmpty() && !(list = ResourceList.getResourceNames(root, SettingsFinder.Defaults.PipelineDir)).isEmpty()) {
            logger.warn("{} dir has been deprecated. Please use {} dir instead.", (Object)SettingsFinder.Defaults.PipelineDir, (Object)SettingsFinder.Defaults.PipelinesDir);
        }
        for (String pipelineName : var7_15) {
            ElasticsearchPipelineUpdater.createPipeline(client, root, pipelineName);
        }
        List<String> list5 = ResourceList.findIndexNames(root);
        for (String indexName : list5) {
            ElasticsearchIndexUpdater.createIndex(client, root, indexName, force);
            ElasticsearchIndexUpdater.updateSettings(client, root, indexName);
            ElasticsearchIndexUpdater.updateMapping(client, root, indexName);
        }
        ElasticsearchAliasUpdater.manageAliases(client, root);
        logger.info("start done. Rock & roll!");
    }

    @Deprecated
    public static void start(Client client) throws Exception {
        ElasticsearchBeyonder.start(client, SettingsFinder.Defaults.ConfigDir);
    }

    @Deprecated
    public static void start(Client client, String root) throws Exception {
        logger.info("starting automatic settings/mappings discovery");
        boolean force = SettingsFinder.Defaults.ForceCreation;
        List<String> templateNames = ResourceList.getResourceNames(root, SettingsFinder.Defaults.TemplatesDir);
        if (templateNames.isEmpty() && !(templateNames = ResourceList.getResourceNames(root, SettingsFinder.Defaults.TemplateDir)).isEmpty()) {
            logger.warn("{} dir has been deprecated. Please use {} dir instead.", (Object)SettingsFinder.Defaults.TemplateDir, (Object)SettingsFinder.Defaults.TemplatesDir);
        }
        for (String templateName : templateNames) {
            logger.warn("Legacy Templates are deprecated in Elasticsearch. Switch to Index Templates instead by using {}/{}{}", new Object[]{SettingsFinder.Defaults.IndexTemplatesDir, templateName, SettingsFinder.Defaults.JsonFileExtension});
            ElasticsearchTemplateUpdater.createTemplate(client, root, templateName);
        }
        List<String> indexNames = ResourceList.findIndexNames(root);
        for (String indexName : indexNames) {
            ElasticsearchIndexUpdater.createIndex(client, root, indexName, force);
            ElasticsearchIndexUpdater.updateSettings(client, root, indexName);
            ElasticsearchIndexUpdater.updateMapping(client, root, indexName);
        }
        logger.info("start done. Rock & roll!");
    }
}

