/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.updaters;

import fr.pilato.elasticsearch.tools.util.DefaultSettings;
import fr.pilato.elasticsearch.tools.util.ResourceList;
import fr.pilato.elasticsearch.tools.util.SettingsReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchIndexUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchIndexUpdater.class);

    private ElasticsearchIndexUpdater() {
    }

    public static boolean createIndex(RestClient client, String root, String index, boolean force) throws Exception {
        String json = SettingsReader.getJsonContent(root, index, DefaultSettings.IndexSettingsFileName);
        return ElasticsearchIndexUpdater.createIndexWithSettings(client, index, json, force);
    }

    private static boolean createIndexWithSettings(RestClient client, String index, String settings, boolean force) throws Exception {
        if (force && ElasticsearchIndexUpdater.isIndexExist(client, index)) {
            logger.debug("Index [{}] already exists but force set to true. Removing all data!", (Object)index);
            ElasticsearchIndexUpdater.removeIndexInElasticsearch(client, index);
        }
        if (force || !ElasticsearchIndexUpdater.isIndexExist(client, index)) {
            logger.debug("Index [{}] doesn't exist. Creating it.", (Object)index);
            ElasticsearchIndexUpdater.createIndexWithSettingsInElasticsearch(client, index, settings);
            return true;
        }
        logger.debug("Index [{}] already exists.", (Object)index);
        return false;
    }

    private static void removeIndexInElasticsearch(RestClient client, String index) throws Exception {
        int statusCode;
        logger.trace("removeIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        try {
            Response response = client.performRequest(new Request("DELETE", "/" + index));
            statusCode = response.getStatusLine().getStatusCode();
        }
        catch (ResponseException e) {
            statusCode = e.getResponse().getStatusLine().getStatusCode();
        }
        if (statusCode != 200 && statusCode != 404) {
            logger.warn("Could not delete index [{}]", (Object)index);
            throw new Exception("Could not delete index [" + index + "].");
        }
        logger.trace("/removeIndex([{}])", (Object)index);
    }

    private static void createIndexWithSettingsInElasticsearch(RestClient client, String index, String settings) throws Exception {
        Response response;
        logger.trace("createIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        Request request = new Request("PUT", "/" + index);
        if (settings != null) {
            logger.trace("Found settings for index [{}]: [{}]", (Object)index, (Object)settings);
            request.setJsonEntity(settings);
        }
        if ((response = client.performRequest(request)).getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not create index [{}]", (Object)index);
            throw new Exception("Could not create index [" + index + "].");
        }
        logger.trace("/createIndex([{}])", (Object)index);
    }

    private static void updateIndexWithSettingsInElasticsearch(RestClient client, String index, String settings) throws Exception {
        logger.trace("updateIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        if (settings != null) {
            logger.trace("Found update settings for index [{}]: [{}]", (Object)index, (Object)settings);
            logger.debug("updating settings for index [{}]", (Object)index);
            Request request = new Request("PUT", "/" + index + "/_settings");
            request.setJsonEntity(settings);
            client.performRequest(request);
        }
        logger.trace("/updateIndex([{}])", (Object)index);
    }

    private static void updateMappingInElasticsearch(RestClient client, String index, String mapping) throws Exception {
        logger.trace("updateMapping([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        if (mapping != null) {
            logger.trace("Found update mapping for index [{}]: [{}]", (Object)index, (Object)mapping);
            logger.debug("updating mapping for index [{}]", (Object)index);
            Request request = new Request("PUT", "/" + index + "/_mapping");
            request.setJsonEntity(mapping);
            client.performRequest(request);
        }
        logger.trace("/updateMapping([{}])", (Object)index);
    }

    public static boolean isIndexExist(RestClient client, String index) throws Exception {
        try {
            Response response = client.performRequest(new Request("GET", "/" + ResourceList.replaceIndexName(index)));
            String responseBody = new BufferedReader(new InputStreamReader(response.getEntity().getContent())).lines().reduce("", (accumulator, actual) -> accumulator + actual);
            logger.trace("{}", (Object)responseBody);
            return !"{}".equals(responseBody);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public static void updateSettings(RestClient client, String root, String index) throws Exception {
        String json = SettingsReader.getJsonContent(root, index, DefaultSettings.UpdateIndexSettingsFileName);
        ElasticsearchIndexUpdater.updateIndexWithSettingsInElasticsearch(client, index, json);
    }

    public static void updateMapping(RestClient client, String root, String index) throws Exception {
        String json = SettingsReader.getJsonContent(root, index, DefaultSettings.UpdateIndexMappingFileName);
        ElasticsearchIndexUpdater.updateMappingInElasticsearch(client, index, json);
    }
}

