/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.util;

import fr.pilato.elasticsearch.tools.util.DefaultSettings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsReader {
    private static final Logger logger = LoggerFactory.getLogger(SettingsReader.class);

    private SettingsReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileFromClasspath(String file) {
        logger.trace("Reading file [{}]...", (Object)file);
        String content = null;
        try (InputStream asStream = SettingsReader.class.getClassLoader().getResourceAsStream(file);){
            if (asStream == null) {
                logger.trace("Can not find [{}] in class loader.", (Object)file);
                String string = null;
                return string;
            }
            content = IOUtils.toString((InputStream)asStream, (Charset)StandardCharsets.UTF_8);
            return content;
        }
        catch (IOException e) {
            logger.warn("Can not read [{}].", (Object)file);
        }
        return content;
    }

    public static String getJsonContent(String root, String subdir, String name) {
        String content = SettingsReader.getFileContent(root, subdir, name);
        return StringSubstitutor.replace((Object)content, System.getenv());
    }

    public static String getFileContent(String root, String subdir, String name) {
        String path = root;
        if (root == null) {
            path = DefaultSettings.ConfigDir;
        }
        if (subdir != null) {
            path = path + "/" + subdir;
        }
        path = path + "/" + name;
        logger.debug("Reading file [{}] from the classpath.", (Object)path);
        return SettingsReader.readFileFromClasspath(path);
    }
}

