/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.updaters;

import fr.pilato.elasticsearch.tools.util.SettingsReader;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchAliasUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchAliasUpdater.class);

    private ElasticsearchAliasUpdater() {
    }

    public static void manageAliases(RestClient client, String root) throws Exception {
        String json = SettingsReader.getJsonContent(root, null, "_aliases.json");
        if (json != null) {
            logger.debug("Found [{}/{}] file", (Object)root, (Object)"_aliases.json");
            ElasticsearchAliasUpdater.manageAliasesWithJsonInElasticsearch(client, json);
        }
    }

    private static void manageAliasesWithJsonInElasticsearch(RestClient client, String json) throws Exception {
        logger.trace("manageAliases()");
        assert (client != null);
        assert (json != null);
        Request request = new Request("POST", "/_aliases/");
        request.setJsonEntity(json);
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not manage aliases. Got error: {}: {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
            throw new Exception("Could not manage aliases.");
        }
        logger.trace("/manageAliases()");
    }
}

