/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.updaters;

import fr.pilato.elasticsearch.tools.util.SettingsReader;
import java.util.Collection;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchDataUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchDataUpdater.class);

    private ElasticsearchDataUpdater() {
    }

    public static void loadBulkData(RestClient client, String root, String index, Collection<String> bulkFiles) throws Exception {
        Object subdir = index == null ? "_data" : index + "/_data";
        for (String bulkFile : bulkFiles) {
            String ndjson = SettingsReader.getFileContent(root, (String)subdir, bulkFile);
            if (ndjson == null) continue;
            logger.debug("Found [{}/{}/{}] file", new Object[]{root, subdir, bulkFile});
            ElasticsearchDataUpdater.loadBulkDataToElasticsearch(client, index, bulkFile, ndjson);
        }
    }

    public static void loadJsonData(RestClient client, String root, String index, Collection<String> jsonFiles) throws Exception {
        if (index == null) {
            throw new Exception("You must provide an index name when you want to load data from a json file.");
        }
        String subdir = index + "/_data";
        for (String jsonFile : jsonFiles) {
            String json = SettingsReader.getFileContent(root, subdir, jsonFile);
            if (json == null) continue;
            logger.debug("Found [{}/{}/{}] file", new Object[]{root, subdir, jsonFile});
            ElasticsearchDataUpdater.loadJsonDataToElasticsearch(client, index, jsonFile, json);
        }
    }

    private static void loadBulkDataToElasticsearch(RestClient client, String index, String bulkFile, String ndjson) throws Exception {
        logger.trace("loadBulkDataToElasticsearch([{}], [{}], [{}])", new Object[]{index, bulkFile, ndjson.length()});
        assert (client != null);
        Object endpoint = "/";
        if (index != null) {
            endpoint = (String)endpoint + index + "/";
        }
        endpoint = (String)endpoint + "_bulk";
        Request request = new Request("POST", (String)endpoint);
        request.setJsonEntity(ndjson);
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not load bulk file [{}] of size [{}] into Elasticsearch", (Object)bulkFile, (Object)ndjson.length());
            throw new Exception("Could not load bulk data from file [" + bulkFile + "].");
        }
        logger.trace("/loadBulkDataToElasticsearch([{}], [{}], [{}])", new Object[]{index, bulkFile, ndjson.length()});
    }

    private static void loadJsonDataToElasticsearch(RestClient client, String index, String jsonFile, String json) throws Exception {
        logger.trace("loadJsonDataToElasticsearch([{}], [{}], [{}])", new Object[]{index, jsonFile, json.length()});
        assert (client != null);
        String endpoint = "/" + index + "/_doc/";
        Request request = new Request("POST", endpoint);
        request.setJsonEntity(json);
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 201) {
            logger.warn("Could not load json file [{}] of size [{}] into Elasticsearch", (Object)jsonFile, (Object)json.length());
            throw new Exception("Could not load json data from file [" + jsonFile + "].");
        }
        logger.trace("/loadJsonDataToElasticsearch([{}], [{}], [{}])", new Object[]{index, jsonFile, json.length()});
    }
}

