/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit;

import gov.loc.repository.bagit.BagFile;
import java.text.MessageFormat;
import java.util.List;

public interface FetchTxt
extends List<FilenameSizeUrl>,
BagFile {
    public static final String NO_SIZE_MARKER = "-";

    public static class FilenameSizeUrl {
        private String filename;
        private Long size;
        private String url;
        private FetchStatus fetchStatus;

        public FilenameSizeUrl() {
        }

        public FilenameSizeUrl(String filename, Long size, String url) {
            this.setFilename(filename);
            this.setSize(size);
            this.setUrl(url);
        }

        public FilenameSizeUrl(String filename, Long size, String url, FetchStatus fetchStatus) {
            this.setFilename(filename);
            this.setSize(size);
            this.setUrl(url);
            this.setFetchStatus(fetchStatus);
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        public Long getSize() {
            return this.size;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public FetchStatus getFetchStatus() {
            return this.fetchStatus;
        }

        public void setFetchStatus(FetchStatus fetchStatus) {
            this.fetchStatus = fetchStatus;
        }

        public String toString() {
            String size = FetchTxt.NO_SIZE_MARKER;
            if (this.size != null) {
                size = this.size.toString();
            }
            return MessageFormat.format("Filename is {0}. Size is {1}. Url is {2}. Fetch status is {3}.", new Object[]{this.filename, size, this.url, this.fetchStatus});
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FilenameSizeUrl other = (FilenameSizeUrl)obj;
            if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }

    public static enum FetchStatus {
        NOT_FETCHED,
        FETCH_FAILED,
        VERIFY_FAILED,
        SUCCEEDED;

    }
}

