/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagHelper;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.BagItTxt;
import gov.loc.repository.bagit.BagVisitor;
import gov.loc.repository.bagit.DeclareCloseable;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.filesystem.DirNode;
import gov.loc.repository.bagit.filesystem.FileNode;
import gov.loc.repository.bagit.filesystem.FileSystemFactory;
import gov.loc.repository.bagit.filesystem.FileSystemNode;
import gov.loc.repository.bagit.filesystem.filter.FileNodeFileSystemNodeFilter;
import gov.loc.repository.bagit.filesystem.filter.IgnoringFileSystemNodeFilter;
import gov.loc.repository.bagit.impl.AddFilesToPayloadOperation;
import gov.loc.repository.bagit.impl.AddFilesToTagsOperation;
import gov.loc.repository.bagit.impl.FileSystemBagFile;
import gov.loc.repository.bagit.transformer.Completer;
import gov.loc.repository.bagit.transformer.HolePuncher;
import gov.loc.repository.bagit.transformer.impl.DefaultCompleter;
import gov.loc.repository.bagit.transformer.impl.HolePuncherImpl;
import gov.loc.repository.bagit.utilities.CancelUtil;
import gov.loc.repository.bagit.utilities.FileHelper;
import gov.loc.repository.bagit.utilities.FilenameHelper;
import gov.loc.repository.bagit.utilities.FormatHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import gov.loc.repository.bagit.verify.Verifier;
import gov.loc.repository.bagit.verify.impl.CompleteVerifierImpl;
import gov.loc.repository.bagit.verify.impl.ParallelManifestChecksumVerifier;
import gov.loc.repository.bagit.verify.impl.ValidVerifierImpl;
import gov.loc.repository.bagit.writer.Writer;
import java.io.Closeable;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBag
implements Bag {
    private static final Log log = LogFactory.getLog(AbstractBag.class);
    private Map<String, BagFile> tagMap = new HashMap<String, BagFile>();
    private Map<String, BagFile> payloadMap = new HashMap<String, BagFile>();
    private File fileForBag = null;
    private Bag.BagPartFactory bagPartFactory = null;
    private Bag.BagConstants bagConstants = null;
    private BagFactory bagFactory = null;
    private Set<Closeable> closeables = new HashSet<Closeable>();
    private volatile boolean isClosed = false;

    public AbstractBag(Bag.BagPartFactory bagPartFactory, Bag.BagConstants bagConstants, BagFactory bagFactory) {
        this.bagPartFactory = bagPartFactory;
        this.bagConstants = bagConstants;
        this.bagFactory = bagFactory;
        log.debug((Object)MessageFormat.format("Creating new bag. Version is {0}.", this.getBagConstants().getVersion().toString()));
    }

    @Override
    public File getFile() {
        return this.fileForBag;
    }

    @Override
    public void setFile(File file) {
        this.fileForBag = FileHelper.normalizeForm(file);
    }

    @Override
    public BagFactory.Version getVersion() {
        return this.getBagConstants().getVersion();
    }

    @Override
    public void loadFromManifests() {
        log.debug((Object)MessageFormat.format("Loading from {0} using payload manifests", this.fileForBag));
        this.tagMap.clear();
        this.payloadMap.clear();
        DirNode bagFileDirNode = null;
        try {
            bagFileDirNode = FileSystemFactory.getDirNodeForBag(this.fileForBag, this.bagFactory);
            log.trace((Object)MessageFormat.format("BagFileDirNode has filepath {0} and is a {1}", bagFileDirNode.getFilepath(), bagFileDirNode.getClass().getSimpleName()));
            for (FileSystemNode fileSystemNode : bagFileDirNode.listChildren(this.bagFactory.getDefaultNodeFilter())) {
                if (!(fileSystemNode instanceof FileNode)) continue;
                FileNode tagFileNode = (FileNode)fileSystemNode;
                String filepath = FilenameHelper.removeBasePath(bagFileDirNode.getFilepath(), tagFileNode.getFilepath());
                log.trace((Object)MessageFormat.format("Loading tag {0} using filepath {1}", tagFileNode.getFilepath(), filepath));
                FileSystemBagFile bagFile = new FileSystemBagFile(filepath, tagFileNode);
                this.putBagFile(bagFile);
            }
            List<Manifest> tagManifests = this.getTagManifests();
            for (Manifest manifest : tagManifests) {
                for (String filepath : manifest.keySet()) {
                    String fullFilepath = FilenameHelper.concatFilepath(bagFileDirNode.getFilepath(), filepath);
                    FileNode tagFileNode = bagFileDirNode.getFileSystem().resolve(fullFilepath);
                    FileSystemBagFile bagFile = new FileSystemBagFile(filepath, tagFileNode);
                    log.trace((Object)MessageFormat.format("Loading tag {0} from {1} using filepath {2}", tagFileNode.getFilepath(), manifest.getFilepath(), filepath));
                    this.putBagFile(bagFile);
                }
            }
            List<Manifest> list = this.getPayloadManifests();
            for (Manifest manifest : list) {
                for (String filepath : manifest.keySet()) {
                    String fullFilepath = FilenameHelper.concatFilepath(bagFileDirNode.getFilepath(), filepath);
                    FileNode payloadFileNode = bagFileDirNode.getFileSystem().resolve(fullFilepath);
                    FileSystemBagFile bagFile = new FileSystemBagFile(filepath, payloadFileNode);
                    log.trace((Object)MessageFormat.format("Loading payload {0} from {1} using filepath {2}", payloadFileNode.getFilepath(), manifest.getFilepath(), filepath));
                    this.putBagFile(bagFile);
                }
            }
        }
        catch (FormatHelper.UnknownFormatException e) {
            throw new RuntimeException(e);
        }
        catch (FileSystemFactory.UnsupportedFormatException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void loadFromFiles() {
        this.loadFromFiles(new ArrayList<String>());
    }

    @Override
    public void loadFromFiles(List<String> ignoreAdditionalDirectories) {
        DirNode bagFileDirNode;
        log.debug((Object)MessageFormat.format("Loading from {0} using payload files", this.fileForBag));
        this.tagMap.clear();
        this.payloadMap.clear();
        try {
            bagFileDirNode = FileSystemFactory.getDirNodeForBag(this.fileForBag, this.bagFactory);
        }
        catch (FormatHelper.UnknownFormatException e) {
            throw new RuntimeException(e);
        }
        catch (FileSystemFactory.UnsupportedFormatException e) {
            throw new RuntimeException(e);
        }
        log.trace((Object)MessageFormat.format("BagFileDirNode has filepath {0} and is a {1}", bagFileDirNode.getFilepath(), bagFileDirNode.getClass().getSimpleName()));
        IgnoringFileSystemNodeFilter descentFilter = new IgnoringFileSystemNodeFilter(ignoreAdditionalDirectories, false);
        descentFilter.setRelativeFilepath(bagFileDirNode.getFilepath());
        Collection<FileSystemNode> nodes = bagFileDirNode.listDescendants(new FileNodeFileSystemNodeFilter(), descentFilter);
        log.trace((Object)MessageFormat.format("{0} files found", nodes.size()));
        for (FileSystemNode node : nodes) {
            log.trace((Object)("Reading " + node.getFilepath()));
            String filepath = FilenameHelper.removeBasePath(bagFileDirNode.getFilepath(), node.getFilepath());
            FileSystemBagFile bagFile = new FileSystemBagFile(filepath, (FileNode)node);
            log.trace((Object)MessageFormat.format("Loading {0} using filepath {1}", node.getFilepath(), filepath));
            this.putBagFile(bagFile);
        }
    }

    @Override
    public List<Manifest> getPayloadManifests() {
        log.debug((Object)"Getting payload manifests");
        this.checkClosed();
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        for (BagFile bagFile : this.tagMap.values()) {
            log.trace((Object)MessageFormat.format("Checking if {0} is a payload manifest", bagFile.getFilepath()));
            if (!(bagFile instanceof Manifest)) continue;
            log.trace((Object)MessageFormat.format("{0} is a manifest", bagFile.getFilepath()));
            Manifest manifest = (Manifest)bagFile;
            if (!manifest.isPayloadManifest()) continue;
            log.trace((Object)MessageFormat.format("{0} is a payload manifest", bagFile.getFilepath()));
            manifests.add(manifest);
        }
        return manifests;
    }

    @Override
    public List<Manifest> getTagManifests() {
        log.debug((Object)"Getting tag manifests");
        this.checkClosed();
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        for (BagFile bagFile : this.tagMap.values()) {
            log.trace((Object)MessageFormat.format("Checking if {0} is a tag manifest", bagFile.getFilepath()));
            if (!(bagFile instanceof Manifest)) continue;
            log.trace((Object)MessageFormat.format("{0} is a manifest", bagFile.getFilepath()));
            Manifest manifest = (Manifest)bagFile;
            if (!manifest.isTagManifest()) continue;
            log.trace((Object)MessageFormat.format("{0} is a tag manifest", bagFile.getFilepath()));
            manifests.add(manifest);
        }
        return manifests;
    }

    @Override
    public void putBagFile(BagFile bagFile) {
        this.checkClosed();
        log.trace((Object)MessageFormat.format("Putting bag file {0}", bagFile.getFilepath()));
        if (bagFile instanceof DeclareCloseable) {
            this.closeables.add(((DeclareCloseable)((Object)bagFile)).declareCloseable());
        }
        if (BagHelper.isPayload(bagFile.getFilepath(), this.getBagConstants())) {
            log.trace((Object)MessageFormat.format("Adding bag file {0} to payload map", bagFile.getFilepath()));
            this.payloadMap.put(bagFile.getFilepath(), bagFile);
        } else if (bagFile.exists() && !(bagFile instanceof Manifest) && (ManifestHelper.isPayloadManifest(bagFile.getFilepath(), this.getBagConstants()) || ManifestHelper.isTagManifest(bagFile.getFilepath(), this.getBagConstants()))) {
            log.trace((Object)MessageFormat.format("Adding bag file {0} to tag map as a Manifest", bagFile.getFilepath()));
            this.tagMap.put(bagFile.getFilepath(), this.getBagPartFactory().createManifest(bagFile.getFilepath(), bagFile));
        } else if (bagFile.exists() && !(bagFile instanceof BagItTxt) && bagFile.getFilepath().equals(this.getBagConstants().getBagItTxt())) {
            log.trace((Object)MessageFormat.format("Adding bag file {0} to tag map as a BagItTxt", bagFile.getFilepath()));
            this.tagMap.put(bagFile.getFilepath(), this.getBagPartFactory().createBagItTxt(bagFile));
        } else if (bagFile.exists() && !(bagFile instanceof BagInfoTxt) && bagFile.getFilepath().equals(this.getBagConstants().getBagInfoTxt())) {
            log.trace((Object)MessageFormat.format("Adding bag file {0} to tag map as a BagInfoTxt", bagFile.getFilepath()));
            this.tagMap.put(bagFile.getFilepath(), this.getBagPartFactory().createBagInfoTxt(bagFile));
        } else if (bagFile.exists() && !(bagFile instanceof FetchTxt) && bagFile.getFilepath().equals(this.getBagConstants().getFetchTxt())) {
            log.trace((Object)MessageFormat.format("Adding bag file {0} to tag map as a FetchTxt", bagFile.getFilepath()));
            this.tagMap.put(bagFile.getFilepath(), this.getBagPartFactory().createFetchTxt(bagFile));
        } else if (bagFile.exists() && !(bagFile instanceof FetchTxt) && bagFile.getFilepath().equals(this.getBagConstants().getFetchProgressTxt())) {
            log.trace((Object)MessageFormat.format("Adding bag file {0} to tag map as a FetchProgressTxt", bagFile.getFilepath()));
            this.tagMap.put(bagFile.getFilepath(), this.getBagPartFactory().createFetchProgressTxt(bagFile));
        } else {
            log.trace((Object)MessageFormat.format("Adding bag file {0} to tag map", bagFile.getFilepath()));
            this.tagMap.put(bagFile.getFilepath(), bagFile);
        }
    }

    @Override
    public void putBagFiles(Collection<BagFile> bagFiles) {
        this.checkClosed();
        for (BagFile bagFile : bagFiles) {
            this.putBagFile(bagFile);
        }
    }

    @Override
    public void removeBagFile(String filepath) {
        this.checkClosed();
        if (BagHelper.isPayload(filepath, this.getBagConstants())) {
            if (!this.payloadMap.containsKey(filepath)) {
                throw new RuntimeException(MessageFormat.format("Payload file {0} not contained in bag.", filepath));
            }
            this.payloadMap.remove(filepath);
        } else {
            if (!this.tagMap.containsKey(filepath)) {
                throw new RuntimeException(MessageFormat.format("Tag file {0} not contained in bag.", filepath));
            }
            this.tagMap.remove(filepath);
        }
    }

    @Override
    public void addFileToPayload(File file) {
        this.checkClosed();
        new AddFilesToPayloadOperation(this).addFileToPayload(file);
    }

    @Override
    public void addFilesToPayload(List<File> files) {
        this.checkClosed();
        new AddFilesToPayloadOperation(this).addFilesToPayload(files);
    }

    @Override
    public Collection<BagFile> getPayload() {
        this.checkClosed();
        return this.payloadMap.values();
    }

    @Override
    public Collection<BagFile> getTags() {
        this.checkClosed();
        return this.tagMap.values();
    }

    @Override
    public BagFile getBagFile(String filepath) {
        this.checkClosed();
        if (BagHelper.isPayload(filepath, this.getBagConstants())) {
            return this.payloadMap.get(filepath);
        }
        return this.tagMap.get(filepath);
    }

    @Override
    public void addFileAsTag(File file) {
        this.checkClosed();
        new AddFilesToTagsOperation(this).addFileToTags(file);
    }

    @Override
    public void addFilesAsTag(List<File> files) {
        this.checkClosed();
        new AddFilesToTagsOperation(this).addFilesToTags(files);
    }

    @Override
    public BagItTxt getBagItTxt() {
        this.checkClosed();
        BagFile bagFile = this.getBagFile(this.getBagConstants().getBagItTxt());
        if (bagFile != null && bagFile instanceof BagItTxt) {
            return (BagItTxt)bagFile;
        }
        return null;
    }

    @Override
    public SimpleResult verifyComplete() {
        return this.verifyComplete(FailModeSupporting.FailMode.FAIL_STAGE);
    }

    @Override
    public SimpleResult verifyComplete(FailModeSupporting.FailMode failMode) {
        this.checkClosed();
        CompleteVerifierImpl verifier = new CompleteVerifierImpl();
        verifier.setFailMode(failMode);
        return verifier.verify(this);
    }

    @Override
    public SimpleResult verifyTagManifests() {
        return this.verifyTagManifests(FailModeSupporting.FailMode.FAIL_STAGE);
    }

    @Override
    public SimpleResult verifyTagManifests(FailModeSupporting.FailMode failMode) {
        this.checkClosed();
        ParallelManifestChecksumVerifier verifier = new ParallelManifestChecksumVerifier();
        verifier.setFailMode(failMode);
        return verifier.verify(this.getTagManifests(), (Bag)this);
    }

    @Override
    public SimpleResult verifyPayloadManifests() {
        return this.verifyPayloadManifests(FailModeSupporting.FailMode.FAIL_STAGE);
    }

    @Override
    public SimpleResult verifyPayloadManifests(FailModeSupporting.FailMode failMode) {
        this.checkClosed();
        ParallelManifestChecksumVerifier verifier = new ParallelManifestChecksumVerifier();
        verifier.setFailMode(failMode);
        return verifier.verify(this.getPayloadManifests(), (Bag)this);
    }

    @Override
    public SimpleResult verifyValid() {
        return this.verifyValid(FailModeSupporting.FailMode.FAIL_STAGE);
    }

    @Override
    public SimpleResult verifyValid(FailModeSupporting.FailMode failMode) {
        this.checkClosed();
        ValidVerifierImpl verifier = new ValidVerifierImpl(new CompleteVerifierImpl(), new ParallelManifestChecksumVerifier());
        verifier.setFailMode(failMode);
        return verifier.verify(this);
    }

    @Override
    public SimpleResult verifyValid(FailModeSupporting.FailMode failMode, List<ProgressListener> progressListeners) {
        this.checkClosed();
        ValidVerifierImpl verifier = new ValidVerifierImpl(new CompleteVerifierImpl(), new ParallelManifestChecksumVerifier());
        verifier.setFailMode(failMode);
        for (ProgressListener progressListener : progressListeners) {
            verifier.addProgressListener(progressListener);
        }
        return verifier.verify(this);
    }

    @Override
    public void accept(BagVisitor visitor) {
        this.checkClosed();
        if (CancelUtil.isCancelled(visitor)) {
            return;
        }
        visitor.startBag(this);
        if (CancelUtil.isCancelled(visitor)) {
            return;
        }
        visitor.startTags();
        if (CancelUtil.isCancelled(visitor)) {
            return;
        }
        for (Map.Entry<String, BagFile> entry : this.tagMap.entrySet()) {
            if (CancelUtil.isCancelled(visitor)) {
                return;
            }
            visitor.visitTag(this.tagMap.get(entry.getKey()));
        }
        if (CancelUtil.isCancelled(visitor)) {
            return;
        }
        visitor.endTags();
        if (CancelUtil.isCancelled(visitor)) {
            return;
        }
        visitor.startPayload();
        if (CancelUtil.isCancelled(visitor)) {
            return;
        }
        for (Map.Entry<String, BagFile> entry : this.payloadMap.entrySet()) {
            if (CancelUtil.isCancelled(visitor)) {
                return;
            }
            visitor.visitPayload(this.payloadMap.get(entry.getKey()));
        }
        if (CancelUtil.isCancelled(visitor)) {
            return;
        }
        visitor.endPayload();
        if (CancelUtil.isCancelled(visitor)) {
            return;
        }
        visitor.endBag();
    }

    @Override
    public FetchTxt getFetchTxt() {
        this.checkClosed();
        BagFile bagFile = this.getBagFile(this.getBagConstants().getFetchTxt());
        if (bagFile != null && bagFile instanceof FetchTxt) {
            return (FetchTxt)bagFile;
        }
        return null;
    }

    @Override
    public FetchTxt getFetchProgressTxt() {
        this.checkClosed();
        BagFile bagFile = this.getBagFile(this.getBagConstants().getFetchProgressTxt());
        if (bagFile != null && bagFile instanceof FetchTxt) {
            return (FetchTxt)bagFile;
        }
        return null;
    }

    @Override
    public Bag.Format getFormat() {
        if (this.fileForBag == null) {
            return null;
        }
        try {
            return FormatHelper.getFormat(this.fileForBag);
        }
        catch (FormatHelper.UnknownFormatException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BagInfoTxt getBagInfoTxt() {
        this.checkClosed();
        BagFile bagFile = this.getBagFile(this.getBagConstants().getBagInfoTxt());
        if (bagFile != null && bagFile instanceof BagInfoTxt) {
            return (BagInfoTxt)bagFile;
        }
        return null;
    }

    @Override
    public SimpleResult verify(Verifier verifier) {
        this.checkClosed();
        return verifier.verify(this);
    }

    @Override
    public Bag.BagConstants getBagConstants() {
        return this.bagConstants;
    }

    @Override
    public Bag.BagPartFactory getBagPartFactory() {
        return this.bagPartFactory;
    }

    @Override
    public BagFactory getBagFactory() {
        return this.bagFactory;
    }

    @Override
    public Bag write(Writer writer, File file) {
        this.checkClosed();
        return writer.write(this, file);
    }

    @Override
    public void removePayloadDirectory(String filepath) {
        this.checkClosed();
        if (!filepath.endsWith("/")) {
            filepath = filepath + "/";
        }
        if (!filepath.startsWith(this.bagConstants.getDataDirectory())) {
            filepath = this.bagConstants.getDataDirectory() + "/" + filepath;
        }
        if ((this.bagConstants.getDataDirectory() + "/").equals(filepath)) {
            return;
        }
        log.debug((Object)("Removing payload directory " + filepath));
        ArrayList<String> deleteFilepaths = new ArrayList<String>();
        for (BagFile bagFile : this.getPayload()) {
            if (!bagFile.getFilepath().startsWith(filepath)) continue;
            deleteFilepaths.add(bagFile.getFilepath());
        }
        for (String deleteFilepath : deleteFilepaths) {
            log.debug((Object)("Removing " + deleteFilepath));
            this.removeBagFile(deleteFilepath);
        }
    }

    @Override
    public void removeTagDirectory(String filepath) {
        this.checkClosed();
        if (!filepath.endsWith("/")) {
            filepath = filepath + "/";
        }
        if (filepath.startsWith(this.bagConstants.getDataDirectory())) {
            throw new RuntimeException("Trying to remove payload");
        }
        log.debug((Object)("Removing tag directory " + filepath));
        ArrayList<String> deleteFilepaths = new ArrayList<String>();
        for (BagFile bagFile : this.getTags()) {
            if (!bagFile.getFilepath().startsWith(filepath)) continue;
            deleteFilepaths.add(bagFile.getFilepath());
        }
        for (String deleteFilepath : deleteFilepaths) {
            log.debug((Object)("Removing " + deleteFilepath));
            this.removeBagFile(deleteFilepath);
        }
    }

    @Override
    public Map<Manifest.Algorithm, String> getChecksums(String filepath) {
        this.checkClosed();
        HashMap<Manifest.Algorithm, String> checksumMap = new HashMap<Manifest.Algorithm, String>();
        if (BagHelper.isPayload(filepath, this.bagConstants)) {
            for (Manifest manifest : this.getPayloadManifests()) {
                if (!manifest.containsKey(filepath)) continue;
                checksumMap.put(manifest.getAlgorithm(), (String)manifest.get(filepath));
            }
        } else {
            for (Manifest manifest : this.getTagManifests()) {
                if (!manifest.containsKey(filepath)) continue;
                checksumMap.put(manifest.getAlgorithm(), (String)manifest.get(filepath));
            }
        }
        return checksumMap;
    }

    @Override
    public Manifest getPayloadManifest(Manifest.Algorithm algorithm) {
        this.checkClosed();
        BagFile bagFile = this.getBagFile(ManifestHelper.getPayloadManifestFilename(algorithm, this.bagConstants));
        if (bagFile != null && bagFile instanceof Manifest) {
            return (Manifest)bagFile;
        }
        return null;
    }

    @Override
    public Manifest getTagManifest(Manifest.Algorithm algorithm) {
        this.checkClosed();
        BagFile bagFile = this.getBagFile(ManifestHelper.getTagManifestFilename(algorithm, this.bagConstants));
        if (bagFile != null && bagFile instanceof Manifest) {
            return (Manifest)bagFile;
        }
        return null;
    }

    @Override
    public Bag makeComplete(Completer completer) {
        this.checkClosed();
        return completer.complete(this);
    }

    @Override
    public Bag makeComplete() {
        DefaultCompleter completer = new DefaultCompleter(this.bagFactory);
        return completer.complete(this);
    }

    @Override
    public Bag makeHoley(HolePuncher holePuncher, String baseUrl, boolean includePayloadDirectoryInUrl, boolean includeTags, boolean resume) {
        this.checkClosed();
        return holePuncher.makeHoley(this, baseUrl, includePayloadDirectoryInUrl, includeTags, resume);
    }

    @Override
    public Bag makeHoley(String baseUrl, boolean includePayloadDirectoryInUrl, boolean includeTags, boolean resume) {
        this.checkClosed();
        HolePuncherImpl holePuncher = new HolePuncherImpl(this.bagFactory);
        return holePuncher.makeHoley(this, baseUrl, includePayloadDirectoryInUrl, includeTags, resume);
    }

    @Override
    public synchronized void close() {
        for (Closeable closeable : this.closeables) {
            IOUtils.closeQuietly((Closeable)closeable);
        }
        this.isClosed = true;
    }

    private void checkClosed() {
        if (this.isClosed) {
            log.warn((Object)"Attempting operation on a closed bag. The results may be problematic.");
        }
    }
}

