/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagHelper;
import gov.loc.repository.bagit.BagItTxt;
import gov.loc.repository.bagit.Cancellable;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.ProgressListenable;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.impl.FileBagFile;
import gov.loc.repository.bagit.transfer.BagTransferCancelledException;
import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchFailStrategy;
import gov.loc.repository.bagit.transfer.FetchFailureAction;
import gov.loc.repository.bagit.transfer.FetchProtocol;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FetchedFileDestinationFactory;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.StandardFailStrategies;
import gov.loc.repository.bagit.transfer.dest.FileSystemFileDestination;
import gov.loc.repository.bagit.transformer.impl.UpdateCompleter;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.utilities.SimpleResultHelper;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import gov.loc.repository.bagit.verify.impl.ValidHoleyBagVerifier;
import gov.loc.repository.bagit.writer.impl.FileSystemWriter;
import java.io.File;
import java.io.InputStream;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BagFetcher
implements Cancellable,
ProgressListenable {
    private static final Log log = LogFactory.getLog(BagFetcher.class);
    private int numberOfThreads;
    private FetchFailStrategy failStrategy = StandardFailStrategies.FAIL_FAST;
    private FetchedFileDestinationFactory destinationFactory;
    private Map<String, FetchProtocol> protocolFactories = Collections.synchronizedMap(new HashMap());
    private BagFactory bagFactory;
    private boolean isCancelled = false;
    private List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();
    private String username;
    private String password;
    private Bag bagToFetch;
    private List<FetchTxt.FilenameSizeUrl> fetchLines = new ArrayList<FetchTxt.FilenameSizeUrl>();
    private AtomicInteger nextFetchTargetIndex;
    private AtomicInteger fetchSuccessCounter = new AtomicInteger(0);
    private List<Fetcher> runningFetchers = Collections.synchronizedList(new ArrayList());

    public BagFetcher(BagFactory bagFactory) {
        this.bagFactory = bagFactory;
        this.numberOfThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void cancel() {
        log.info((Object)"Cancelled.");
        this.isCancelled = true;
        for (Fetcher fetcher : this.runningFetchers) {
            fetcher.cancel();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    @Override
    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    private void progress(String activity, Object item, Long count, Long total) {
        for (ProgressListener listener : this.progressListeners) {
            listener.reportProgress(activity, item, count, total);
        }
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        if (this.numberOfThreads < 1) {
            throw new IllegalArgumentException(MessageFormat.format("Number of threads cannot be less than 1: {0}", numberOfThreads));
        }
        this.numberOfThreads = numberOfThreads;
    }

    public FetchFailStrategy getFetchFailStrategy() {
        return this.failStrategy;
    }

    public void setFetchFailStrategy(FetchFailStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("strategy cannot be null");
        }
        this.failStrategy = strategy;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    protected String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected String getPassword() {
        return this.password;
    }

    public void registerProtocol(String scheme, FetchProtocol protocol) {
        String normalizedScheme = scheme.toLowerCase();
        this.protocolFactories.put(normalizedScheme, protocol);
    }

    public SimpleResult fetch(Bag bag, FetchedFileDestinationFactory destinationFactory) throws BagTransferException {
        return this.fetch(bag, destinationFactory, false, false);
    }

    public SimpleResult fetch(Bag bag, FetchedFileDestinationFactory destinationFactory, boolean resume) throws BagTransferException {
        return this.fetch(bag, destinationFactory, resume, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleResult fetch(Bag bag, FetchedFileDestinationFactory destinationFactory, boolean resume, boolean verify) throws BagTransferException {
        this.bagToFetch = bag;
        this.destinationFactory = destinationFactory;
        this.checkBagSanity();
        this.buildFetchTargets(resume, verify);
        this.nextFetchTargetIndex = new AtomicInteger(0);
        SimpleResult finalResult = new SimpleResult(true);
        if (this.numberOfThreads > 1) {
            ExecutorService threadPool = Executors.newCachedThreadPool();
            BagFetcherShutdownHook shutdownHook = new BagFetcherShutdownHook();
            shutdownHook.hook();
            try {
                log.debug((Object)MessageFormat.format("Submitting {0} jobs.", this.numberOfThreads));
                ArrayList<Future<SimpleResult>> futureResults = new ArrayList<Future<SimpleResult>>();
                for (int i = 0; i < this.numberOfThreads; ++i) {
                    log.trace((Object)MessageFormat.format("Submitting job {0} of {1}.", i + 1, this.numberOfThreads));
                    Fetcher fetcher = new Fetcher();
                    this.runningFetchers.add(fetcher);
                    futureResults.add(threadPool.submit(fetcher));
                }
                log.debug((Object)"Jobs submitted.  Waiting on results.");
                for (Future future : futureResults) {
                    String msg;
                    try {
                        SimpleResult result = (SimpleResult)future.get();
                        finalResult.merge(result);
                    }
                    catch (ExecutionException e) {
                        msg = MessageFormat.format("An unexpected exception occurred while processing the transfers: {0}", e.getCause().getMessage());
                        finalResult.addMessage(msg);
                        finalResult.setSuccess(false);
                        log.error((Object)msg, (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        msg = MessageFormat.format("Interrupted while waiting for the child threads to complete: {0}", e.getMessage());
                        finalResult.addMessage(msg);
                        finalResult.setSuccess(false);
                        log.error((Object)msg, (Throwable)e);
                    }
                }
            }
            finally {
                log.trace((Object)"Shutting down thread pool.");
                threadPool.shutdown();
                log.trace((Object)"Shutting down thread pool.");
                log.trace((Object)"Releasing shutdown hook.");
                shutdownHook.unhook();
            }
        }
        log.debug((Object)"Fetching in single-threaded mode.");
        try {
            Fetcher fetcher = new Fetcher();
            SimpleResult result = fetcher.call();
            finalResult.merge(result);
        }
        catch (Exception e) {
            throw new BagTransferException("Caught unexpected exception from fetcher.", e);
        }
        log.debug((Object)MessageFormat.format("Fetch completed with result: {0}", finalResult.isSuccess()));
        this.progress("Fetch completed", "", null, null);
        if (finalResult.isSuccess()) {
            this.deleteFetchProgressTxtOnDisk();
            this.progress("Verifing the fetched bag", "", null, null);
            this.bagToFetch.loadFromManifests();
            SimpleResult bagVerifyResult = this.bagToFetch.verifyValid(FailModeSupporting.FailMode.FAIL_SLOW, this.progressListeners);
            log.debug((Object)MessageFormat.format("Verify valid completed with result: {0}", bagVerifyResult.isSuccess()));
            this.progress("Verify valid completed", "", null, null);
            return bagVerifyResult;
        }
        this.updateFetchProgressTxtOnDisk();
        return finalResult;
    }

    private void updateFetchProgressTxtOnDisk() {
        this.bagToFetch.loadFromManifests();
        FetchTxt fetchProgressTxt = this.bagToFetch.getFetchProgressTxt();
        if (fetchProgressTxt == null) {
            fetchProgressTxt = this.bagFactory.getBagPartFactory().createFetchProgressTxt();
            fetchProgressTxt.addAll(this.fetchLines);
            this.bagToFetch.putBagFile(fetchProgressTxt);
        } else if (fetchProgressTxt.size() <= 0) {
            fetchProgressTxt.addAll(this.fetchLines);
        } else {
            for (FetchTxt.FilenameSizeUrl fetchLine : this.fetchLines) {
                int index = fetchProgressTxt.indexOf(fetchLine);
                if (index < 0) continue;
                ((FetchTxt.FilenameSizeUrl)fetchProgressTxt.get(index)).setFetchStatus(fetchLine.getFetchStatus());
            }
        }
        BagFactory bagFactory = new BagFactory();
        UpdateCompleter completer = new UpdateCompleter(bagFactory);
        this.addProgressListeners(completer);
        completer.setLimitAddPayloadDirectories(new ArrayList<String>());
        completer.setLimitAddPayloadFilepaths(new ArrayList<String>());
        completer.setLimitDeletePayloadDirectories(new ArrayList<String>());
        completer.setLimitDeletePayloadFilepaths(new ArrayList<String>());
        completer.setLimitUpdatePayloadDirectories(new ArrayList<String>());
        completer.setLimitUpdatePayloadFilepaths(new ArrayList<String>());
        completer.setLimitAddTagDirectories(new ArrayList<String>());
        completer.setLimitAddTagFilepaths(new ArrayList<String>());
        completer.setLimitDeleteTagDirectories(new ArrayList<String>());
        completer.setLimitDeleteTagFilepaths(new ArrayList<String>());
        completer.setLimitUpdateTagDirectories(new ArrayList<String>());
        ArrayList<String> toUpdatedTagFilepaths = new ArrayList<String>();
        toUpdatedTagFilepaths.add(this.bagToFetch.getBagConstants().getFetchProgressTxt());
        completer.setLimitUpdateTagFilepaths(toUpdatedTagFilepaths);
        completer.complete(this.bagToFetch);
        FileSystemWriter writer = new FileSystemWriter(bagFactory);
        this.addProgressListeners(writer);
        writer.setTagFilesOnly(true);
        this.bagToFetch.write(writer, this.bagToFetch.getFile());
    }

    private void deleteFetchProgressTxtOnDisk() {
        log.info((Object)"Delete fetch-progress.txt.");
        this.bagToFetch.loadFromManifests();
        if (this.bagToFetch.getFetchProgressTxt() != null) {
            this.bagToFetch.removeBagFile(this.bagToFetch.getFetchProgressTxt().getFilepath());
        }
        BagFactory bagFactory = new BagFactory();
        UpdateCompleter completer = new UpdateCompleter(bagFactory);
        this.addProgressListeners(completer);
        completer.setLimitAddPayloadDirectories(new ArrayList<String>());
        completer.setLimitAddPayloadFilepaths(new ArrayList<String>());
        completer.setLimitDeletePayloadDirectories(new ArrayList<String>());
        completer.setLimitDeletePayloadFilepaths(new ArrayList<String>());
        completer.setLimitUpdatePayloadDirectories(new ArrayList<String>());
        completer.setLimitUpdatePayloadFilepaths(new ArrayList<String>());
        completer.setLimitAddTagDirectories(new ArrayList<String>());
        completer.setLimitAddTagFilepaths(new ArrayList<String>());
        completer.setLimitDeleteTagDirectories(new ArrayList<String>());
        completer.setLimitUpdateTagDirectories(new ArrayList<String>());
        ArrayList<String> toDeletededTagFilepaths = new ArrayList<String>();
        toDeletededTagFilepaths.add(this.bagToFetch.getBagConstants().getFetchProgressTxt());
        completer.setLimitDeleteTagFilepaths(toDeletededTagFilepaths);
        completer.complete(this.bagToFetch);
        FileSystemWriter writer = new FileSystemWriter(bagFactory);
        this.addProgressListeners(writer);
        writer.setTagFilesOnly(true);
        writer.setFilesThatDoNotMatchManifestOnly(true);
        this.bagToFetch.write(writer, this.bagToFetch.getFile());
    }

    private void addProgressListeners(ProgressListenable progressListenable) {
        for (ProgressListener progressListener : this.progressListeners) {
            progressListenable.addProgressListener(progressListener);
        }
    }

    private void checkBagSanity() throws BagTransferException {
        log.debug((Object)"Checking sanity of bag prior to fetch.");
        this.progress("Checking sanity of bag prior to fetch", "", null, null);
        ValidHoleyBagVerifier verifier = new ValidHoleyBagVerifier();
        this.addProgressListeners(verifier);
        SimpleResult verifyResult = this.bagToFetch.verify(verifier);
        if (!verifyResult.isSuccess()) {
            throw new BagTransferException(MessageFormat.format("Bag is not valid: {0}", verifyResult.toString()));
        }
    }

    private void recreateFetchProgressTxt() {
        log.info((Object)"Recreate fetch-progress.txt.");
        if (this.bagToFetch.getFetchProgressTxt() != null) {
            this.bagToFetch.getFetchProgressTxt().clear();
        }
        ArrayList<FetchTxt.FilenameSizeUrl> allFetchLines = new ArrayList<FetchTxt.FilenameSizeUrl>(this.bagToFetch.getFetchTxt());
        this.progress("Verifying the holey bag before fetching", "", null, null);
        SimpleResult bagVerifyResult = this.bagToFetch.verifyValid(FailModeSupporting.FailMode.FAIL_SLOW, this.progressListeners);
        for (FetchTxt.FilenameSizeUrl fetchLine : allFetchLines) {
            if (!BagHelper.isPayload(fetchLine.getFilename(), this.bagFactory.getBagConstants())) continue;
            if (SimpleResultHelper.isMissingPayloadFile(bagVerifyResult, fetchLine.getFilename())) {
                fetchLine.setFetchStatus(FetchTxt.FetchStatus.NOT_FETCHED);
            } else if (SimpleResultHelper.isInvalidPayloadFile(bagVerifyResult, fetchLine.getFilename())) {
                fetchLine.setFetchStatus(FetchTxt.FetchStatus.VERIFY_FAILED);
            } else {
                fetchLine.setFetchStatus(FetchTxt.FetchStatus.SUCCEEDED);
            }
            this.fetchLines.add(fetchLine);
        }
        this.updateFetchProgressTxtOnDisk();
    }

    public void buildFetchTargets(boolean resume, boolean verify) {
        this.progress("Building fetch targets", "", null, null);
        log.trace((Object)"Getting fetch lines.");
        if (verify) {
            this.recreateFetchProgressTxt();
        }
        if (resume) {
            if (this.bagToFetch.getFetchProgressTxt() == null) {
                this.recreateFetchProgressTxt();
            }
            ArrayList<FetchTxt.FilenameSizeUrl> allFetchLines = new ArrayList<FetchTxt.FilenameSizeUrl>(this.bagToFetch.getFetchProgressTxt());
            this.fetchLines.clear();
            for (FetchTxt.FilenameSizeUrl fetchLine : allFetchLines) {
                if (fetchLine.getFetchStatus() != null && fetchLine.getFetchStatus().equals((Object)FetchTxt.FetchStatus.SUCCEEDED)) continue;
                this.fetchLines.add(fetchLine);
            }
        } else {
            ArrayList<FetchTxt.FilenameSizeUrl> allFetchLines = new ArrayList<FetchTxt.FilenameSizeUrl>(this.bagToFetch.getFetchTxt());
            this.fetchLines.clear();
            this.fetchLines.addAll(allFetchLines);
        }
    }

    private FetchTxt.FilenameSizeUrl getNextFetchLine() {
        FetchTxt.FilenameSizeUrl nextItem;
        int size;
        int next = this.nextFetchTargetIndex.getAndIncrement();
        if (next < (size = this.fetchLines.size())) {
            nextItem = this.fetchLines.get(next);
            this.progress("starting fetch", nextItem.getFilename(), (long)next + 1L, Long.valueOf(size));
            log.trace((Object)MessageFormat.format("Fetching {0}/{1}: {2}", next + 1, size, nextItem.getFilename()));
        } else {
            nextItem = null;
            log.trace((Object)"Nothing left to fetch.  Returning null.");
        }
        return nextItem;
    }

    private FileFetcher newFileFetcher(URI uri, Long size) throws BagTransferException {
        String scheme = uri.getScheme();
        log.trace((Object)MessageFormat.format("Getting fetcher for scheme: {0}", scheme));
        FetchProtocol factory = this.protocolFactories.get(scheme);
        if (factory == null) {
            throw new BagTransferException(MessageFormat.format("No registered factory for URI: {0}", uri));
        }
        return factory.createFetcher(uri, size);
    }

    private URI parseUri(String uriString) throws BagTransferException {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            String msg = MessageFormat.format("Invalid target URL: {0}", uriString);
            log.error((Object)msg, (Throwable)e);
            throw new BagTransferException(msg, e);
        }
    }

    public SimpleResult fetchRemoteBag(File destFile, String url, boolean resume, boolean verify) throws BagTransferException {
        Bag partialBag;
        SimpleResult bagItResult;
        this.destinationFactory = new FileSystemFileDestination(destFile);
        log.info((Object)"Making local holey bag from remote bag");
        String baseUrl = url;
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        if (!(bagItResult = this.fetchFile(baseUrl, this.bagFactory.getBagConstants().getBagItTxt())).isSuccess()) {
            log.info((Object)"Failed: BagIt.txt file does not exist on remote bag");
            return bagItResult;
        }
        String bagItTxtFilepath = this.destinationFactory.createDestination(this.bagFactory.getBagConstants().getBagItTxt(), null).getDirectAccessPath();
        BagItTxt bagItTxt = this.bagFactory.getBagPartFactory().createBagItTxt(new FileBagFile(this.bagFactory.getBagConstants().getBagItTxt(), new File(bagItTxtFilepath)));
        Bag.BagConstants bagConstants = this.bagFactory.getBagConstants(BagFactory.Version.valueOfString(bagItTxt.getVersion()));
        this.fetchManifestFiles(baseUrl, bagConstants);
        if (!resume) {
            this.fetchFile(baseUrl, bagConstants.getFetchTxt());
        }
        if ((partialBag = this.bagFactory.createBag(destFile, BagFactory.LoadOption.BY_MANIFESTS)).getFetchTxt() == null && partialBag.getPayloadManifests().isEmpty()) {
            return new SimpleResult(false, "Neither fetch.txt or payload manifest found");
        }
        for (Manifest manifest : partialBag.getTagManifests()) {
            this.fetchFromManifest(manifest, baseUrl);
        }
        this.fetchFile(baseUrl, bagConstants.getBagInfoTxt());
        if (partialBag.getFetchTxt() == null) {
            Bag holeyBag = partialBag.makeHoley(baseUrl, true, false, false);
            holeyBag.write(new FileSystemWriter(this.bagFactory), destFile);
        }
        FileSystemFileDestination dest = new FileSystemFileDestination(destFile);
        SimpleResult fetchResult = this.fetch(partialBag, dest, resume, verify);
        return fetchResult;
    }

    protected SimpleResult fetchFromManifest(Manifest manifest, String baseUrl) throws BagTransferException {
        SimpleResult result = new SimpleResult(true);
        for (String filepath : manifest.keySet()) {
            result = this.fetchFile(baseUrl, filepath);
            if (result.isSuccess()) continue;
            this.fail("File {0} in manifest {1} missing from bag.", filepath, manifest.getFilepath());
            return result;
        }
        return result;
    }

    private void fail(String format, Object ... args) {
        this.fail(MessageFormat.format(format, args));
    }

    private void fail(String message) {
        log.trace((Object)message);
    }

    private SimpleResult fetchFile(String url, String filename) {
        SimpleResult result = new SimpleResult(true);
        Fetcher fetcher = new Fetcher();
        url = url + filename;
        FetchTxt.FilenameSizeUrl filenNameSizeUrl = new FetchTxt.FilenameSizeUrl(filename, null, url);
        try {
            fetcher.fetchFile(filenNameSizeUrl);
        }
        catch (BagTransferCancelledException bte) {
            log.trace((Object)MessageFormat.format("File {0} does not exist in the remote bag", filename));
            result.setSuccess(false);
        }
        catch (BagTransferException bte) {
            log.trace((Object)MessageFormat.format("File {0} does not exist in the remote bag", filename));
            result.setSuccess(false);
        }
        return result;
    }

    private void fetchManifestFiles(String url, Bag.BagConstants bagConstants) throws BagTransferException {
        FetchTxt.FilenameSizeUrl filenNameSizeUrl;
        String filename;
        Fetcher fetcher = new Fetcher();
        for (Manifest.Algorithm algorithm : Manifest.Algorithm.values()) {
            filename = ManifestHelper.getTagManifestFilename(algorithm, bagConstants);
            filenNameSizeUrl = new FetchTxt.FilenameSizeUrl(filename, null, url + filename);
            try {
                fetcher.fetchFile(filenNameSizeUrl);
            }
            catch (BagTransferCancelledException bte) {
                log.trace((Object)MessageFormat.format("Manifest file {0} does not exist in the remote bag", filename));
            }
            catch (BagTransferException bte) {
                log.trace((Object)MessageFormat.format("Manifest file {0} does not exist in the remote bag", filename));
            }
        }
        for (Manifest.Algorithm algorithm : Manifest.Algorithm.values()) {
            filename = ManifestHelper.getPayloadManifestFilename(algorithm, bagConstants);
            filenNameSizeUrl = new FetchTxt.FilenameSizeUrl(filename, null, url + filename);
            try {
                fetcher.fetchFile(filenNameSizeUrl);
            }
            catch (BagTransferCancelledException bte) {
                log.trace((Object)MessageFormat.format("Manifest file {0} does not exist in the remote bag", filename));
            }
            catch (BagTransferException bte) {
                log.trace((Object)MessageFormat.format("Manifest file {0} does not exist in the remote bag", filename));
            }
        }
    }

    private class BagFetcherShutdownHook
    extends Thread {
        private CountDownLatch shutdownLatch;

        private BagFetcherShutdownHook() {
        }

        public synchronized void hook() {
            this.shutdownLatch = new CountDownLatch(1);
            Runtime.getRuntime().addShutdownHook(this);
        }

        public synchronized void unhook() {
            this.shutdownLatch.countDown();
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException e) {
                log.warn((Object)"Failed to remove shutdown hook. Most likely cause we are already shutting down", (Throwable)e);
            }
        }

        @Override
        public synchronized void run() {
            BagFetcher.this.cancel();
        }
    }

    private static class MyContext
    implements FetchContext {
        private MyContext() {
        }

        @Override
        public boolean requiresLogin() {
            return false;
        }

        @Override
        public PasswordAuthentication getCredentials() {
            return null;
        }
    }

    private class Fetcher
    implements Callable<SimpleResult> {
        private SimpleResult result = new SimpleResult(true);
        private Map<String, FileFetcher> fetchers = new HashMap<String, FileFetcher>();

        private Fetcher() {
        }

        public synchronized void cancel() {
            for (FileFetcher fetcher : this.fetchers.values()) {
                if (fetcher.isCancelled()) continue;
                fetcher.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SimpleResult call() {
            log.trace((Object)"Internal fetcher started.");
            try {
                FetchTxt.FilenameSizeUrl fetchLine = BagFetcher.this.getNextFetchLine();
                while (fetchLine != null && !BagFetcher.this.isCancelled()) {
                    try {
                        this.fetchFile(fetchLine);
                        int index = BagFetcher.this.fetchSuccessCounter.incrementAndGet();
                        BagFetcher.this.progress("Fetched", fetchLine.getFilename(), Long.valueOf(index), Long.valueOf(BagFetcher.this.fetchLines.size()));
                        fetchLine = BagFetcher.this.getNextFetchLine();
                    }
                    catch (BagTransferCancelledException e) {
                        BagFetcher.this.progress("Fetch cancelled", "", null, null);
                        log.info((Object)"Transfer cancelled.");
                        this.result.addMessage("Transfer cancelled.");
                        this.result.setSuccess(false);
                        break;
                    }
                    catch (BagTransferException e) {
                        FetchFailureAction failureAction = BagFetcher.this.failStrategy.registerFailure(fetchLine, e);
                        log.trace((Object)MessageFormat.format("Failure action for {0} (size: {1}): {2} ", new Object[]{fetchLine.getFilename(), fetchLine.getSize(), failureAction}));
                        if (failureAction == FetchFailureAction.RETRY_CURRENT) {
                            log.trace((Object)"Retrying current");
                            continue;
                        }
                        if (failureAction == FetchFailureAction.CONTINUE_WITH_NEXT) {
                            String errorMsg = null;
                            if (fetchLine.getFetchStatus().equals((Object)FetchTxt.FetchStatus.FETCH_FAILED)) {
                                errorMsg = MessageFormat.format("An error occurred while fetching target: {0}", fetchLine.getFilename());
                                log.trace((Object)errorMsg);
                                this.result.addMessage(FetchTxt.FetchStatus.FETCH_FAILED.toString(), "{0}: {1}", "fetch failed", fetchLine.getFilename());
                            } else if (fetchLine.getFetchStatus().equals((Object)FetchTxt.FetchStatus.VERIFY_FAILED)) {
                                errorMsg = MessageFormat.format("The checksum of the fetched target {0} does not match that in the manifest.", fetchLine.getFilename());
                                log.trace((Object)errorMsg);
                                this.result.addMessage(FetchTxt.FetchStatus.VERIFY_FAILED.toString(), "{0}: {1}", "verify failed", fetchLine.getFilename());
                            }
                            this.result.setSuccess(false);
                            fetchLine = BagFetcher.this.getNextFetchLine();
                            continue;
                        }
                        BagFetcher.this.cancel();
                        this.result.addMessage(MessageFormat.format("An error occurred while fetching target: {0}", fetchLine.getFilename()));
                        this.result.setSuccess(false);
                        break;
                    }
                }
            }
            finally {
                this.closeFetchers();
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchFile(FetchTxt.FilenameSizeUrl filenameSizeUrl) throws BagTransferException {
            FetchedFileDestination destination = null;
            BagFile committedFile = null;
            try {
                URI uri = BagFetcher.this.parseUri(filenameSizeUrl.getUrl());
                Long size = filenameSizeUrl.getSize();
                String destinationPath = filenameSizeUrl.getFilename();
                if (!destinationPath.startsWith("data")) {
                    throw new BagTransferException("Destination of fetch file is [" + (String)destinationPath + "] which is not a payload file.");
                }
                log.trace((Object)MessageFormat.format("Creating destination: {0}", destinationPath));
                destination = BagFetcher.this.destinationFactory.createDestination(destinationPath, size);
                FileFetcher fetcher = this.getFetcher(uri, size);
                BagFetcher.this.progress("Fetching", filenameSizeUrl.getFilename(), null, null);
                log.trace((Object)MessageFormat.format("Fetching: {0} {1} {2}", uri, size == null ? "-" : size, destinationPath));
                fetcher.fetchFile(uri, size, destination, new MyContext());
                log.trace((Object)"Committing destination.");
                committedFile = destination.commit();
                BagFetcher.this.progress("Fetched", filenameSizeUrl.getFilename(), null, null);
                log.trace((Object)MessageFormat.format("Fetched: {0} -> {1}", uri, destinationPath));
            }
            catch (BagTransferCancelledException e) {
                throw new BagTransferCancelledException(e);
            }
            catch (BagTransferException e) {
                String msg = MessageFormat.format("An error occurred while fetching target: {0}", filenameSizeUrl);
                log.warn((Object)msg, (Throwable)e);
                filenameSizeUrl.setFetchStatus(FetchTxt.FetchStatus.FETCH_FAILED);
                if (destination != null) {
                    destination.abandon();
                    destination = null;
                }
                throw new BagTransferException(e);
            }
            if (BagFetcher.this.bagToFetch != null && committedFile != null && committedFile.exists()) {
                BagFetcher.this.progress("Verifying", filenameSizeUrl.getFilename(), null, null);
                InputStream stream = null;
                try {
                    stream = committedFile.newInputStream();
                    boolean fixityMatches = false;
                    for (Manifest manifest : BagFetcher.this.bagToFetch.getPayloadManifests()) {
                        if (!MessageDigestHelper.fixityMatches(stream, manifest.getAlgorithm(), (String)manifest.get(filenameSizeUrl.getFilename()))) continue;
                        filenameSizeUrl.setFetchStatus(FetchTxt.FetchStatus.SUCCEEDED);
                        fixityMatches = true;
                        break;
                    }
                    if (!fixityMatches) {
                        filenameSizeUrl.setFetchStatus(FetchTxt.FetchStatus.VERIFY_FAILED);
                        String msg = MessageFormat.format("The checksum of the fetched target {0} does not match that in the manifest.", filenameSizeUrl);
                        log.warn((Object)msg);
                        throw new BagTransferException(msg);
                    }
                    BagFetcher.this.progress("Verification completed", filenameSizeUrl.getFilename(), null, null);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
        }

        private synchronized FileFetcher getFetcher(URI uri, Long size) throws BagTransferException {
            FileFetcher fetcher = this.fetchers.get(uri.getScheme());
            if (fetcher == null) {
                log.trace((Object)MessageFormat.format("Creating new FileFetcher for scheme: {0}", uri.getScheme()));
                fetcher = BagFetcher.this.newFileFetcher(uri, size);
                log.trace((Object)"Initializing new FileFetcher.");
                fetcher.initialize();
                this.fetchers.put(uri.getScheme(), fetcher);
            }
            if (BagFetcher.this.username != null && BagFetcher.this.password != null) {
                fetcher.setUsername(BagFetcher.this.username);
                fetcher.setPassword(BagFetcher.this.password);
            }
            return fetcher;
        }

        private synchronized void closeFetchers() {
            for (FileFetcher fetcher : this.fetchers.values()) {
                fetcher.close();
            }
            this.fetchers.clear();
        }
    }
}

