/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.transformer.Splitter;
import gov.loc.repository.bagit.transformer.impl.SplitBagHelper;
import java.util.ArrayList;
import java.util.List;

public class SplitByFileType
implements Splitter {
    private BagFactory bagFactory;
    private String[][] fileExtensions;
    private String[] exludeDirs;

    public String[][] getFileExtensions() {
        return (String[][])this.fileExtensions.clone();
    }

    public void setFileExtensions(String[][] fileExtensions) {
        this.fileExtensions = (String[][])fileExtensions.clone();
    }

    public SplitByFileType(BagFactory bagFactory, String[][] fileExtensions, String[] excludeDirs) {
        this.bagFactory = bagFactory;
        this.setFileExtensions(fileExtensions);
        this.setExludeDirs(excludeDirs);
    }

    @Override
    public List<Bag> split(Bag srcBag) {
        ArrayList<Bag> subBags = new ArrayList<Bag>();
        for (String[] subFileExtension : this.fileExtensions) {
            ArrayList<BagFile> targetedBagFiles = new ArrayList<BagFile>();
            block1: for (BagFile bagFile : srcBag.getPayload()) {
                String fileExtension = bagFile.getFilepath().substring(bagFile.getFilepath().lastIndexOf(46) + 1);
                for (String fileEx : subFileExtension) {
                    if (!fileEx.trim().equalsIgnoreCase(fileExtension) || SplitBagHelper.isExcluded(this.getExludeDirs(), bagFile.getFilepath())) continue;
                    targetedBagFiles.add(bagFile);
                    continue block1;
                }
            }
            if (targetedBagFiles.size() <= 0) continue;
            Bag subBag = this.bagFactory.createBag(srcBag.getVersion());
            BagInfoTxt bagInfoTxt = subBag.getBagPartFactory().createBagInfoTxt();
            subBag.putBagFile(bagInfoTxt);
            subBag.getBagInfoTxt().putAll(srcBag.getBagInfoTxt());
            subBag.getBagInfoTxt().put("File-Type", this.concatStrings(subFileExtension));
            subBag.putBagFiles(targetedBagFiles);
            subBags.add(subBag);
        }
        return subBags;
    }

    private String concatStrings(String[] strs) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (String str : strs) {
            if (i > 0) {
                sb.append(" ").append(str);
            } else {
                sb.append(str);
            }
            ++i;
        }
        return sb.toString();
    }

    public String[] getExludeDirs() {
        return (String[])this.exludeDirs.clone();
    }

    public void setExludeDirs(String[] exludeDirs) {
        this.exludeDirs = (String[])exludeDirs.clone();
    }
}

