/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities;

import java.text.DecimalFormat;

public class SizeHelper {
    public static final double KB = Math.pow(2.0, 10.0);
    public static final double MB = Math.pow(2.0, 20.0);
    public static final double GB = Math.pow(2.0, 30.0);
    public static final double TB = Math.pow(2.0, 40.0);

    public static String getSize(long octets) {
        double div;
        String unit;
        if ((double)octets < MB) {
            unit = "KB";
            div = KB;
        } else if ((double)octets < GB) {
            unit = "MB";
            div = MB;
        } else if ((double)octets < TB) {
            unit = "GB";
            div = GB;
        } else {
            unit = "TB";
            div = TB;
        }
        StringBuilder format = new StringBuilder("#.#");
        double size = (double)octets / div;
        String sizeString = new DecimalFormat(format.toString()).format(size);
        if (size % 1.0 != 0.0) {
            while (sizeString.endsWith("0")) {
                format.append('#');
                sizeString = new DecimalFormat(format.toString()).format(size);
            }
        }
        return sizeString + " " + unit;
    }
}

