/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.filesystem.FileNode;
import gov.loc.repository.bagit.filesystem.FileSystemFactory;
import gov.loc.repository.bagit.filesystem.FileSystemNode;
import gov.loc.repository.bagit.filesystem.FileSystemNodeFilter;
import gov.loc.repository.bagit.filesystem.filter.AndFileSystemNodeFilter;
import gov.loc.repository.bagit.filesystem.filter.DirNodeFileSystemNodeFilter;
import gov.loc.repository.bagit.filesystem.filter.FileNodeFileSystemNodeFilter;
import gov.loc.repository.bagit.filesystem.filter.IgnoringFileSystemNodeFilter;
import gov.loc.repository.bagit.utilities.FilenameHelper;
import gov.loc.repository.bagit.utilities.FormatHelper;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.utilities.SimpleResultHelper;
import gov.loc.repository.bagit.verify.CompleteVerifier;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompleteVerifierImpl
extends LongRunningOperationBase
implements CompleteVerifier,
FailModeSupporting {
    private Normalizer.Form[] formArray = new Normalizer.Form[]{Normalizer.Form.NFC, Normalizer.Form.NFD};
    private static final Log log = LogFactory.getLog(CompleteVerifierImpl.class);
    private boolean missingBagItTolerant = false;
    private boolean additionalDirectoriesInBagDirTolerant = false;
    private List<String> ignoreAdditionalDirectories = new ArrayList<String>();
    private boolean ignoreSymlinks = false;
    private FailModeSupporting.FailMode failMode = FailModeSupporting.FailMode.FAIL_STAGE;

    public void setIgnoreSymlinks(boolean ignore) {
        this.ignoreSymlinks = ignore;
    }

    public void setMissingBagItTolerant(boolean missingBagItTolerant) {
        this.missingBagItTolerant = missingBagItTolerant;
    }

    public void setAdditionalDirectoriesInBagDirTolerant(boolean additionalDirectoriesInBagDirTolerant) {
        this.additionalDirectoriesInBagDirTolerant = additionalDirectoriesInBagDirTolerant;
    }

    public void setIgnoreAdditionalDirectories(List<String> dirs) {
        this.ignoreAdditionalDirectories = dirs;
    }

    @Override
    public void setFailMode(FailModeSupporting.FailMode failMode) {
        this.failMode = failMode;
    }

    @Override
    public FailModeSupporting.FailMode getFailMode() {
        return this.failMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public SimpleResult verify(Bag bag) {
        allowTagDirectories = true;
        if (!(this.additionalDirectoriesInBagDirTolerant || BagFactory.Version.V0_93 != bag.getVersion() && BagFactory.Version.V0_94 != bag.getVersion() && BagFactory.Version.V0_95 != bag.getVersion() && BagFactory.Version.V0_96 != bag.getVersion())) {
            allowTagDirectories = false;
        }
        result = new SimpleResult(true);
        CompleteVerifierImpl.log.debug((Object)"Checking that at least one payload manifest");
        if (bag.getPayloadManifests().isEmpty()) {
            result.setSuccess(false);
            result.addMessage("no_payload_manifest", "Bag does not have any payload manifests.");
            if (FailModeSupporting.FailMode.FAIL_FAST == this.failMode) {
                return result;
            }
        }
        CompleteVerifierImpl.log.debug((Object)"Checking that has BagIt.txt");
        if (!this.missingBagItTolerant && bag.getBagItTxt() == null) {
            result.setSuccess(false);
            result.addMessage("no_bagittxt", MessageFormat.format("Bag does not have {0}.", new Object[]{bag.getBagConstants().getBagItTxt()}));
            if (FailModeSupporting.FailMode.FAIL_FAST == this.failMode) {
                return result;
            }
        }
        CompleteVerifierImpl.log.debug((Object)"Checking that BagIt.txt is right version");
        if (!this.missingBagItTolerant && bag.getBagItTxt() != null && !bag.getBagConstants().getVersion().versionString.equals(bag.getBagItTxt().getVersion())) {
            result.setSuccess(false);
            result.addMessage("wrong_version", MessageFormat.format("Version is not {0}.", new Object[]{bag.getBagConstants().getVersion()}));
            if (FailModeSupporting.FailMode.FAIL_FAST == this.failMode) {
                return result;
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        if (FailModeSupporting.FailMode.FAIL_STEP == this.failMode && !result.isSuccess()) {
            return result;
        }
        CompleteVerifierImpl.log.debug((Object)"Checking that all payload files in data directory");
        total = bag.getPayload().size();
        count = 0;
        for (Iterator<BagFile> bagFile : bag.getPayload()) {
            if (this.isCancelled()) {
                return null;
            }
            filepath = bagFile.getFilepath();
            this.progress("verifying payload file in data directory", (Object)filepath, ++count, total);
            CompleteVerifierImpl.log.trace((Object)MessageFormat.format("Verifying payload {0} in data directory", new Object[]{filepath}));
            if (filepath.startsWith(bag.getBagConstants().getDataDirectory() + '/')) continue;
            result.setSuccess(false);
            result.addMessage("payload_not_in_payload_directory", MessageFormat.format("Payload file {0} not in the {1} directory.", new Object[]{filepath, bag.getBagConstants().getDataDirectory()}), filepath);
            CompleteVerifierImpl.log.warn((Object)MessageFormat.format("Payload file {0} not in data directory", new Object[]{filepath}));
            if (FailModeSupporting.FailMode.FAIL_FAST != this.failMode) continue;
            return result;
        }
        if (FailModeSupporting.FailMode.FAIL_STEP == this.failMode && !result.isSuccess()) {
            return result;
        }
        CompleteVerifierImpl.log.debug((Object)"Checking that no tag files are listed in payload manifests.");
        payloadDirName = bag.getBagConstants().getDataDirectory();
        for (Manifest manifest : bag.getPayloadManifests()) {
            if (this.isCancelled()) {
                return null;
            }
            this.progress("checking payload manifest for tag files", manifest.getFilepath());
            for (String path : manifest.keySet()) {
                normalizedPath = FilenameHelper.normalizePath(path);
                CompleteVerifierImpl.log.trace((Object)MessageFormat.format("Normalized path: {0} -> {1}", new Object[]{path, normalizedPath}));
                if (normalizedPath.startsWith(payloadDirName)) continue;
                result.setSuccess(false);
                result.addMessage("tag_in_payload_manifest", "Tag file is listed in payload manifest {0}: {1}", manifest.getFilepath(), path);
                if (FailModeSupporting.FailMode.FAIL_FAST != this.failMode) continue;
                return result;
            }
        }
        if (FailModeSupporting.FailMode.FAIL_STEP == this.failMode && !result.isSuccess()) {
            return result;
        }
        CompleteVerifierImpl.log.debug((Object)"Checking that every payload file in at least one manifest");
        total = bag.getPayload().size();
        CompleteVerifierImpl.log.trace((Object)MessageFormat.format("{0} payload files to check", new Object[]{total}));
        count = 0;
        for (BagFile bagFile : bag.getPayload()) {
            filepath = bagFile.getFilepath();
            this.progress("verifying payload file in at least one manifest", filepath, ++count, total);
            CompleteVerifierImpl.log.trace((Object)MessageFormat.format("Verifying payload file {0} in at least one manifest", new Object[]{filepath}));
            inManifest = false;
            for (Manifest manifest : bag.getPayloadManifests()) {
                if (this.isCancelled()) {
                    return null;
                }
                if (!manifest.containsKey(filepath)) continue;
                inManifest = true;
                break;
            }
            if (inManifest) continue;
            result.setSuccess(false);
            result.addMessage("payload_file_not_in_payload_manifest", "Payload file {0} not found in any payload manifest.", (String)filepath);
            CompleteVerifierImpl.log.warn((Object)MessageFormat.format("Payload file {0} not found in any payload manifest.", new Object[]{filepath}));
            if (FailModeSupporting.FailMode.FAIL_FAST != this.failMode) continue;
            return result;
        }
        if (FailModeSupporting.FailMode.FAIL_STEP == this.failMode && !result.isSuccess()) {
            return result;
        }
        CompleteVerifierImpl.log.debug((Object)"Checking that every payload file exists");
        total = bag.getPayloadManifests().size();
        CompleteVerifierImpl.log.trace((Object)MessageFormat.format("{0} payload manifests to check", new Object[]{total}));
        count = 0;
        for (Manifest manifest : bag.getPayloadManifests()) {
            this.progress("verifying payload files in manifest exist", (Object)manifest.getFilepath(), ++count, total);
            this.checkManifest(manifest, bag, result);
            if (this.isCancelled()) {
                return null;
            }
            if (FailModeSupporting.FailMode.FAIL_FAST != this.failMode || result.isSuccess()) continue;
            return result;
        }
        if (FailModeSupporting.FailMode.FAIL_STEP == this.failMode && !result.isSuccess()) {
            return result;
        }
        CompleteVerifierImpl.log.debug((Object)"Checking that every tag file exists");
        total = bag.getTagManifests().size();
        CompleteVerifierImpl.log.trace((Object)MessageFormat.format("{0} tag manifests to check", new Object[]{total}));
        count = 0;
        for (Manifest manifest : bag.getTagManifests()) {
            this.progress("verifying tag files in manifest exist", (Object)manifest.getFilepath(), ++count, total);
            this.checkManifest(manifest, bag, result);
            if (this.isCancelled()) {
                return null;
            }
            if (FailModeSupporting.FailMode.FAIL_FAST != this.failMode || result.isSuccess()) continue;
            return result;
        }
        if (FailModeSupporting.FailMode.FAIL_STEP == this.failMode && !result.isSuccess()) {
            return result;
        }
        if (bag.getFile() != null) {
            try {
                bagDirNode = FileSystemFactory.getDirNodeForBag(bag.getFile(), bag.getBagFactory());
            }
            catch (FormatHelper.UnknownFormatException e) {
                throw new RuntimeException(e);
            }
            catch (FileSystemFactory.UnsupportedFormatException e) {
                throw new RuntimeException(e);
            }
            try {
                CompleteVerifierImpl.log.debug((Object)"Checking that only directory is data directory");
                if (!allowTagDirectories) {
                    dirNodes = bagDirNode.listChildren(new AndFileSystemNodeFilter(new FileSystemNodeFilter[]{new DirNodeFileSystemNodeFilter(), new IgnoringFileSystemNodeFilter(this.ignoreAdditionalDirectories, false)}));
                    filepath = dirNodes.iterator();
                    while (filepath.hasNext()) {
                        dirNode = (FileSystemNode)filepath.next();
                        if (bag.getBagConstants().getDataDirectory().equals(dirNode.getName())) continue;
                        result.setSuccess(false);
                        result.addMessage("directory_not_allowed_in_bag_dir", "Directory {0} not allowed in bag_dir.", dirNode.getName());
                        if (FailModeSupporting.FailMode.FAIL_FAST != this.failMode) continue;
                        normalizedPath = result;
                        return normalizedPath;
                    }
                }
                if (FailModeSupporting.FailMode.FAIL_STEP == this.failMode && !result.isSuccess()) {
                    dirNodes = result;
                    return dirNodes;
                }
                CompleteVerifierImpl.log.debug((Object)"Checking that all payload files on disk included in bag");
                dataDirNode = bagDirNode.childDir(bag.getBagConstants().getDataDirectory());
                if (dataDirNode == null) ** GOTO lbl169
                nodes = dataDirNode.listDescendants(new FileNodeFileSystemNodeFilter(), new IgnoringFileSystemNodeFilter(this.ignoreAdditionalDirectories, this.ignoreSymlinks));
                total = nodes.size();
                count = 0;
                for (FileSystemNode node : nodes) {
                    if (this.isCancelled()) {
                        manifest = null;
                        return manifest;
                    }
                    fileNode = (FileNode)node;
                    filepath = FilenameHelper.removeBasePath(bagDirNode.getFilepath(), fileNode.getFilepath());
                    this.progress("verifying payload files on disk are in bag", (Object)filepath, ++count, total);
                    CompleteVerifierImpl.log.trace((Object)MessageFormat.format("Checking that payload file {0} is in bag", new Object[]{filepath}));
                    file_in_bag = false;
                    for (Normalizer.Form form : this.formArray) {
                        normalizedPath = Normalizer.normalize(filepath, form);
                        if (bag.getBagFile(normalizedPath) == null) continue;
                        file_in_bag = true;
                        break;
                    }
                    if (file_in_bag) continue;
                    result.setSuccess(false);
                    result.addMessage("payload_file_not_in_payload_manifest", "Payload file {0} not found in any payload manifest.", filepath);
                    msg = MessageFormat.format("Bag has file {0} not found in manifest file.", new Object[]{filepath});
                    CompleteVerifierImpl.log.warn((Object)msg);
                    if (FailModeSupporting.FailMode.FAIL_FAST != this.failMode || result.isSuccess()) continue;
                    var16_22 = result;
                    return var16_22;
                }
                if (FailModeSupporting.FailMode.FAIL_STEP != this.failMode || result.isSuccess()) ** GOTO lbl169
                var10_15 = result;
                return var10_15;
            }
            finally {
                bagDirNode.getFileSystem().closeQuietly();
            }
        } else {
            CompleteVerifierImpl.log.debug((Object)"Not an existing bag");
        }
lbl169:
        // 3 sources

        CompleteVerifierImpl.log.info((Object)"Completed verification that bag is complete.");
        CompleteVerifierImpl.log.info((Object)"Note that this a verification of completeness, not validity. A bag may be complete without being valid, though a valid bag must be complete.");
        CompleteVerifierImpl.log.info((Object)("Result of verification that complete: " + result.toString()));
        return result;
    }

    protected void checkManifest(Manifest manifest, Bag bag, SimpleResult result) {
        log.trace((Object)("Checking manifest " + manifest.getFilepath()));
        int manifestTotal = manifest.keySet().size();
        int manifestCount = 0;
        for (String filepath : manifest.keySet()) {
            if (this.isCancelled()) {
                return;
            }
            this.progress("verifying files in manifest exist", (Object)filepath, ++manifestCount, manifestTotal);
            log.trace((Object)MessageFormat.format("Checking that file {0} in manifest {1} exists", filepath, manifest.getFilepath()));
            boolean file_exists = false;
            for (Normalizer.Form form : this.formArray) {
                String normalizedPath = Normalizer.normalize(filepath, form);
                log.trace((Object)MessageFormat.format("Trying path {0}, normalized as {1}", new Object[]{normalizedPath, form}));
                BagFile bagFile = bag.getBagFile(normalizedPath);
                if (bagFile == null) {
                    log.trace((Object)(normalizedPath + " not found in " + manifest.getFilepath()));
                    continue;
                }
                if (!bagFile.exists()) continue;
                file_exists = true;
                break;
            }
            if (file_exists) continue;
            if (manifest.isPayloadManifest()) {
                SimpleResultHelper.missingPayloadFile(result, manifest.getFilepath(), filepath);
            } else {
                SimpleResultHelper.missingTagFile(result, manifest.getFilepath(), filepath);
            }
            String message = MessageFormat.format("File {0} in manifest {1} missing from bag.", filepath, manifest.getFilepath());
            log.warn((Object)message);
            if (this.failMode != FailModeSupporting.FailMode.FAIL_FAST) continue;
            return;
        }
    }
}

