/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.verify.Verifier;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidHoleyBagVerifier
extends LongRunningOperationBase
implements Verifier {
    public static final String CODE_MISSING_FETCHTXT = "missing_fetchtxt";
    private static final Log log = LogFactory.getLog(ValidHoleyBagVerifier.class);

    @Override
    public SimpleResult verify(Bag bag) {
        SimpleResult result = new SimpleResult(true);
        log.trace((Object)"Checking for bag declaration.");
        if (bag.getBagItTxt() == null) {
            result.setSuccess(false);
            result.addMessage("no_bagittxt", MessageFormat.format("Bag does not have {0}.", bag.getBagConstants().getBagItTxt()));
        }
        log.trace((Object)"Checking for at least one payload manifest.");
        if (bag.getPayloadManifests().isEmpty()) {
            result.setSuccess(false);
            result.addMessage("no_payload_manifest", "Bag does not have any payload manifests.");
        }
        log.trace((Object)"Confirming version specified matches version in declaration.");
        if (bag.getBagItTxt() != null && !bag.getBagConstants().getVersion().versionString.equals(bag.getBagItTxt().getVersion())) {
            result.setSuccess(false);
            result.addMessage("wrong_version", MessageFormat.format("Version is not {0}.", new Object[]{bag.getBagConstants().getVersion()}));
        }
        log.trace((Object)"Checking for fetch.txt.");
        if (bag.getFetchTxt() == null) {
            result.setSuccess(false);
            result.addMessage(CODE_MISSING_FETCHTXT, MessageFormat.format("Bag does not have {0}.", bag.getBagConstants().getFetchTxt()));
        }
        log.info((Object)("Completion check: " + result.toString()));
        return result;
    }
}

