/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.models;

import io.apicurio.datamodels.core.models.IReferenceNode;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Oas30Header
extends OasHeader
implements IReferenceNode {
    public String $ref;
    public Boolean required;
    public Boolean deprecated;
    public Boolean allowEmptyValue;
    public String style;
    public Boolean explode;
    public Boolean allowReserved;
    public Oas30Schema schema;
    public Object example;
    public Map<String, Oas30Example> examples = new LinkedHashMap<String, Oas30Example>();
    public Map<String, Oas30MediaType> content = new LinkedHashMap<String, Oas30MediaType>();

    public Oas30Header(String name) {
        super(name);
    }

    @Override
    public String getReference() {
        return this.$ref;
    }

    @Override
    public void setReference(String reference) {
        this.$ref = reference;
    }

    public Oas30Schema createSchema() {
        Oas30Schema rval = new Oas30Schema();
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public Oas30Example createExample(String name) {
        Oas30Example rval = new Oas30Example(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public void addExample(Oas30Example example) {
        this.examples.put(example.getName(), example);
    }

    public Oas30Example removeExample(String name) {
        return this.examples.remove(name);
    }

    public Oas30Example getExample(String name) {
        return this.examples.get(name);
    }

    public List<Oas30Example> getExamples() {
        ArrayList<Oas30Example> rval = new ArrayList<Oas30Example>();
        rval.addAll(this.examples.values());
        return rval;
    }

    public Oas30MediaType createMediaType(String name) {
        Oas30MediaType rval = new Oas30MediaType(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public void addMediaType(String name, Oas30MediaType mediaType) {
        this.content.put(name, mediaType);
    }

    public Oas30MediaType getMediaType(String name) {
        return this.content.get(name);
    }

    public Oas30MediaType removeMediaType(String name) {
        return this.content.remove(name);
    }

    public List<Oas30MediaType> getMediaTypes() {
        ArrayList<Oas30MediaType> rval = new ArrayList<Oas30MediaType>();
        rval.addAll(this.content.values());
        return rval;
    }
}

