/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.imds;

import io.awspring.cloud.autoconfigure.imds.ImdsPropertySource;
import io.awspring.cloud.autoconfigure.imds.ImdsUtils;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import software.amazon.awssdk.imds.Ec2MetadataClient;

@AutoConfiguration
@ConditionalOnClass(value={Ec2MetadataClient.class})
@ConditionalOnProperty(name={"spring.cloud.aws.imds.enabled"}, havingValue="true", matchIfMissing=true)
public class ImdsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ImdsPropertySource imdsPropertySource(ConfigurableEnvironment env, ImdsUtils imdsUtils) {
        ImdsPropertySource propertySource = new ImdsPropertySource("Ec2InstanceMetadata", imdsUtils);
        propertySource.init();
        env.getPropertySources().addFirst((PropertySource)propertySource);
        return propertySource;
    }

    @Bean
    @ConditionalOnMissingBean
    public ImdsUtils imdsUtils(Ec2MetadataClient ec2MetadataClient) {
        return new ImdsUtils(ec2MetadataClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public Ec2MetadataClient ec2MetadataClient() {
        return Ec2MetadataClient.create();
    }
}

