/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.secretsmanager;

import io.awspring.cloud.autoconfigure.config.BootstrapLoggingHelper;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerConfigDataResource;
import io.awspring.cloud.secretsmanager.SecretsManagerPropertySource;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.MapPropertySource;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

public class SecretsManagerConfigDataLoader
implements ConfigDataLoader<SecretsManagerConfigDataResource> {
    public SecretsManagerConfigDataLoader(DeferredLogFactory logFactory) {
        BootstrapLoggingHelper.reconfigureLoggers(logFactory, "io.awspring.cloud.secretsmanager.SecretsManagerPropertySource", "io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerPropertySources");
    }

    @Nullable
    public ConfigData load(ConfigDataLoaderContext context, SecretsManagerConfigDataResource resource) {
        if (resource.isEnabled()) {
            SecretsManagerClient sm = (SecretsManagerClient)context.getBootstrapContext().get(SecretsManagerClient.class);
            SecretsManagerPropertySource propertySource = resource.getPropertySources().createPropertySource(resource.getContext(), resource.isOptional(), sm);
            if (propertySource != null) {
                return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
            }
            return null;
        }
        return new ConfigData(Collections.singletonList(new MapPropertySource("aws-secretsmanager:" + context, Map.of())), new ConfigData.Option[0]);
    }
}

