/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.spring.client.configuration.PropertyUtil;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnMissingBean(value={ZeebeClientExecutorService.class})
public class ExecutorServiceConfiguration {
    private final ZeebeClientConfigurationProperties configurationProperties;
    private final CamundaClientProperties camundaClientProperties;

    public ExecutorServiceConfiguration(ZeebeClientConfigurationProperties configurationProperties, CamundaClientProperties camundaClientProperties) {
        this.configurationProperties = configurationProperties;
        this.camundaClientProperties = camundaClientProperties;
    }

    @Bean
    public ZeebeClientExecutorService zeebeClientThreadPool(@Autowired(required=false) MeterRegistry meterRegistry) {
        ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(PropertyUtil.getOrLegacyOrDefault("NumJobWorkerExecutionThreads", () -> this.camundaClientProperties.getZeebe().getExecutionThreads(), this.configurationProperties::getNumJobWorkerExecutionThreads, ZeebeClientConfigurationProperties.DEFAULT.getNumJobWorkerExecutionThreads(), null));
        if (meterRegistry != null) {
            ExecutorServiceMetrics threadPoolMetrics = new ExecutorServiceMetrics((ExecutorService)threadPool, "zeebe_client_thread_pool", Collections.emptyList());
            threadPoolMetrics.bindTo(meterRegistry);
        }
        return new ZeebeClientExecutorService(threadPool, true);
    }
}

