/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.event;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.event.ClientStartedEvent;
import io.camunda.zeebe.spring.client.event.ClientStoppedEvent;
import io.camunda.zeebe.spring.client.event.ZeebeClientClosingEvent;
import io.camunda.zeebe.spring.client.event.ZeebeClientCreatedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;

public class ZeebeLifecycleEventProducer
implements SmartLifecycle {
    protected boolean running = false;
    private final ApplicationEventPublisher publisher;
    private final ZeebeClient client;

    public ZeebeLifecycleEventProducer(ZeebeClient client, ApplicationEventPublisher publisher) {
        this.client = client;
        this.publisher = publisher;
    }

    public void start() {
        this.publisher.publishEvent((Object)new ClientStartedEvent());
        this.publisher.publishEvent((ApplicationEvent)new ZeebeClientCreatedEvent((Object)this, this.client));
        this.running = true;
    }

    public void stop() {
        this.publisher.publishEvent((Object)new ClientStoppedEvent());
        this.publisher.publishEvent((ApplicationEvent)new ZeebeClientClosingEvent((Object)this, this.client));
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

