/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.exception.ZeebeBpmnError;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolver;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class JobHandlerInvokingSpringBeans
implements JobHandler {
    private static final Logger LOG = Loggers.JOB_WORKER_LOGGER;
    private final ZeebeWorkerValue workerValue;
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final MetricsRecorder metricsRecorder;
    private final List<ParameterResolver> parameterResolvers;

    public JobHandlerInvokingSpringBeans(ZeebeWorkerValue workerValue, CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy) {
        this.workerValue = workerValue;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.metricsRecorder = metricsRecorder;
        this.parameterResolvers = this.createParameterResolvers(parameterResolverStrategy);
    }

    private List<ParameterResolver> createParameterResolvers(ParameterResolverStrategy parameterResolverStrategy) {
        return this.workerValue.getMethodInfo().getParameters().stream().map(parameterResolverStrategy::createResolver).toList();
    }

    public void handle(JobClient jobClient, ActivatedJob job) throws Exception {
        List<Object> args = this.createParameters(jobClient, job);
        LOG.trace("Handle {} and invoke worker {}", (Object)job, (Object)this.workerValue);
        try {
            this.metricsRecorder.increase("camunda.job.invocations", "activated", job.getType());
            Object result = null;
            try {
                result = this.workerValue.getMethodInfo().invoke(args.toArray());
            }
            catch (Throwable t) {
                this.metricsRecorder.increase("camunda.job.invocations", "failed", job.getType());
                throw t;
            }
            if (this.workerValue.getAutoComplete().booleanValue()) {
                LOG.trace("Auto completing {}", (Object)job);
                this.metricsRecorder.increase("camunda.job.invocations", "completed", job.getType());
                CommandWrapper command = new CommandWrapper((FinalCommandStep<Void>)this.createCompleteCommand(jobClient, job, result), job, this.commandExceptionHandlingStrategy);
                command.executeAsync();
            }
        }
        catch (ZeebeBpmnError bpmnError) {
            LOG.trace("Catched BPMN error on {}", (Object)job);
            this.metricsRecorder.increase("camunda.job.invocations", "bpmn-error", job.getType());
            CommandWrapper command = new CommandWrapper(this.createThrowErrorCommand(jobClient, job, bpmnError), job, this.commandExceptionHandlingStrategy);
            command.executeAsync();
        }
    }

    private List<Object> createParameters(JobClient jobClient, ActivatedJob job) {
        return this.parameterResolvers.stream().map(resolver -> resolver.resolve(jobClient, job)).toList();
    }

    private FinalCommandStep createCompleteCommand(JobClient jobClient, ActivatedJob job, Object result) {
        CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(job.getKey());
        if (result != null) {
            completeCommand = result.getClass().isAssignableFrom(Map.class) ? completeCommand.variables((Map)result) : (result.getClass().isAssignableFrom(String.class) ? completeCommand.variables((String)result) : (result.getClass().isAssignableFrom(InputStream.class) ? completeCommand.variables((InputStream)result) : completeCommand.variables(result)));
        }
        return completeCommand;
    }

    private FinalCommandStep<Void> createThrowErrorCommand(JobClient jobClient, ActivatedJob job, ZeebeBpmnError bpmnError) {
        ThrowErrorCommandStep1.ThrowErrorCommandStep2 command = jobClient.newThrowErrorCommand(job.getKey()).errorCode(bpmnError.getErrorCode()).errorMessage(bpmnError.getErrorMessage());
        if (bpmnError.getVariables() != null) {
            command.variables(bpmnError.getVariables());
        }
        return command;
    }
}

