/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.BrokerInfoDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.MetaAttribute;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import io.camunda.zeebe.protocol.record.PartitionRole;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class BrokerInfoEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 201;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 6;
    public static final String SEMANTIC_VERSION = "8.8.9";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BrokerInfoEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private final AddressesEncoder addresses = new AddressesEncoder(this);
    private final PartitionRolesEncoder partitionRoles = new PartitionRolesEncoder(this);
    private final PartitionLeaderTermsEncoder partitionLeaderTerms = new PartitionLeaderTermsEncoder(this);
    private final PartitionHealthEncoder partitionHealth = new PartitionHealthEncoder(this);

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 201;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public BrokerInfoEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 16);
        return this;
    }

    public BrokerInfoEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(16).templateId(201).schemaId(0).version(6);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int nodeIdId() {
        return 1;
    }

    public static int nodeIdSinceVersion() {
        return 0;
    }

    public static int nodeIdEncodingOffset() {
        return 0;
    }

    public static int nodeIdEncodingLength() {
        return 4;
    }

    public static String nodeIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int nodeIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int nodeIdMinValue() {
        return -2147483647;
    }

    public static int nodeIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public BrokerInfoEncoder nodeId(int value) {
        this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int partitionsCountId() {
        return 2;
    }

    public static int partitionsCountSinceVersion() {
        return 0;
    }

    public static int partitionsCountEncodingOffset() {
        return 4;
    }

    public static int partitionsCountEncodingLength() {
        return 4;
    }

    public static String partitionsCountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionsCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int partitionsCountMinValue() {
        return -2147483647;
    }

    public static int partitionsCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public BrokerInfoEncoder partitionsCount(int value) {
        this.buffer.putInt(this.offset + 4, value, BYTE_ORDER);
        return this;
    }

    public static int clusterSizeId() {
        return 3;
    }

    public static int clusterSizeSinceVersion() {
        return 0;
    }

    public static int clusterSizeEncodingOffset() {
        return 8;
    }

    public static int clusterSizeEncodingLength() {
        return 4;
    }

    public static String clusterSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int clusterSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int clusterSizeMinValue() {
        return -2147483647;
    }

    public static int clusterSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public BrokerInfoEncoder clusterSize(int value) {
        this.buffer.putInt(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int replicationFactorId() {
        return 4;
    }

    public static int replicationFactorSinceVersion() {
        return 0;
    }

    public static int replicationFactorEncodingOffset() {
        return 12;
    }

    public static int replicationFactorEncodingLength() {
        return 4;
    }

    public static String replicationFactorMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replicationFactorNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replicationFactorMinValue() {
        return -2147483647;
    }

    public static int replicationFactorMaxValue() {
        return Integer.MAX_VALUE;
    }

    public BrokerInfoEncoder replicationFactor(int value) {
        this.buffer.putInt(this.offset + 12, value, BYTE_ORDER);
        return this;
    }

    public static long addressesId() {
        return 5L;
    }

    public AddressesEncoder addressesCount(int count) {
        this.addresses.wrap(this.buffer, count);
        return this.addresses;
    }

    public static long partitionRolesId() {
        return 8L;
    }

    public PartitionRolesEncoder partitionRolesCount(int count) {
        this.partitionRoles.wrap(this.buffer, count);
        return this.partitionRoles;
    }

    public static long partitionLeaderTermsId() {
        return 11L;
    }

    public PartitionLeaderTermsEncoder partitionLeaderTermsCount(int count) {
        this.partitionLeaderTerms.wrap(this.buffer, count);
        return this.partitionLeaderTerms;
    }

    public static long partitionHealthId() {
        return 15L;
    }

    public PartitionHealthEncoder partitionHealthCount(int count) {
        this.partitionHealth.wrap(this.buffer, count);
        return this.partitionHealth;
    }

    public static int versionId() {
        return 14;
    }

    public static String versionCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionHeaderLength() {
        return 4;
    }

    public BrokerInfoEncoder putVersion(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BrokerInfoEncoder putVersion(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BrokerInfoEncoder version(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        BrokerInfoDecoder decoder = new BrokerInfoDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 16, 6);
        return decoder.appendTo(builder);
    }

    public static final class AddressesEncoder {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        AddressesEncoder(BrokerInfoEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)0, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public AddressesEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + AddressesEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public static int apiNameId() {
            return 6;
        }

        public static String apiNameCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String apiNameMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int apiNameHeaderLength() {
            return 4;
        }

        public AddressesEncoder putApiName(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public AddressesEncoder putApiName(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public AddressesEncoder apiName(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }

        public static int addressId() {
            return 7;
        }

        public static String addressCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String addressMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int addressHeaderLength() {
            return 4;
        }

        public AddressesEncoder putAddress(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public AddressesEncoder putAddress(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public AddressesEncoder address(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }

    public static final class PartitionRolesEncoder {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PartitionRolesEncoder(BrokerInfoEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)5, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public PartitionRolesEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + PartitionRolesEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 5;
        }

        public static int partitionIdId() {
            return 9;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 0;
        }

        public static int partitionIdEncodingLength() {
            return 4;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int partitionIdMinValue() {
            return -2147483647;
        }

        public static int partitionIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public PartitionRolesEncoder partitionId(int value) {
            this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static int roleId() {
            return 10;
        }

        public static int roleSinceVersion() {
            return 0;
        }

        public static int roleEncodingOffset() {
            return 4;
        }

        public static int roleEncodingLength() {
            return 1;
        }

        public static String roleMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public PartitionRolesEncoder role(PartitionRole value) {
            this.buffer.putByte(this.offset + 4, (byte)value.value());
            return this;
        }
    }

    public static final class PartitionLeaderTermsEncoder {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PartitionLeaderTermsEncoder(BrokerInfoEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)12, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public PartitionLeaderTermsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + PartitionLeaderTermsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 12;
        }

        public static int partitionIdId() {
            return 12;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 0;
        }

        public static int partitionIdEncodingLength() {
            return 4;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int partitionIdMinValue() {
            return -2147483647;
        }

        public static int partitionIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public PartitionLeaderTermsEncoder partitionId(int value) {
            this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static int termId() {
            return 13;
        }

        public static int termSinceVersion() {
            return 0;
        }

        public static int termEncodingOffset() {
            return 4;
        }

        public static int termEncodingLength() {
            return 8;
        }

        public static String termMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long termNullValue() {
            return Long.MIN_VALUE;
        }

        public static long termMinValue() {
            return -9223372036854775807L;
        }

        public static long termMaxValue() {
            return Long.MAX_VALUE;
        }

        public PartitionLeaderTermsEncoder term(long value) {
            this.buffer.putLong(this.offset + 4, value, BYTE_ORDER);
            return this;
        }
    }

    public static final class PartitionHealthEncoder {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PartitionHealthEncoder(BrokerInfoEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)5, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public PartitionHealthEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + PartitionHealthEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 5;
        }

        public static int partitionIdId() {
            return 16;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 0;
        }

        public static int partitionIdEncodingLength() {
            return 4;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int partitionIdMinValue() {
            return -2147483647;
        }

        public static int partitionIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public PartitionHealthEncoder partitionId(int value) {
            this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static int healthStatusId() {
            return 17;
        }

        public static int healthStatusSinceVersion() {
            return 0;
        }

        public static int healthStatusEncodingOffset() {
            return 4;
        }

        public static int healthStatusEncodingLength() {
            return 1;
        }

        public static String healthStatusMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public PartitionHealthEncoder healthStatus(PartitionHealthStatus value) {
            this.buffer.putByte(this.offset + 4, (byte)value.value());
            return this;
        }
    }
}

