/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.CompositeDecoderFlyweight;

public final class VersionDecoder
implements CompositeDecoderFlyweight {
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 6;
    public static final String SEMANTIC_VERSION = "8.8.9";
    public static final int ENCODED_LENGTH = 12;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public VersionDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 12;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public static int majorVersionEncodingOffset() {
        return 0;
    }

    public static int majorVersionEncodingLength() {
        return 4;
    }

    public static int majorVersionSinceVersion() {
        return 2;
    }

    public static int majorVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int majorVersionMinValue() {
        return -2147483647;
    }

    public static int majorVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int majorVersion() {
        return this.buffer.getInt(this.offset + 0, BYTE_ORDER);
    }

    public static int minorVersionEncodingOffset() {
        return 4;
    }

    public static int minorVersionEncodingLength() {
        return 4;
    }

    public static int minorVersionSinceVersion() {
        return 2;
    }

    public static int minorVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int minorVersionMinValue() {
        return -2147483647;
    }

    public static int minorVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int minorVersion() {
        return this.buffer.getInt(this.offset + 4, BYTE_ORDER);
    }

    public static int patchVersionEncodingOffset() {
        return 8;
    }

    public static int patchVersionEncodingLength() {
        return 4;
    }

    public static int patchVersionSinceVersion() {
        return 2;
    }

    public static int patchVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int patchVersionMinValue() {
        return -2147483647;
    }

    public static int patchVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int patchVersion() {
        return this.buffer.getInt(this.offset + 8, BYTE_ORDER);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("majorVersion=");
        builder.append(this.majorVersion());
        builder.append('|');
        builder.append("minorVersion=");
        builder.append(this.minorVersion());
        builder.append('|');
        builder.append("patchVersion=");
        builder.append(this.patchVersion());
        builder.append(')');
        return builder;
    }
}

