/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.AsyncRequestRecordValue;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="AsyncRequestRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableAsyncRequestRecordValue
implements AsyncRequestRecordValue {
    private final long scopeKey;
    private final ValueType valueType;
    private final Intent intent;
    private final long requestId;
    private final int requestStreamId;
    private final long operationReference;
    private transient int hashCode;

    private ImmutableAsyncRequestRecordValue(long scopeKey, ValueType valueType, Intent intent, long requestId, int requestStreamId, long operationReference) {
        this.scopeKey = scopeKey;
        this.valueType = valueType;
        this.intent = intent;
        this.requestId = requestId;
        this.requestStreamId = requestStreamId;
        this.operationReference = operationReference;
    }

    @Override
    public long getScopeKey() {
        return this.scopeKey;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public Intent getIntent() {
        return this.intent;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public int getRequestStreamId() {
        return this.requestStreamId;
    }

    @Override
    public long getOperationReference() {
        return this.operationReference;
    }

    public final ImmutableAsyncRequestRecordValue withScopeKey(long value) {
        if (this.scopeKey == value) {
            return this;
        }
        return new ImmutableAsyncRequestRecordValue(value, this.valueType, this.intent, this.requestId, this.requestStreamId, this.operationReference);
    }

    public final ImmutableAsyncRequestRecordValue withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        return new ImmutableAsyncRequestRecordValue(this.scopeKey, value, this.intent, this.requestId, this.requestStreamId, this.operationReference);
    }

    public final ImmutableAsyncRequestRecordValue withIntent(Intent value) {
        if (this.intent == value) {
            return this;
        }
        return new ImmutableAsyncRequestRecordValue(this.scopeKey, this.valueType, value, this.requestId, this.requestStreamId, this.operationReference);
    }

    public final ImmutableAsyncRequestRecordValue withRequestId(long value) {
        if (this.requestId == value) {
            return this;
        }
        return new ImmutableAsyncRequestRecordValue(this.scopeKey, this.valueType, this.intent, value, this.requestStreamId, this.operationReference);
    }

    public final ImmutableAsyncRequestRecordValue withRequestStreamId(int value) {
        if (this.requestStreamId == value) {
            return this;
        }
        return new ImmutableAsyncRequestRecordValue(this.scopeKey, this.valueType, this.intent, this.requestId, value, this.operationReference);
    }

    public final ImmutableAsyncRequestRecordValue withOperationReference(long value) {
        if (this.operationReference == value) {
            return this;
        }
        return new ImmutableAsyncRequestRecordValue(this.scopeKey, this.valueType, this.intent, this.requestId, this.requestStreamId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAsyncRequestRecordValue && this.equalTo(0, (ImmutableAsyncRequestRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableAsyncRequestRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.scopeKey == another.scopeKey && Objects.equals((Object)this.valueType, (Object)another.valueType) && Objects.equals(this.intent, another.intent) && this.requestId == another.requestId && this.requestStreamId == another.requestStreamId && this.operationReference == another.operationReference;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.scopeKey);
        h += (h << 5) + Objects.hashCode((Object)this.valueType);
        h += (h << 5) + Objects.hashCode(this.intent);
        h += (h << 5) + Long.hashCode(this.requestId);
        h += (h << 5) + this.requestStreamId;
        h += (h << 5) + Long.hashCode(this.operationReference);
        return h;
    }

    public String toString() {
        return "AsyncRequestRecordValue{scopeKey=" + this.scopeKey + ", valueType=" + (Object)((Object)this.valueType) + ", intent=" + this.intent + ", requestId=" + this.requestId + ", requestStreamId=" + this.requestStreamId + ", operationReference=" + this.operationReference + "}";
    }

    public static ImmutableAsyncRequestRecordValue copyOf(AsyncRequestRecordValue instance) {
        if (instance instanceof ImmutableAsyncRequestRecordValue) {
            return (ImmutableAsyncRequestRecordValue)instance;
        }
        return ImmutableAsyncRequestRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="AsyncRequestRecordValue", generator="Immutables")
    public static final class Builder {
        private long scopeKey;
        private ValueType valueType;
        private Intent intent;
        private long requestId;
        private int requestStreamId;
        private long operationReference;

        private Builder() {
        }

        public final Builder from(AsyncRequestRecordValue instance) {
            Intent intentValue;
            Objects.requireNonNull(instance, "instance");
            this.withScopeKey(instance.getScopeKey());
            ValueType valueTypeValue = instance.getValueType();
            if (valueTypeValue != null) {
                this.withValueType(valueTypeValue);
            }
            if ((intentValue = instance.getIntent()) != null) {
                this.withIntent(intentValue);
            }
            this.withRequestId(instance.getRequestId());
            this.withRequestStreamId(instance.getRequestStreamId());
            this.withOperationReference(instance.getOperationReference());
            return this;
        }

        public final Builder withScopeKey(long scopeKey) {
            this.scopeKey = scopeKey;
            return this;
        }

        public final Builder withValueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public final Builder withIntent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public final Builder withRequestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Builder withRequestStreamId(int requestStreamId) {
            this.requestStreamId = requestStreamId;
            return this;
        }

        public final Builder withOperationReference(long operationReference) {
            this.operationReference = operationReference;
            return this;
        }

        public Builder clear() {
            this.scopeKey = 0L;
            this.valueType = null;
            this.intent = null;
            this.requestId = 0L;
            this.requestStreamId = 0;
            this.operationReference = 0L;
            return this;
        }

        public ImmutableAsyncRequestRecordValue build() {
            return new ImmutableAsyncRequestRecordValue(this.scopeKey, this.valueType, this.intent, this.requestId, this.requestStreamId, this.operationReference);
        }
    }
}

