/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.AuthorizationOwnerType;
import io.camunda.zeebe.protocol.record.value.AuthorizationRecordValue;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceMatcher;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="AuthorizationRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableAuthorizationRecordValue
implements AuthorizationRecordValue {
    private final Long authorizationKey;
    private final String ownerId;
    private final AuthorizationOwnerType ownerType;
    private final AuthorizationResourceMatcher resourceMatcher;
    private final String resourceId;
    private final AuthorizationResourceType resourceType;
    private final Set<PermissionType> permissionTypes;
    private transient int hashCode;

    private ImmutableAuthorizationRecordValue(Long authorizationKey, String ownerId, AuthorizationOwnerType ownerType, AuthorizationResourceMatcher resourceMatcher, String resourceId, AuthorizationResourceType resourceType, Set<PermissionType> permissionTypes) {
        this.authorizationKey = authorizationKey;
        this.ownerId = ownerId;
        this.ownerType = ownerType;
        this.resourceMatcher = resourceMatcher;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.permissionTypes = permissionTypes;
    }

    @Override
    public Long getAuthorizationKey() {
        return this.authorizationKey;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public AuthorizationOwnerType getOwnerType() {
        return this.ownerType;
    }

    @Override
    public AuthorizationResourceMatcher getResourceMatcher() {
        return this.resourceMatcher;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public AuthorizationResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public Set<PermissionType> getPermissionTypes() {
        return this.permissionTypes;
    }

    public final ImmutableAuthorizationRecordValue withAuthorizationKey(Long value) {
        if (Objects.equals(this.authorizationKey, value)) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(value, this.ownerId, this.ownerType, this.resourceMatcher, this.resourceId, this.resourceType, this.permissionTypes);
    }

    public final ImmutableAuthorizationRecordValue withOwnerId(String value) {
        if (Objects.equals(this.ownerId, value)) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, value, this.ownerType, this.resourceMatcher, this.resourceId, this.resourceType, this.permissionTypes);
    }

    public final ImmutableAuthorizationRecordValue withOwnerType(AuthorizationOwnerType value) {
        if (this.ownerType == value) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerId, value, this.resourceMatcher, this.resourceId, this.resourceType, this.permissionTypes);
    }

    public final ImmutableAuthorizationRecordValue withResourceMatcher(AuthorizationResourceMatcher value) {
        if (this.resourceMatcher == value) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerId, this.ownerType, value, this.resourceId, this.resourceType, this.permissionTypes);
    }

    public final ImmutableAuthorizationRecordValue withResourceId(String value) {
        if (Objects.equals(this.resourceId, value)) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerId, this.ownerType, this.resourceMatcher, value, this.resourceType, this.permissionTypes);
    }

    public final ImmutableAuthorizationRecordValue withResourceType(AuthorizationResourceType value) {
        if (this.resourceType == value) {
            return this;
        }
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerId, this.ownerType, this.resourceMatcher, this.resourceId, value, this.permissionTypes);
    }

    public final ImmutableAuthorizationRecordValue withPermissionTypes(PermissionType ... elements) {
        Set<PermissionType> newValue = ImmutableAuthorizationRecordValue.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerId, this.ownerType, this.resourceMatcher, this.resourceId, this.resourceType, newValue);
    }

    public final ImmutableAuthorizationRecordValue withPermissionTypes(Iterable<PermissionType> elements) {
        if (this.permissionTypes == elements) {
            return this;
        }
        Set<PermissionType> newValue = ImmutableAuthorizationRecordValue.createUnmodifiableEnumSet(elements);
        return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerId, this.ownerType, this.resourceMatcher, this.resourceId, this.resourceType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizationRecordValue && this.equalTo(0, (ImmutableAuthorizationRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizationRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.authorizationKey, another.authorizationKey) && Objects.equals(this.ownerId, another.ownerId) && Objects.equals(this.ownerType, another.ownerType) && Objects.equals(this.resourceMatcher, another.resourceMatcher) && Objects.equals(this.resourceId, another.resourceId) && Objects.equals(this.resourceType, another.resourceType) && this.permissionTypes.equals(another.permissionTypes);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.authorizationKey);
        h += (h << 5) + Objects.hashCode(this.ownerId);
        h += (h << 5) + Objects.hashCode(this.ownerType);
        h += (h << 5) + Objects.hashCode(this.resourceMatcher);
        h += (h << 5) + Objects.hashCode(this.resourceId);
        h += (h << 5) + Objects.hashCode(this.resourceType);
        h += (h << 5) + this.permissionTypes.hashCode();
        return h;
    }

    public String toString() {
        return "AuthorizationRecordValue{authorizationKey=" + this.authorizationKey + ", ownerId=" + this.ownerId + ", ownerType=" + this.ownerType + ", resourceMatcher=" + this.resourceMatcher + ", resourceId=" + this.resourceId + ", resourceType=" + this.resourceType + ", permissionTypes=" + this.permissionTypes + "}";
    }

    public static ImmutableAuthorizationRecordValue copyOf(AuthorizationRecordValue instance) {
        if (instance instanceof ImmutableAuthorizationRecordValue) {
            return (ImmutableAuthorizationRecordValue)instance;
        }
        return ImmutableAuthorizationRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableAuthorizationRecordValue.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton((Enum)list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    @ImmutableProtocol.Builder
    @Generated(from="AuthorizationRecordValue", generator="Immutables")
    public static final class Builder {
        private Long authorizationKey;
        private String ownerId;
        private AuthorizationOwnerType ownerType;
        private AuthorizationResourceMatcher resourceMatcher;
        private String resourceId;
        private AuthorizationResourceType resourceType;
        private EnumSet<PermissionType> permissionTypes = EnumSet.noneOf(PermissionType.class);

        private Builder() {
        }

        public final Builder from(AuthorizationRecordValue instance) {
            AuthorizationResourceType resourceTypeValue;
            String resourceIdValue;
            AuthorizationResourceMatcher resourceMatcherValue;
            AuthorizationOwnerType ownerTypeValue;
            String ownerIdValue;
            Objects.requireNonNull(instance, "instance");
            Long authorizationKeyValue = instance.getAuthorizationKey();
            if (authorizationKeyValue != null) {
                this.withAuthorizationKey(authorizationKeyValue);
            }
            if ((ownerIdValue = instance.getOwnerId()) != null) {
                this.withOwnerId(ownerIdValue);
            }
            if ((ownerTypeValue = instance.getOwnerType()) != null) {
                this.withOwnerType(ownerTypeValue);
            }
            if ((resourceMatcherValue = instance.getResourceMatcher()) != null) {
                this.withResourceMatcher(resourceMatcherValue);
            }
            if ((resourceIdValue = instance.getResourceId()) != null) {
                this.withResourceId(resourceIdValue);
            }
            if ((resourceTypeValue = instance.getResourceType()) != null) {
                this.withResourceType(resourceTypeValue);
            }
            this.addAllPermissionTypes(instance.getPermissionTypes());
            return this;
        }

        public final Builder withAuthorizationKey(Long authorizationKey) {
            this.authorizationKey = authorizationKey;
            return this;
        }

        public final Builder withOwnerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Builder withOwnerType(AuthorizationOwnerType ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        public final Builder withResourceMatcher(AuthorizationResourceMatcher resourceMatcher) {
            this.resourceMatcher = resourceMatcher;
            return this;
        }

        public final Builder withResourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Builder withResourceType(AuthorizationResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Builder addPermissionType(PermissionType element) {
            this.permissionTypes.add(element);
            return this;
        }

        public final Builder addPermissionTypes(PermissionType ... elements) {
            for (PermissionType element : elements) {
                this.permissionTypes.add(element);
            }
            return this;
        }

        public final Builder withPermissionTypes(Iterable<PermissionType> elements) {
            this.permissionTypes.clear();
            return this.addAllPermissionTypes(elements);
        }

        public final Builder addAllPermissionTypes(Iterable<PermissionType> elements) {
            for (PermissionType element : elements) {
                this.permissionTypes.add(element);
            }
            return this;
        }

        public Builder clear() {
            this.authorizationKey = null;
            this.ownerId = null;
            this.ownerType = null;
            this.resourceMatcher = null;
            this.resourceId = null;
            this.resourceType = null;
            this.permissionTypes.clear();
            return this;
        }

        public ImmutableAuthorizationRecordValue build() {
            return new ImmutableAuthorizationRecordValue(this.authorizationKey, this.ownerId, this.ownerType, this.resourceMatcher, this.resourceId, this.resourceType, ImmutableAuthorizationRecordValue.createUnmodifiableEnumSet(this.permissionTypes));
        }
    }
}

