/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ProcessInstanceResultRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableProcessInstanceResultRecordValue
implements ProcessInstanceResultRecordValue {
    private final Map<String, Object> variables;
    private final String tenantId;
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private final long processInstanceKey;
    private final Set<String> tags;
    private transient int hashCode;

    private ImmutableProcessInstanceResultRecordValue(Map<String, Object> variables, String tenantId, String bpmnProcessId, int version, long processDefinitionKey, long processInstanceKey, Set<String> tags) {
        this.variables = variables;
        this.tenantId = tenantId;
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.tags = tags;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    public final ImmutableProcessInstanceResultRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableProcessInstanceResultRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableProcessInstanceResultRecordValue(newValue, this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.tags);
    }

    public final ImmutableProcessInstanceResultRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, value, this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.tags);
    }

    public final ImmutableProcessInstanceResultRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.tenantId, value, this.version, this.processDefinitionKey, this.processInstanceKey, this.tags);
    }

    public final ImmutableProcessInstanceResultRecordValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.tenantId, this.bpmnProcessId, value, this.processDefinitionKey, this.processInstanceKey, this.tags);
    }

    public final ImmutableProcessInstanceResultRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.tenantId, this.bpmnProcessId, this.version, value, this.processInstanceKey, this.tags);
    }

    public final ImmutableProcessInstanceResultRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, value, this.tags);
    }

    public final ImmutableProcessInstanceResultRecordValue withTags(String ... elements) {
        Set<String> newValue = ImmutableProcessInstanceResultRecordValue.createUnmodifiableSet(ImmutableProcessInstanceResultRecordValue.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, newValue);
    }

    public final ImmutableProcessInstanceResultRecordValue withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        Set<String> newValue = ImmutableProcessInstanceResultRecordValue.createUnmodifiableSet(ImmutableProcessInstanceResultRecordValue.createSafeList(elements, false, false));
        return new ImmutableProcessInstanceResultRecordValue(this.variables, this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessInstanceResultRecordValue && this.equalTo(0, (ImmutableProcessInstanceResultRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessInstanceResultRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.variables.equals(another.variables) && Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey && this.tags.equals(another.tags);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + this.version;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + this.tags.hashCode();
        return h;
    }

    public String toString() {
        return "ProcessInstanceResultRecordValue{variables=" + this.variables + ", tenantId=" + this.tenantId + ", bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + ", tags=" + this.tags + "}";
    }

    public static ImmutableProcessInstanceResultRecordValue copyOf(ProcessInstanceResultRecordValue instance) {
        if (instance instanceof ImmutableProcessInstanceResultRecordValue) {
            return (ImmutableProcessInstanceResultRecordValue)instance;
        }
        return ImmutableProcessInstanceResultRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @ImmutableProtocol.Builder
    @Generated(from="ProcessInstanceResultRecordValue", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private String tenantId;
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;
        private long processInstanceKey;
        private List<String> tags = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(ProcessInstanceResultRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String tenantIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceResultRecordValue) {
                String bpmnProcessIdValue;
                instance = (ProcessInstanceResultRecordValue)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
                this.withVersion(instance.getVersion());
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
                this.addAllTags(instance.getTags());
            }
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 4L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
            }
        }

        public final Builder putVariable(String key, Object value) {
            this.variables.put(key, value);
            return this;
        }

        public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(k, v);
            return this;
        }

        public final Builder withVariables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(k, v);
            }
            return this;
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder addTag(String element) {
            this.tags.add(element);
            return this;
        }

        public final Builder addTags(String ... elements) {
            for (String element : elements) {
                this.tags.add(element);
            }
            return this;
        }

        public final Builder withTags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add(element);
            }
            return this;
        }

        public Builder clear() {
            this.variables.clear();
            this.tenantId = null;
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            this.processInstanceKey = 0L;
            this.tags.clear();
            return this;
        }

        public ImmutableProcessInstanceResultRecordValue build() {
            return new ImmutableProcessInstanceResultRecordValue(ImmutableProcessInstanceResultRecordValue.createUnmodifiableMap(false, false, this.variables), this.tenantId, this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, ImmutableProcessInstanceResultRecordValue.createUnmodifiableSet(this.tags));
        }
    }
}

