/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.RuntimeInstructionRecordValue;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="RuntimeInstructionRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableRuntimeInstructionRecordValue
implements RuntimeInstructionRecordValue {
    private final long processInstanceKey;
    private final String tenantId;
    private final String elementId;
    private transient int hashCode;

    private ImmutableRuntimeInstructionRecordValue(long processInstanceKey, String tenantId, String elementId) {
        this.processInstanceKey = processInstanceKey;
        this.tenantId = tenantId;
        this.elementId = elementId;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    public final ImmutableRuntimeInstructionRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableRuntimeInstructionRecordValue(value, this.tenantId, this.elementId);
    }

    public final ImmutableRuntimeInstructionRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableRuntimeInstructionRecordValue(this.processInstanceKey, value, this.elementId);
    }

    public final ImmutableRuntimeInstructionRecordValue withElementId(String value) {
        if (Objects.equals(this.elementId, value)) {
            return this;
        }
        return new ImmutableRuntimeInstructionRecordValue(this.processInstanceKey, this.tenantId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRuntimeInstructionRecordValue && this.equalTo(0, (ImmutableRuntimeInstructionRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableRuntimeInstructionRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.processInstanceKey == another.processInstanceKey && Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.elementId, another.elementId);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.elementId);
        return h;
    }

    public String toString() {
        return "RuntimeInstructionRecordValue{processInstanceKey=" + this.processInstanceKey + ", tenantId=" + this.tenantId + ", elementId=" + this.elementId + "}";
    }

    public static ImmutableRuntimeInstructionRecordValue copyOf(RuntimeInstructionRecordValue instance) {
        if (instance instanceof ImmutableRuntimeInstructionRecordValue) {
            return (ImmutableRuntimeInstructionRecordValue)instance;
        }
        return ImmutableRuntimeInstructionRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="RuntimeInstructionRecordValue", generator="Immutables")
    public static final class Builder {
        private long processInstanceKey;
        private String tenantId;
        private String elementId;

        private Builder() {
        }

        public final Builder from(RuntimeInstructionRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof RuntimeInstructionRecordValue) {
                instance = (RuntimeInstructionRecordValue)object;
                String elementIdValue = instance.getElementId();
                if (elementIdValue != null) {
                    this.withElementId(elementIdValue);
                }
                if ((bits & 2L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 2L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withElementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public Builder clear() {
            this.processInstanceKey = 0L;
            this.tenantId = null;
            this.elementId = null;
            return this;
        }

        public ImmutableRuntimeInstructionRecordValue build() {
            return new ImmutableRuntimeInstructionRecordValue(this.processInstanceKey, this.tenantId, this.elementId);
        }
    }
}

