/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

public enum JobResultType {
    USER_TASK("userTask"),
    AD_HOC_SUB_PROCESS("adHocSubProcess");

    final String type;

    private JobResultType(String type) {
        this.type = type;
    }

    public static JobResultType from(String resultType) {
        if (resultType == null || resultType.isEmpty()) {
            return USER_TASK;
        }
        for (JobResultType type : JobResultType.values()) {
            if (!type.type.equals(resultType)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown job result type: " + resultType);
    }
}

