/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.scaling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.BatchOperationErrorType;
import io.camunda.zeebe.protocol.record.value.scaling.BatchOperationErrorValue;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="BatchOperationErrorValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableBatchOperationErrorValue
implements BatchOperationErrorValue {
    private final int partitionId;
    private final BatchOperationErrorType type;
    private final String message;
    private transient int hashCode;

    private ImmutableBatchOperationErrorValue(int partitionId, BatchOperationErrorType type, String message) {
        this.partitionId = partitionId;
        this.type = type;
        this.message = message;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public BatchOperationErrorType getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public final ImmutableBatchOperationErrorValue withPartitionId(int value) {
        if (this.partitionId == value) {
            return this;
        }
        return new ImmutableBatchOperationErrorValue(value, this.type, this.message);
    }

    public final ImmutableBatchOperationErrorValue withType(BatchOperationErrorType value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableBatchOperationErrorValue(this.partitionId, value, this.message);
    }

    public final ImmutableBatchOperationErrorValue withMessage(String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableBatchOperationErrorValue(this.partitionId, this.type, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBatchOperationErrorValue && this.equalTo(0, (ImmutableBatchOperationErrorValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableBatchOperationErrorValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.partitionId == another.partitionId && Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.message, another.message);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.partitionId;
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.message);
        return h;
    }

    public String toString() {
        return "BatchOperationErrorValue{partitionId=" + this.partitionId + ", type=" + (Object)((Object)this.type) + ", message=" + this.message + "}";
    }

    public static ImmutableBatchOperationErrorValue copyOf(BatchOperationErrorValue instance) {
        if (instance instanceof ImmutableBatchOperationErrorValue) {
            return (ImmutableBatchOperationErrorValue)instance;
        }
        return ImmutableBatchOperationErrorValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="BatchOperationErrorValue", generator="Immutables")
    public static final class Builder {
        private int partitionId;
        private BatchOperationErrorType type;
        private String message;

        private Builder() {
        }

        public final Builder from(BatchOperationErrorValue instance) {
            String messageValue;
            Objects.requireNonNull(instance, "instance");
            this.withPartitionId(instance.getPartitionId());
            BatchOperationErrorType typeValue = instance.getType();
            if (typeValue != null) {
                this.withType(typeValue);
            }
            if ((messageValue = instance.getMessage()) != null) {
                this.withMessage(messageValue);
            }
            return this;
        }

        public final Builder withPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public final Builder withType(BatchOperationErrorType type) {
            this.type = type;
            return this;
        }

        public final Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder clear() {
            this.partitionId = 0;
            this.type = null;
            this.message = null;
            return this;
        }

        public ImmutableBatchOperationErrorValue build() {
            return new ImmutableBatchOperationErrorValue(this.partitionId, this.type, this.message);
        }
    }
}

