/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.ActorMetrics;
import io.camunda.zeebe.scheduler.ActorMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class ActorMetricsImpl
implements ActorMetrics {
    private final Map<ActorMetrics.SubscriptionType, Timer> schedulingLatency = new EnumMap<ActorMetrics.SubscriptionType, Timer>(ActorMetrics.SubscriptionType.class);
    private final MeterRegistry registry;

    public ActorMetricsImpl(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry cannot be null");
        for (ActorMetrics.SubscriptionType type : ActorMetrics.SubscriptionType.values()) {
            this.schedulingLatency.put(type, this.createSchedulingTimer(type));
        }
    }

    private Timer createSchedulingTimer(ActorMetrics.SubscriptionType subscriptionType) {
        return Timer.builder((String)ActorMetricsDoc.SCHEDULING_LATENCY.getName()).description(ActorMetricsDoc.SCHEDULING_LATENCY.getDescription()).tags(new String[]{ActorMetricsDoc.ActorMetricsKeyName.SUBSCRIPTION_TYPE.asString(), subscriptionType.getName()}).serviceLevelObjectives(ActorMetricsDoc.SCHEDULING_LATENCY.getTimerSLOs()).register(this.registry);
    }

    private Timer createExecutionTimer(String actorName) {
        return Timer.builder((String)ActorMetricsDoc.EXECUTION_LATENCY.getName()).description(ActorMetricsDoc.EXECUTION_LATENCY.getDescription()).tags(new String[]{ActorMetricsDoc.ActorMetricsKeyName.ACTOR_NAME.asString(), actorName}).serviceLevelObjectives(ActorMetricsDoc.EXECUTION_LATENCY.getTimerSLOs()).register(this.registry);
    }

    private Counter createExecutionCount(String actorName) {
        return Counter.builder((String)ActorMetricsDoc.EXECUTION_COUNT.getName()).description(ActorMetricsDoc.EXECUTION_COUNT.getDescription()).tag(ActorMetricsDoc.ActorMetricsKeyName.ACTOR_NAME.asString(), actorName).register(this.registry);
    }

    private Gauge createJobQueueLength(String actorName, AtomicLong value) {
        return Gauge.builder((String)ActorMetricsDoc.JOB_QUEUE_LENGTH.getName(), value::get).description(ActorMetricsDoc.JOB_QUEUE_LENGTH.getDescription()).tags(new String[]{ActorMetricsDoc.ActorMetricsKeyName.ACTOR_NAME.asString(), actorName}).register(this.registry);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public ActorMetrics.ActorMetricsScoped scoped(String actorName) {
        AtomicLong jobQueueLength = new AtomicLong(0L);
        return new ActorMetricsScopedEnabled(this.registry, this.createExecutionTimer(actorName), this.createJobQueueLength(actorName, jobQueueLength), jobQueueLength, this.createExecutionCount(actorName));
    }

    @Override
    public void observeJobSchedulingLatency(long waitTimeNs, ActorMetrics.SubscriptionType subscriptionType) {
        this.schedulingLatency.get((Object)subscriptionType).record(waitTimeNs, TimeUnit.NANOSECONDS);
    }

    record ActorMetricsScopedEnabled(MeterRegistry registry, Timer executionLatency, Gauge jobQueueLengthGauge, AtomicLong jobQueueLength, Counter executionCount) implements ActorMetrics.ActorMetricsScoped
    {
        public void close() {
            this.jobQueueLength.set(0L);
            this.registry.remove((Meter)this.executionLatency);
            this.registry.remove((Meter)this.jobQueueLengthGauge);
            this.registry.remove((Meter)this.executionCount);
        }

        @Override
        public void countExecution() {
            this.executionCount.increment();
        }

        @Override
        public void updateJobQueueLength(int length) {
            this.jobQueueLength.set(length);
        }

        @Override
        public CloseableSilently startExecutionTimer() {
            return MicrometerUtil.timer((Timer)this.executionLatency, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

