/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.clock;

import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

public final class ControlledActorClock
implements ActorClock {
    private final AtomicLong currentTime = new AtomicLong();
    private final AtomicLong currentOffset = new AtomicLong();
    private final AtomicLong updatedTime = new AtomicLong();

    public ControlledActorClock() {
        this.reset();
    }

    public void pinCurrentTime() {
        this.setCurrentTime(this.getCurrentTime());
    }

    public void addTime(Duration durationToAdd) {
        if (this.usesPointInTime()) {
            this.currentTime.addAndGet(durationToAdd.toMillis());
        } else {
            this.currentOffset.addAndGet(durationToAdd.toMillis());
        }
    }

    public void reset() {
        this.currentTime.set(-1L);
        this.currentOffset.set(0L);
        this.updatedTime.set(System.currentTimeMillis());
    }

    public Instant getCurrentTime() {
        return Instant.ofEpochMilli(this.getTimeMillis());
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime.set(currentTime);
    }

    public void setCurrentTime(Instant currentTime) {
        this.currentTime.set(currentTime.toEpochMilli());
    }

    private boolean usesPointInTime() {
        return this.currentTime.get() > 0L;
    }

    @Override
    public boolean update() {
        if (this.usesPointInTime()) {
            this.updatedTime.set(this.currentTime.get());
        } else {
            this.updatedTime.set(System.currentTimeMillis() + this.currentOffset.get());
        }
        return true;
    }

    @Override
    public long getTimeMillis() {
        return this.updatedTime.get();
    }

    @Override
    public long getNanosSinceLastMillisecond() {
        return 0L;
    }

    @Override
    public long getNanoTime() {
        return 0L;
    }

    public long getCurrentTimeInMillis() {
        return this.getTimeMillis();
    }
}

