/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.future;

import io.camunda.zeebe.scheduler.ActorTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ActorFuture<V>
extends Future<V>,
BiConsumer<V, Throwable> {
    public void complete(V var1);

    public void completeExceptionally(String var1, Throwable var2);

    public void completeExceptionally(Throwable var1);

    public V join();

    public V join(long var1, TimeUnit var3);

    public void block(ActorTask var1);

    public void onComplete(BiConsumer<V, Throwable> var1);

    public void onComplete(BiConsumer<V, Throwable> var1, Executor var2);

    default public void onSuccess(Consumer<V> handler) {
        this.onComplete((v, error) -> {
            if (error == null) {
                handler.accept(v);
            }
        });
    }

    default public void onSuccess(Consumer<V> handler, Executor executor) {
        this.onComplete((v, error) -> {
            if (error == null) {
                handler.accept(v);
            }
        }, executor);
    }

    default public void onError(Consumer<Throwable> handler) {
        this.onComplete((v, error) -> {
            if (error != null) {
                handler.accept((Throwable)error);
            }
        });
    }

    default public void onError(Consumer<Throwable> handler, Executor executor) {
        this.onComplete((v, error) -> {
            if (error != null) {
                handler.accept((Throwable)error);
            }
        }, executor);
    }

    public boolean isCompletedExceptionally();

    public Throwable getException();

    @Override
    default public void accept(V value, Throwable throwable) {
        if (throwable != null) {
            this.completeExceptionally(throwable);
        } else {
            this.complete(value);
        }
    }

    default public CompletableFuture<V> toCompletableFuture() {
        CompletableFuture future = new CompletableFuture();
        this.onComplete((status, error) -> {
            if (error == null) {
                future.complete(status);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, Runnable::run);
        return future;
    }

    public <U> ActorFuture<U> andThen(Supplier<ActorFuture<U>> var1, Executor var2);

    public <U> ActorFuture<U> andThen(Function<V, ActorFuture<U>> var1, Executor var2);

    public <U> ActorFuture<U> andThen(BiFunction<V, Throwable, ActorFuture<U>> var1, Executor var2);

    public <U> ActorFuture<U> thenApply(Function<V, U> var1, Executor var2);

    public <U> ActorFuture<U> thenApply(Function<V, U> var1);
}

