/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.health;

import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.util.health.ComponentTreeListener;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitor;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthReport;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;

public class CriticalComponentsHealthMonitor
implements HealthMonitor {
    private static final Duration HEALTH_MONITORING_PERIOD = Duration.ofSeconds(60L);
    private final Map<String, MonitoredComponent> monitoredComponents = new HashMap<String, MonitoredComponent>();
    private final Map<String, HealthReport> componentHealth = new HashMap<String, HealthReport>();
    private final Set<FailureListener> failureListeners = new HashSet<FailureListener>();
    private final ActorControl actor;
    private final Logger log;
    private volatile HealthReport healthReport;
    private final String name;
    private final Duration monitoringInterval;
    private final ComponentTreeListener graphListener;

    public CriticalComponentsHealthMonitor(String name, ActorControl actor, ComponentTreeListener healthGraphMetrics, Optional<String> parentComponent, Logger log) {
        this(name, actor, healthGraphMetrics, parentComponent, log, HEALTH_MONITORING_PERIOD);
    }

    public CriticalComponentsHealthMonitor(String name, ActorControl actor, ComponentTreeListener graphListener, Optional<String> parentComponent, Logger log, Duration monitoringInterval) {
        this.name = name;
        this.actor = actor;
        this.log = log;
        this.graphListener = graphListener;
        this.monitoringInterval = monitoringInterval;
        this.healthReport = HealthReport.unhealthy((HealthMonitorable)this).withMessage("Components are not yet initialized", Instant.now());
        this.graphListener.registerNode((HealthMonitorable)this, parentComponent);
    }

    public void startMonitoring() {
        long initialDelay = Math.max(5L, this.monitoringInterval.toSeconds() / 5L);
        this.actor.schedule(Duration.ofSeconds(initialDelay), this::updateHealth);
        this.actor.runAtFixedRate(this.monitoringInterval, this::updateHealth);
    }

    public void monitorComponent(String componentName) {
        this.actor.run(() -> this.componentHealth.put(componentName, HealthReport.unknown((String)componentName)));
    }

    public void registerComponent(HealthMonitorable component) {
        this.actor.run(() -> {
            String componentName = component.componentName();
            MonitoredComponent monitoredComponent = new MonitoredComponent(componentName, component);
            this.monitoredComponents.put(componentName, monitoredComponent);
            this.componentHealth.put(componentName, component.getHealthReport());
            component.addFailureListener((FailureListener)monitoredComponent);
            this.calculateHealth();
            this.graphListener.registerNode(component, (HealthMonitorable)this);
            this.log.trace("Registered component {}:{}", (Object)componentName, (Object)component.componentName());
        });
    }

    public void removeComponent(HealthMonitorable component) {
        this.actor.run(() -> {
            String componentName = component.componentName();
            MonitoredComponent monitoredComponent = this.monitoredComponents.remove(componentName);
            if (monitoredComponent != null) {
                this.componentHealth.remove(componentName);
                monitoredComponent.component.removeFailureListener((FailureListener)monitoredComponent);
                this.graphListener.unregisterRelationship(componentName, this.name);
                this.graphListener.unregisterNode(monitoredComponent.component);
                this.log.trace("Unregistered edge {}:{}", (Object)this.name, (Object)componentName);
                this.calculateHealth();
            }
        });
    }

    public String componentName() {
        return this.name;
    }

    public HealthReport getHealthReport() {
        return this.healthReport;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.add(failureListener));
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.remove(failureListener));
    }

    private void updateHealth() {
        this.componentHealth.keySet().forEach(component -> this.componentHealth.put((String)component, this.getHealth((String)component)));
        this.calculateHealth();
    }

    private void calculateHealth() {
        HealthReport previousReport = this.healthReport;
        this.healthReport = this.calculateStatus();
        if (previousReport.equals((Object)this.healthReport)) {
            return;
        }
        this.failureListeners.forEach(l -> l.onHealthReport(this.healthReport));
        this.logComponentStatus(this.healthReport);
    }

    private void logComponentStatus(HealthReport status) {
        this.log.debug("Detected '{}' components. The current health status of components: {}", (Object)status.getStatus(), this.componentHealth.values());
    }

    private HealthReport calculateStatus() {
        return HealthReport.fromChildrenStatus((String)this.name, this.componentHealth).orElse(HealthReport.unknown((String)this.name));
    }

    private HealthReport getHealth(String componentName) {
        MonitoredComponent monitoredComponent = this.monitoredComponents.get(componentName);
        if (monitoredComponent != null) {
            return monitoredComponent.component.getHealthReport();
        }
        return HealthReport.unknown((String)componentName);
    }

    private final class MonitoredComponent
    implements FailureListener {
        private final String componentName;
        private final HealthMonitorable component;

        private MonitoredComponent(String componentName, HealthMonitorable component) {
            this.componentName = componentName;
            this.component = component;
        }

        public void onFailure(HealthReport report) {
            CriticalComponentsHealthMonitor.this.actor.run(() -> this.onComponentFailure(report));
        }

        public void onRecovered(HealthReport report) {
            CriticalComponentsHealthMonitor.this.actor.run(() -> this.onComponentRecovered(report));
        }

        public void onUnrecoverableFailure(HealthReport report) {
            CriticalComponentsHealthMonitor.this.actor.run(() -> this.onComponentDied(report));
        }

        private void onComponentFailure(HealthReport report) {
            if (!CriticalComponentsHealthMonitor.this.monitoredComponents.containsKey(this.componentName)) {
                return;
            }
            CriticalComponentsHealthMonitor.this.log.warn("{} failed, marking it as unhealthy: {}", (Object)this.componentName, (Object)report);
            CriticalComponentsHealthMonitor.this.componentHealth.put(this.componentName, report);
            CriticalComponentsHealthMonitor.this.calculateHealth();
            CriticalComponentsHealthMonitor.this.failureListeners.forEach(l -> l.onFailure(CriticalComponentsHealthMonitor.this.getHealthReport()));
        }

        private void onComponentRecovered(HealthReport healthReport) {
            if (!CriticalComponentsHealthMonitor.this.monitoredComponents.containsKey(this.componentName)) {
                return;
            }
            CriticalComponentsHealthMonitor.this.log.info("{} recovered, marking it as healthy", (Object)this.componentName);
            CriticalComponentsHealthMonitor.this.componentHealth.put(this.componentName, healthReport);
            CriticalComponentsHealthMonitor.this.calculateHealth();
            CriticalComponentsHealthMonitor.this.failureListeners.forEach(l -> l.onRecovered(CriticalComponentsHealthMonitor.this.getHealthReport()));
        }

        private void onComponentDied(HealthReport report) {
            if (!CriticalComponentsHealthMonitor.this.monitoredComponents.containsKey(this.componentName)) {
                return;
            }
            CriticalComponentsHealthMonitor.this.log.error("{} failed, marking it as dead: {}", (Object)this.componentName, (Object)report);
            CriticalComponentsHealthMonitor.this.componentHealth.put(this.componentName, report);
            CriticalComponentsHealthMonitor.this.calculateHealth();
            CriticalComponentsHealthMonitor.this.failureListeners.forEach(l -> l.onUnrecoverableFailure(CriticalComponentsHealthMonitor.this.getHealthReport()));
        }
    }
}

