/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnStreamProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.message.PendingProcessMessageSubscriptionChecker;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionCorrelateProcessor;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionCreateProcessor;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionDeleteProcessor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceBatchActivateProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceBatchTerminateProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCancelProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCreationCreateProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCreationCreateWithResultProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceMigrationMigrateProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceModificationModifyProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.processing.timer.TimerCancelProcessor;
import io.camunda.zeebe.engine.processing.timer.TimerTriggerProcessor;
import io.camunda.zeebe.engine.processing.variable.VariableDocumentUpdateProcessor;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceBatchIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import java.util.Arrays;
import java.util.function.Supplier;

public final class BpmnProcessors {
    public static TypedRecordProcessor<ProcessInstanceRecord> addBpmnStreamProcessor(MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskState, BpmnBehaviors bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, DueDateTimerChecker timerChecker, Writers writers) {
        MutableProcessMessageSubscriptionState subscriptionState = processingState.getProcessMessageSubscriptionState();
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        ProcessEngineMetrics processEngineMetrics = new ProcessEngineMetrics(processingState.getPartitionId());
        BpmnProcessors.addProcessInstanceCommandProcessor(writers, typedRecordProcessors, processingState);
        BpmnStreamProcessor bpmnStreamProcessor = new BpmnStreamProcessor(bpmnBehaviors, processingState, writers, processEngineMetrics);
        BpmnProcessors.addBpmnStepProcessor(typedRecordProcessors, bpmnStreamProcessor);
        BpmnProcessors.addMessageStreamProcessors(typedRecordProcessors, subscriptionState, subscriptionCommandSender, bpmnBehaviors, processingState, scheduledTaskState, writers);
        BpmnProcessors.addTimerStreamProcessors(typedRecordProcessors, timerChecker, processingState, bpmnBehaviors, writers);
        BpmnProcessors.addVariableDocumentStreamProcessors(typedRecordProcessors, bpmnBehaviors, processingState.getElementInstanceState(), keyGenerator, writers);
        BpmnProcessors.addProcessInstanceCreationStreamProcessors(typedRecordProcessors, processingState, writers, bpmnBehaviors, processEngineMetrics);
        BpmnProcessors.addProcessInstanceModificationStreamProcessors(typedRecordProcessors, processingState, writers, bpmnBehaviors);
        BpmnProcessors.addProcessInstanceMigrationStreamProcessors(typedRecordProcessors, processingState, writers, bpmnBehaviors);
        BpmnProcessors.addProcessInstanceBatchStreamProcessors(typedRecordProcessors, processingState, writers);
        return bpmnStreamProcessor;
    }

    private static void addProcessInstanceCommandProcessor(Writers writers, TypedRecordProcessors typedRecordProcessors, ProcessingState processingState) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)ProcessInstanceIntent.CANCEL, new ProcessInstanceCancelProcessor(processingState, writers));
    }

    private static void addBpmnStepProcessor(TypedRecordProcessors typedRecordProcessors, BpmnStreamProcessor bpmnStepProcessor) {
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isBpmnElementCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, bpmnStepProcessor));
    }

    private static void addMessageStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessMessageSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, BpmnBehaviors bpmnBehaviors, MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskState, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CREATE, new ProcessMessageSubscriptionCreateProcessor(processingState.getProcessMessageSubscriptionState(), writers)).onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CORRELATE, new ProcessMessageSubscriptionCorrelateProcessor(subscriptionState, subscriptionCommandSender, processingState, bpmnBehaviors, writers)).onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.DELETE, new ProcessMessageSubscriptionDeleteProcessor(subscriptionState, writers)).withListener(new PendingProcessMessageSubscriptionChecker(subscriptionCommandSender, scheduledTaskState.get().getPendingProcessMessageSubscriptionState()));
    }

    private static void addTimerStreamProcessors(TypedRecordProcessors typedRecordProcessors, DueDateTimerChecker timerChecker, MutableProcessingState processingState, BpmnBehaviors bpmnBehaviors, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.TIMER, (Intent)TimerIntent.TRIGGER, new TimerTriggerProcessor(processingState, bpmnBehaviors, writers)).onCommand(ValueType.TIMER, (Intent)TimerIntent.CANCEL, new TimerCancelProcessor(processingState.getTimerState(), writers.state(), writers.rejection())).withListener(timerChecker);
    }

    private static void addVariableDocumentStreamProcessors(TypedRecordProcessors typedRecordProcessors, BpmnBehaviors bpmnBehaviors, ElementInstanceState elementInstanceState, KeyGenerator keyGenerator, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.VARIABLE_DOCUMENT, (Intent)VariableDocumentIntent.UPDATE, new VariableDocumentUpdateProcessor(elementInstanceState, keyGenerator, bpmnBehaviors.variableBehavior(), writers));
    }

    private static void addProcessInstanceCreationStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessingState processingState, Writers writers, BpmnBehaviors bpmnBehaviors, ProcessEngineMetrics metrics) {
        MutableElementInstanceState elementInstanceState = processingState.getElementInstanceState();
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        ProcessInstanceCreationCreateProcessor createProcessor = new ProcessInstanceCreationCreateProcessor(processingState.getProcessState(), keyGenerator, writers, bpmnBehaviors, metrics);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE, createProcessor);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, new ProcessInstanceCreationCreateWithResultProcessor(createProcessor, elementInstanceState));
    }

    private static void addProcessInstanceModificationStreamProcessors(TypedRecordProcessors typedRecordProcessors, ProcessingState processingState, Writers writers, BpmnBehaviors bpmnBehaviors) {
        ProcessInstanceModificationModifyProcessor modificationProcessor = new ProcessInstanceModificationModifyProcessor(writers, processingState.getElementInstanceState(), processingState.getProcessState(), bpmnBehaviors);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_MODIFICATION, (Intent)ProcessInstanceModificationIntent.MODIFY, modificationProcessor);
    }

    private static void addProcessInstanceMigrationStreamProcessors(TypedRecordProcessors typedRecordProcessors, ProcessingState processingState, Writers writers, BpmnBehaviors bpmnBehaviors) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_MIGRATION, (Intent)ProcessInstanceMigrationIntent.MIGRATE, new ProcessInstanceMigrationMigrateProcessor(writers, processingState, bpmnBehaviors));
    }

    private static void addProcessInstanceBatchStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessingState processingState, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_BATCH, (Intent)ProcessInstanceBatchIntent.TERMINATE, new ProcessInstanceBatchTerminateProcessor(writers, processingState.getKeyGenerator(), processingState.getElementInstanceState())).onCommand(ValueType.PROCESS_INSTANCE_BATCH, (Intent)ProcessInstanceBatchIntent.ACTIVATE, new ProcessInstanceBatchActivateProcessor(writers, processingState.getKeyGenerator(), processingState.getElementInstanceState(), processingState.getProcessState()));
    }
}

