/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.util.Either;

public final class SubProcessProcessor
implements BpmnElementContainerProcessor<ExecutableFlowElementContainer> {
    private static final String NO_NONE_START_EVENT_ERROR_MSG = "Expected to activate none start event, but no none start event found in sub process";
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;

    public SubProcessProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
    }

    @Override
    public Class<ExecutableFlowElementContainer> getType() {
        return ExecutableFlowElementContainer.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableFlowElementContainer element, BpmnElementContext activating) {
        return this.variableMappingBehavior.applyInputMappings(activating, element).thenDo(ok -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            ExecutableStartEvent startEvent = element.getNoneStartEvent();
            if (startEvent == null) {
                throw new BpmnProcessingException(activated, NO_NONE_START_EVENT_ERROR_MSG);
            }
            this.stateTransitionBehavior.activateChildInstance(activated, startEvent);
        });
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableFlowElementContainer element, BpmnElementContext completing) {
        return this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(completing);
            this.compensationSubscriptionBehaviour.createCompensationSubscription(element, completing);
            return this.stateTransitionBehavior.transitionToCompleted(element, completing);
        }).thenDo(completed -> {
            this.compensationSubscriptionBehaviour.completeCompensationHandler((BpmnElementContext)completed);
            this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed);
        });
    }

    @Override
    public void onTerminate(ExecutableFlowElementContainer element, BpmnElementContext terminating) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(terminating);
        this.incidentBehavior.resolveIncidents(terminating);
        this.compensationSubscriptionBehaviour.deleteSubscriptionsOfSubprocess(terminating);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(terminating);
        if (noActiveChildInstances) {
            this.onChildTerminated(element, terminating, (BpmnElementContext)null);
        }
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        if (this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableFlowElementContainer element, BpmnElementContext subProcessContext, BpmnElementContext childContext) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(subProcessContext);
        ElementInstance subProcessInstance = this.stateBehavior.getElementInstance(subProcessContext);
        boolean interruptedByTerminateEndEvent = this.stateBehavior.isInterruptedByTerminateEndEvent(subProcessContext, subProcessInstance);
        if (this.stateBehavior.isInterrupted(subProcessContext) && !interruptedByTerminateEndEvent) {
            this.eventSubscriptionBehavior.findEventTrigger(subProcessContext).ifPresent(eventTrigger -> this.eventSubscriptionBehavior.activateTriggeredEvent(subProcessContext.getElementInstanceKey(), subProcessContext.getElementInstanceKey(), (EventTrigger)((Object)eventTrigger), subProcessContext));
        } else if (childContext == null || this.stateBehavior.canBeTerminated(childContext)) {
            this.eventSubscriptionBehavior.findEventTrigger(subProcessContext).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
                BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(subProcessContext, element.getEventType());
                this.eventSubscriptionBehavior.activateTriggeredEvent(subProcessContext.getElementInstanceKey(), subProcessContext.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
            }, () -> {
                if (subProcessInstance.isTerminating()) {
                    BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(subProcessContext, element.getEventType());
                    this.stateTransitionBehavior.onElementTerminated(element, terminated);
                } else if (interruptedByTerminateEndEvent) {
                    this.stateTransitionBehavior.completeElement(subProcessContext);
                }
            });
        }
    }
}

