/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableUserTask;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.deployment.model.element.UserTaskProperties;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.ExpressionTransformer;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeAssignmentDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeFormDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeHeader;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskSchedule;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeUserTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class UserTaskTransformer
implements ModelElementTransformer<UserTask> {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final ExpressionLanguage expressionLanguage;

    public UserTaskTransformer(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public Class<UserTask> getType() {
        return UserTask.class;
    }

    @Override
    public void transform(UserTask element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableUserTask userTask = process.getElementById(element.getId(), ExecutableUserTask.class);
        UserTaskProperties userTaskProperties = new UserTaskProperties();
        boolean isZeebeUserTask = element.getSingleExtensionElement(ZeebeUserTask.class) != null;
        this.transformAssignmentDefinition(element, userTaskProperties);
        this.transformTaskSchedule(element, userTaskProperties);
        this.transformTaskFormId(element, userTaskProperties);
        this.transformModelTaskHeaders(element, userTaskProperties);
        if (isZeebeUserTask) {
            this.transformExternalReference(element, userTaskProperties);
            userTask.setUserTaskProperties(userTaskProperties);
        } else {
            JobWorkerProperties jobWorkerProperties = new JobWorkerProperties();
            jobWorkerProperties.wrap(userTaskProperties);
            this.addZeebeUserTaskFormKeyHeader(element, jobWorkerProperties.getTaskHeaders());
            this.transformTaskDefinition(jobWorkerProperties);
            userTask.setJobWorkerProperties(jobWorkerProperties);
        }
    }

    private void transformTaskDefinition(JobWorkerProperties jobWorkerProperties) {
        jobWorkerProperties.setType((Expression)new StaticExpression("io.camunda.zeebe:userTask"));
        jobWorkerProperties.setRetries((Expression)new StaticExpression("1"));
    }

    private void transformAssignmentDefinition(UserTask element, UserTaskProperties userTaskProperties) {
        ZeebeAssignmentDefinition assignmentDefinition = (ZeebeAssignmentDefinition)element.getSingleExtensionElement(ZeebeAssignmentDefinition.class);
        if (assignmentDefinition == null) {
            return;
        }
        this.transformAssignee(userTaskProperties, assignmentDefinition);
        this.transformCandidateGroups(userTaskProperties, assignmentDefinition);
        this.transformCandidateUsers(userTaskProperties, assignmentDefinition);
    }

    private void transformModelTaskHeaders(UserTask element, UserTaskProperties userTaskProperties) {
        HashMap<String, String> taskHeaders = new HashMap<String, String>();
        this.collectModelTaskHeaders(element, taskHeaders);
        userTaskProperties.setTaskHeaders(taskHeaders);
    }

    private void addZeebeUserTaskFormKeyHeader(UserTask element, Map<String, String> taskHeaders) {
        ZeebeFormDefinition formDefinition = (ZeebeFormDefinition)element.getSingleExtensionElement(ZeebeFormDefinition.class);
        if (formDefinition != null && formDefinition.getFormKey() != null) {
            taskHeaders.put("io.camunda.zeebe:formKey", formDefinition.getFormKey());
        }
    }

    private void collectModelTaskHeaders(UserTask element, Map<String, String> taskHeaders) {
        ZeebeTaskHeaders modelTaskHeaders = (ZeebeTaskHeaders)element.getSingleExtensionElement(ZeebeTaskHeaders.class);
        if (modelTaskHeaders != null) {
            List<ZeebeHeader> validHeaders = modelTaskHeaders.getHeaders().stream().filter(this::isValidHeader).toList();
            if (validHeaders.size() < modelTaskHeaders.getHeaders().size()) {
                LOG.warn("Ignoring invalid headers for task '{}'. Must have non-empty key and value.", (Object)element.getName());
            }
            validHeaders.forEach(h -> taskHeaders.put(h.getKey(), h.getValue()));
        }
    }

    private boolean isValidHeader(ZeebeHeader header) {
        return header != null && this.isValidHeader(header.getKey(), header.getValue());
    }

    private boolean isValidHeader(String key, String value) {
        return key != null && !key.isEmpty() && value != null && !value.isEmpty();
    }

    private void transformAssignee(UserTaskProperties userTaskProperties, ZeebeAssignmentDefinition assignmentDefinition) {
        String assignee = assignmentDefinition.getAssignee();
        if (assignee != null && !assignee.isBlank()) {
            Expression assigneeExpression = this.expressionLanguage.parseExpression(assignee);
            if (assigneeExpression.isStatic()) {
                userTaskProperties.setAssignee(this.expressionLanguage.parseExpression(ExpressionTransformer.asFeelExpressionString(ExpressionTransformer.asStringLiteral(assignee))));
            } else {
                userTaskProperties.setAssignee(assigneeExpression);
            }
        }
    }

    private void transformCandidateGroups(UserTaskProperties userTaskProperties, ZeebeAssignmentDefinition assignmentDefinition) {
        String candidateGroups = assignmentDefinition.getCandidateGroups();
        if (candidateGroups != null && !candidateGroups.isBlank()) {
            Expression candidateGroupsExpression = this.expressionLanguage.parseExpression(candidateGroups);
            if (candidateGroupsExpression.isStatic()) {
                userTaskProperties.setCandidateGroups((Expression)ExpressionTransformer.parseListOfCsv(candidateGroups).map(ExpressionTransformer::asListLiteral).map(ExpressionTransformer::asFeelExpressionString).map(arg_0 -> ((ExpressionLanguage)this.expressionLanguage).parseExpression(arg_0)).get());
            } else {
                userTaskProperties.setCandidateGroups(candidateGroupsExpression);
            }
        }
    }

    private void transformCandidateUsers(UserTaskProperties userTaskProperties, ZeebeAssignmentDefinition assignmentDefinition) {
        String candidateUsers = assignmentDefinition.getCandidateUsers();
        if (candidateUsers != null && !candidateUsers.isBlank()) {
            Expression candidateUsersExpression = this.expressionLanguage.parseExpression(candidateUsers);
            if (candidateUsersExpression.isStatic()) {
                userTaskProperties.setCandidateUsers((Expression)ExpressionTransformer.parseListOfCsv(candidateUsers).map(ExpressionTransformer::asListLiteral).map(ExpressionTransformer::asFeelExpressionString).map(arg_0 -> ((ExpressionLanguage)this.expressionLanguage).parseExpression(arg_0)).get());
            } else {
                userTaskProperties.setCandidateUsers(candidateUsersExpression);
            }
        }
    }

    private void transformTaskSchedule(UserTask element, UserTaskProperties userTaskProperties) {
        String followUpDate;
        ZeebeTaskSchedule taskSchedule = (ZeebeTaskSchedule)element.getSingleExtensionElement(ZeebeTaskSchedule.class);
        if (taskSchedule == null) {
            return;
        }
        String dueDate = taskSchedule.getDueDate();
        if (dueDate != null && !dueDate.isBlank()) {
            userTaskProperties.setDueDate(this.expressionLanguage.parseExpression(dueDate));
        }
        if ((followUpDate = taskSchedule.getFollowUpDate()) != null && !followUpDate.isBlank()) {
            userTaskProperties.setFollowUpDate(this.expressionLanguage.parseExpression(followUpDate));
        }
    }

    private void transformTaskFormId(UserTask element, UserTaskProperties userTaskProperties) {
        ZeebeFormDefinition formDefinition = (ZeebeFormDefinition)element.getSingleExtensionElement(ZeebeFormDefinition.class);
        if (formDefinition != null && formDefinition.getFormId() != null) {
            userTaskProperties.setFormId(this.expressionLanguage.parseExpression(formDefinition.getFormId()));
        }
    }

    private void transformExternalReference(UserTask element, UserTaskProperties userTaskProperties) {
        String externalReference;
        ZeebeFormDefinition formDefinition = (ZeebeFormDefinition)element.getSingleExtensionElement(ZeebeFormDefinition.class);
        if (formDefinition != null && (externalReference = formDefinition.getExternalReference()) != null && !externalReference.isBlank()) {
            Expression externalReferenceExpression = this.expressionLanguage.parseExpression(externalReference);
            if (externalReferenceExpression.isStatic()) {
                userTaskProperties.setExternalFormReference(this.expressionLanguage.parseExpression(ExpressionTransformer.asFeelExpressionString(ExpressionTransformer.asStringLiteral(externalReference))));
            } else {
                userTaskProperties.setExternalFormReference(externalReferenceExpression);
            }
        }
    }
}

