/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public class JobUpdateTimeoutProcessor
implements TypedRecordProcessor<JobRecord> {
    public static final String NO_JOB_FOUND_MESSAGE = "Expected to update job deadline with key '%d', but no such job was found";
    public static final String NO_DEADLINE_FOUND_MESSAGE = "Expected to update the timeout of job with key '%d', but it is not active";
    private final JobState jobState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;

    public JobUpdateTimeoutProcessor(ProcessingState state, Writers writers) {
        this.jobState = state.getJobState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> command) {
        JobRecord value = (JobRecord)command.getValue();
        long jobKey = command.getKey();
        JobRecord job = this.jobState.getJob(jobKey, command.getAuthorizations());
        if (job == null) {
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, NO_JOB_FOUND_MESSAGE.formatted(jobKey));
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, NO_JOB_FOUND_MESSAGE.formatted(jobKey));
            return;
        }
        long oldDeadline = job.getDeadline();
        if (!this.jobState.jobDeadlineExists(jobKey, oldDeadline)) {
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_STATE, NO_DEADLINE_FOUND_MESSAGE.formatted(jobKey));
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_STATE, NO_DEADLINE_FOUND_MESSAGE.formatted(jobKey));
            return;
        }
        long newDeadline = ActorClock.currentTimeMillis() + value.getTimeout();
        job.setDeadline(newDeadline);
        this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.TIMEOUT_UPDATED, (RecordValue)job);
        this.responseWriter.writeEventOnCommand(jobKey, (Intent)JobIntent.TIMEOUT_UPDATED, (UnpackedObject)job, command);
    }
}

